/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.organizations.DefaultOrganizationsBaseClientBuilder;
import software.amazon.awssdk.services.organizations.DefaultOrganizationsClient;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.OrganizationsClientBuilder;
import software.amazon.awssdk.services.organizations.OrganizationsServiceClientConfiguration;
import software.amazon.awssdk.services.organizations.endpoints.OrganizationsEndpointProvider;

@SdkInternalApi
final class DefaultOrganizationsClientBuilder
extends DefaultOrganizationsBaseClientBuilder<OrganizationsClientBuilder, OrganizationsClient>
implements OrganizationsClientBuilder {
    DefaultOrganizationsClientBuilder() {
    }

    @Override
    public DefaultOrganizationsClientBuilder endpointProvider(OrganizationsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OrganizationsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOrganizationsClientBuilder.validateClientOptions(clientConfiguration);
        OrganizationsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOrganizationsClient client = new DefaultOrganizationsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OrganizationsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OrganizationsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

