/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opsworks.DefaultOpsWorksBaseClientBuilder;
import software.amazon.awssdk.services.opsworks.DefaultOpsWorksClient;
import software.amazon.awssdk.services.opsworks.OpsWorksClient;
import software.amazon.awssdk.services.opsworks.OpsWorksClientBuilder;
import software.amazon.awssdk.services.opsworks.OpsWorksServiceClientConfiguration;
import software.amazon.awssdk.services.opsworks.endpoints.OpsWorksEndpointProvider;

@SdkInternalApi
final class DefaultOpsWorksClientBuilder
extends DefaultOpsWorksBaseClientBuilder<OpsWorksClientBuilder, OpsWorksClient>
implements OpsWorksClientBuilder {
    DefaultOpsWorksClientBuilder() {
    }

    @Override
    public DefaultOpsWorksClientBuilder endpointProvider(OpsWorksEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpsWorksClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOpsWorksClientBuilder.validateClientOptions(clientConfiguration);
        OpsWorksServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOpsWorksClient client = new DefaultOpsWorksClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OpsWorksServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OpsWorksServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

