/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an OpenSearch Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstance.Builder, ReservedInstance> {
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationName").getter(getter(ReservedInstance::reservationName))
            .setter(setter(Builder::reservationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()).build();

    private static final SdkField<String> RESERVED_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstanceId").getter(getter(ReservedInstance::reservedInstanceId))
            .setter(setter(Builder::reservedInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId").build())
            .build();

    private static final SdkField<Long> BILLING_SUBSCRIPTION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BillingSubscriptionId").getter(getter(ReservedInstance::billingSubscriptionId))
            .setter(setter(Builder::billingSubscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingSubscriptionId").build())
            .build();

    private static final SdkField<String> RESERVED_INSTANCE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstanceOfferingId")
            .getter(getter(ReservedInstance::reservedInstanceOfferingId))
            .setter(setter(Builder::reservedInstanceOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceOfferingId").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ReservedInstance::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ReservedInstance::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(ReservedInstance::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FixedPrice").getter(getter(ReservedInstance::fixedPrice)).setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()).build();

    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UsagePrice").getter(getter(ReservedInstance::usagePrice)).setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ReservedInstance::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(ReservedInstance::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ReservedInstance::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaymentOption").getter(getter(ReservedInstance::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .memberName("RecurringCharges")
            .getter(getter(ReservedInstance::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_NAME_FIELD,
            RESERVED_INSTANCE_ID_FIELD, BILLING_SUBSCRIPTION_ID_FIELD, RESERVED_INSTANCE_OFFERING_ID_FIELD, INSTANCE_TYPE_FIELD,
            START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, INSTANCE_COUNT_FIELD,
            STATE_FIELD, PAYMENT_OPTION_FIELD, RECURRING_CHARGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reservationName;

    private final String reservedInstanceId;

    private final Long billingSubscriptionId;

    private final String reservedInstanceOfferingId;

    private final String instanceType;

    private final Instant startTime;

    private final Integer duration;

    private final Double fixedPrice;

    private final Double usagePrice;

    private final String currencyCode;

    private final Integer instanceCount;

    private final String state;

    private final String paymentOption;

    private final List<RecurringCharge> recurringCharges;

    private ReservedInstance(BuilderImpl builder) {
        this.reservationName = builder.reservationName;
        this.reservedInstanceId = builder.reservedInstanceId;
        this.billingSubscriptionId = builder.billingSubscriptionId;
        this.reservedInstanceOfferingId = builder.reservedInstanceOfferingId;
        this.instanceType = builder.instanceType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceCount = builder.instanceCount;
        this.state = builder.state;
        this.paymentOption = builder.paymentOption;
        this.recurringCharges = builder.recurringCharges;
    }

    /**
     * <p>
     * The customer-specified identifier to track this reservation.
     * </p>
     * 
     * @return The customer-specified identifier to track this reservation.
     */
    public final String reservationName() {
        return reservationName;
    }

    /**
     * <p>
     * The unique identifier for the reservation.
     * </p>
     * 
     * @return The unique identifier for the reservation.
     */
    public final String reservedInstanceId() {
        return reservedInstanceId;
    }

    /**
     * <p>
     * The unique identifier of the billing subscription.
     * </p>
     * 
     * @return The unique identifier of the billing subscription.
     */
    public final Long billingSubscriptionId() {
        return billingSubscriptionId;
    }

    /**
     * <p>
     * The unique identifier of the Reserved Instance offering.
     * </p>
     * 
     * @return The unique identifier of the Reserved Instance offering.
     */
    public final String reservedInstanceOfferingId() {
        return reservedInstanceOfferingId;
    }

    /**
     * <p>
     * The OpenSearch instance type offered by theReserved Instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link OpenSearchPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The OpenSearch instance type offered by theReserved Instance offering.
     * @see OpenSearchPartitionInstanceType
     */
    public final OpenSearchPartitionInstanceType instanceType() {
        return OpenSearchPartitionInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The OpenSearch instance type offered by theReserved Instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link OpenSearchPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The OpenSearch instance type offered by theReserved Instance offering.
     * @see OpenSearchPartitionInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The date and time when the reservation was purchased.
     * </p>
     * 
     * @return The date and time when the reservation was purchased.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The duration, in seconds, for which the OpenSearch instance is reserved.
     * </p>
     * 
     * @return The duration, in seconds, for which the OpenSearch instance is reserved.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The upfront fixed charge you will paid to purchase the specific Reserved Instance offering.
     * </p>
     * 
     * @return The upfront fixed charge you will paid to purchase the specific Reserved Instance offering.
     */
    public final Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The hourly rate at which you're charged for the domain using this Reserved Instance.
     * </p>
     * 
     * @return The hourly rate at which you're charged for the domain using this Reserved Instance.
     */
    public final Double usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency code for the offering.
     * </p>
     * 
     * @return The currency code for the offering.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The number of OpenSearch instances that have been reserved.
     * </p>
     * 
     * @return The number of OpenSearch instances that have been reserved.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The state of the Reserved Instance.
     * </p>
     * 
     * @return The state of the Reserved Instance.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The payment option as defined in the Reserved Instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link ReservedInstancePaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option as defined in the Reserved Instance offering.
     * @see ReservedInstancePaymentOption
     */
    public final ReservedInstancePaymentOption paymentOption() {
        return ReservedInstancePaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option as defined in the Reserved Instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link ReservedInstancePaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option as defined in the Reserved Instance offering.
     * @see ReservedInstancePaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecurringCharges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recurring charge to your account, regardless of whether you create any domains using the Reserved Instance
     * offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecurringCharges} method.
     * </p>
     * 
     * @return The recurring charge to your account, regardless of whether you create any domains using the Reserved
     *         Instance offering.
     */
    public final List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(billingSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecurringCharges() ? recurringCharges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstance)) {
            return false;
        }
        ReservedInstance other = (ReservedInstance) obj;
        return Objects.equals(reservationName(), other.reservationName())
                && Objects.equals(reservedInstanceId(), other.reservedInstanceId())
                && Objects.equals(billingSubscriptionId(), other.billingSubscriptionId())
                && Objects.equals(reservedInstanceOfferingId(), other.reservedInstanceOfferingId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(duration(), other.duration())
                && Objects.equals(fixedPrice(), other.fixedPrice()) && Objects.equals(usagePrice(), other.usagePrice())
                && Objects.equals(currencyCode(), other.currencyCode()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(state(), other.state())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && hasRecurringCharges() == other.hasRecurringCharges()
                && Objects.equals(recurringCharges(), other.recurringCharges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedInstance").add("ReservationName", reservationName())
                .add("ReservedInstanceId", reservedInstanceId()).add("BillingSubscriptionId", billingSubscriptionId())
                .add("ReservedInstanceOfferingId", reservedInstanceOfferingId()).add("InstanceType", instanceTypeAsString())
                .add("StartTime", startTime()).add("Duration", duration()).add("FixedPrice", fixedPrice())
                .add("UsagePrice", usagePrice()).add("CurrencyCode", currencyCode()).add("InstanceCount", instanceCount())
                .add("State", state()).add("PaymentOption", paymentOptionAsString())
                .add("RecurringCharges", hasRecurringCharges() ? recurringCharges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservationName":
            return Optional.ofNullable(clazz.cast(reservationName()));
        case "ReservedInstanceId":
            return Optional.ofNullable(clazz.cast(reservedInstanceId()));
        case "BillingSubscriptionId":
            return Optional.ofNullable(clazz.cast(billingSubscriptionId()));
        case "ReservedInstanceOfferingId":
            return Optional.ofNullable(clazz.cast(reservedInstanceOfferingId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstance, T> g) {
        return obj -> g.apply((ReservedInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstance> {
        /**
         * <p>
         * The customer-specified identifier to track this reservation.
         * </p>
         * 
         * @param reservationName
         *        The customer-specified identifier to track this reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationName(String reservationName);

        /**
         * <p>
         * The unique identifier for the reservation.
         * </p>
         * 
         * @param reservedInstanceId
         *        The unique identifier for the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceId(String reservedInstanceId);

        /**
         * <p>
         * The unique identifier of the billing subscription.
         * </p>
         * 
         * @param billingSubscriptionId
         *        The unique identifier of the billing subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingSubscriptionId(Long billingSubscriptionId);

        /**
         * <p>
         * The unique identifier of the Reserved Instance offering.
         * </p>
         * 
         * @param reservedInstanceOfferingId
         *        The unique identifier of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceOfferingId(String reservedInstanceOfferingId);

        /**
         * <p>
         * The OpenSearch instance type offered by theReserved Instance offering.
         * </p>
         * 
         * @param instanceType
         *        The OpenSearch instance type offered by theReserved Instance offering.
         * @see OpenSearchPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenSearchPartitionInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The OpenSearch instance type offered by theReserved Instance offering.
         * </p>
         * 
         * @param instanceType
         *        The OpenSearch instance type offered by theReserved Instance offering.
         * @see OpenSearchPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenSearchPartitionInstanceType
         */
        Builder instanceType(OpenSearchPartitionInstanceType instanceType);

        /**
         * <p>
         * The date and time when the reservation was purchased.
         * </p>
         * 
         * @param startTime
         *        The date and time when the reservation was purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The duration, in seconds, for which the OpenSearch instance is reserved.
         * </p>
         * 
         * @param duration
         *        The duration, in seconds, for which the OpenSearch instance is reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The upfront fixed charge you will paid to purchase the specific Reserved Instance offering.
         * </p>
         * 
         * @param fixedPrice
         *        The upfront fixed charge you will paid to purchase the specific Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * <p>
         * The hourly rate at which you're charged for the domain using this Reserved Instance.
         * </p>
         * 
         * @param usagePrice
         *        The hourly rate at which you're charged for the domain using this Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Double usagePrice);

        /**
         * <p>
         * The currency code for the offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency code for the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The number of OpenSearch instances that have been reserved.
         * </p>
         * 
         * @param instanceCount
         *        The number of OpenSearch instances that have been reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The state of the Reserved Instance.
         * </p>
         * 
         * @param state
         *        The state of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The payment option as defined in the Reserved Instance offering.
         * </p>
         * 
         * @param paymentOption
         *        The payment option as defined in the Reserved Instance offering.
         * @see ReservedInstancePaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedInstancePaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option as defined in the Reserved Instance offering.
         * </p>
         * 
         * @param paymentOption
         *        The payment option as defined in the Reserved Instance offering.
         * @see ReservedInstancePaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedInstancePaymentOption
         */
        Builder paymentOption(ReservedInstancePaymentOption paymentOption);

        /**
         * <p>
         * The recurring charge to your account, regardless of whether you create any domains using the Reserved
         * Instance offering.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge to your account, regardless of whether you create any domains using the Reserved
         *        Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring charge to your account, regardless of whether you create any domains using the Reserved
         * Instance offering.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge to your account, regardless of whether you create any domains using the Reserved
         *        Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The recurring charge to your account, regardless of whether you create any domains using the Reserved
         * Instance offering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.RecurringCharge.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opensearch.model.RecurringCharge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.RecurringCharge.Builder#build()} is called
         * immediately and its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.RecurringCharge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(java.util.Collection<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);
    }

    static final class BuilderImpl implements Builder {
        private String reservationName;

        private String reservedInstanceId;

        private Long billingSubscriptionId;

        private String reservedInstanceOfferingId;

        private String instanceType;

        private Instant startTime;

        private Integer duration;

        private Double fixedPrice;

        private Double usagePrice;

        private String currencyCode;

        private Integer instanceCount;

        private String state;

        private String paymentOption;

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstance model) {
            reservationName(model.reservationName);
            reservedInstanceId(model.reservedInstanceId);
            billingSubscriptionId(model.billingSubscriptionId);
            reservedInstanceOfferingId(model.reservedInstanceOfferingId);
            instanceType(model.instanceType);
            startTime(model.startTime);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            instanceCount(model.instanceCount);
            state(model.state);
            paymentOption(model.paymentOption);
            recurringCharges(model.recurringCharges);
        }

        public final String getReservationName() {
            return reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final String getReservedInstanceId() {
            return reservedInstanceId;
        }

        public final void setReservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
        }

        @Override
        public final Builder reservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
            return this;
        }

        public final Long getBillingSubscriptionId() {
            return billingSubscriptionId;
        }

        public final void setBillingSubscriptionId(Long billingSubscriptionId) {
            this.billingSubscriptionId = billingSubscriptionId;
        }

        @Override
        public final Builder billingSubscriptionId(Long billingSubscriptionId) {
            this.billingSubscriptionId = billingSubscriptionId;
            return this;
        }

        public final String getReservedInstanceOfferingId() {
            return reservedInstanceOfferingId;
        }

        public final void setReservedInstanceOfferingId(String reservedInstanceOfferingId) {
            this.reservedInstanceOfferingId = reservedInstanceOfferingId;
        }

        @Override
        public final Builder reservedInstanceOfferingId(String reservedInstanceOfferingId) {
            this.reservedInstanceOfferingId = reservedInstanceOfferingId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(OpenSearchPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Double getUsagePrice() {
            return usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(ReservedInstancePaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReservedInstance build() {
            return new ReservedInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
