/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>GetDataSource</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataSourceResponse extends OpenSearchResponse implements
        ToCopyableBuilder<GetDataSourceResponse.Builder, GetDataSourceResponse> {
    private static final SdkField<DataSourceType> DATA_SOURCE_TYPE_FIELD = SdkField
            .<DataSourceType> builder(MarshallingType.SDK_POJO).memberName("DataSourceType")
            .getter(getter(GetDataSourceResponse::dataSourceType)).setter(setter(Builder::dataSourceType))
            .constructor(DataSourceType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetDataSourceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetDataSourceResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_TYPE_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD));

    private final DataSourceType dataSourceType;

    private final String name;

    private final String description;

    private GetDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceType = builder.dataSourceType;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The type of data source.
     * </p>
     * 
     * @return The type of data source.
     */
    public final DataSourceType dataSourceType() {
        return dataSourceType;
    }

    /**
     * <p>
     * The name of the data source.
     * </p>
     * 
     * @return The name of the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the data source.
     * </p>
     * 
     * @return A description of the data source.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceResponse)) {
            return false;
        }
        GetDataSourceResponse other = (GetDataSourceResponse) obj;
        return Objects.equals(dataSourceType(), other.dataSourceType()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataSourceResponse").add("DataSourceType", dataSourceType()).add("Name", name())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceType":
            return Optional.ofNullable(clazz.cast(dataSourceType()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceResponse, T> g) {
        return obj -> g.apply((GetDataSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataSourceResponse> {
        /**
         * <p>
         * The type of data source.
         * </p>
         * 
         * @param dataSourceType
         *        The type of data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceType(DataSourceType dataSourceType);

        /**
         * <p>
         * The type of data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceType.Builder} avoiding the need
         * to create one manually via {@link DataSourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceType.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSourceType(DataSourceType)}.
         * 
         * @param dataSourceType
         *        a consumer that will call methods on {@link DataSourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceType(DataSourceType)
         */
        default Builder dataSourceType(Consumer<DataSourceType.Builder> dataSourceType) {
            return dataSourceType(DataSourceType.builder().applyMutation(dataSourceType).build());
        }

        /**
         * <p>
         * The name of the data source.
         * </p>
         * 
         * @param name
         *        The name of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the data source.
         * </p>
         * 
         * @param description
         *        A description of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private DataSourceType dataSourceType;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceResponse model) {
            super(model);
            dataSourceType(model.dataSourceType);
            name(model.name);
            description(model.description);
        }

        public final DataSourceType.Builder getDataSourceType() {
            return dataSourceType != null ? dataSourceType.toBuilder() : null;
        }

        public final void setDataSourceType(DataSourceType.BuilderImpl dataSourceType) {
            this.dataSourceType = dataSourceType != null ? dataSourceType.build() : null;
        }

        @Override
        public final Builder dataSourceType(DataSourceType dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public GetDataSourceResponse build() {
            return new GetDataSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
