/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the progress of a pre-upgrade dry run analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DryRunProgressStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DryRunProgressStatus.Builder, DryRunProgressStatus> {
    private static final SdkField<String> DRY_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DryRunId").getter(getter(DryRunProgressStatus::dryRunId)).setter(setter(Builder::dryRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunId").build()).build();

    private static final SdkField<String> DRY_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DryRunStatus").getter(getter(DryRunProgressStatus::dryRunStatus)).setter(setter(Builder::dryRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunStatus").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(DryRunProgressStatus::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> UPDATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateDate").getter(getter(DryRunProgressStatus::updateDate)).setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()).build();

    private static final SdkField<List<ValidationFailure>> VALIDATION_FAILURES_FIELD = SdkField
            .<List<ValidationFailure>> builder(MarshallingType.LIST)
            .memberName("ValidationFailures")
            .getter(getter(DryRunProgressStatus::validationFailures))
            .setter(setter(Builder::validationFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_ID_FIELD,
            DRY_RUN_STATUS_FIELD, CREATION_DATE_FIELD, UPDATE_DATE_FIELD, VALIDATION_FAILURES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dryRunId;

    private final String dryRunStatus;

    private final String creationDate;

    private final String updateDate;

    private final List<ValidationFailure> validationFailures;

    private DryRunProgressStatus(BuilderImpl builder) {
        this.dryRunId = builder.dryRunId;
        this.dryRunStatus = builder.dryRunStatus;
        this.creationDate = builder.creationDate;
        this.updateDate = builder.updateDate;
        this.validationFailures = builder.validationFailures;
    }

    /**
     * <p>
     * The unique identifier of the dry run.
     * </p>
     * 
     * @return The unique identifier of the dry run.
     */
    public final String dryRunId() {
        return dryRunId;
    }

    /**
     * <p>
     * The current status of the dry run.
     * </p>
     * 
     * @return The current status of the dry run.
     */
    public final String dryRunStatus() {
        return dryRunStatus;
    }

    /**
     * <p>
     * The timestamp when the dry run was initiated.
     * </p>
     * 
     * @return The timestamp when the dry run was initiated.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The timestamp when the dry run was last updated.
     * </p>
     * 
     * @return The timestamp when the dry run was last updated.
     */
    public final String updateDate() {
        return updateDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationFailures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidationFailures() {
        return validationFailures != null && !(validationFailures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any validation failures that occurred as a result of the dry run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationFailures} method.
     * </p>
     * 
     * @return Any validation failures that occurred as a result of the dry run.
     */
    public final List<ValidationFailure> validationFailures() {
        return validationFailures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dryRunId());
        hashCode = 31 * hashCode + Objects.hashCode(dryRunStatus());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationFailures() ? validationFailures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DryRunProgressStatus)) {
            return false;
        }
        DryRunProgressStatus other = (DryRunProgressStatus) obj;
        return Objects.equals(dryRunId(), other.dryRunId()) && Objects.equals(dryRunStatus(), other.dryRunStatus())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(updateDate(), other.updateDate())
                && hasValidationFailures() == other.hasValidationFailures()
                && Objects.equals(validationFailures(), other.validationFailures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DryRunProgressStatus").add("DryRunId", dryRunId()).add("DryRunStatus", dryRunStatus())
                .add("CreationDate", creationDate()).add("UpdateDate", updateDate())
                .add("ValidationFailures", hasValidationFailures() ? validationFailures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRunId":
            return Optional.ofNullable(clazz.cast(dryRunId()));
        case "DryRunStatus":
            return Optional.ofNullable(clazz.cast(dryRunStatus()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "UpdateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        case "ValidationFailures":
            return Optional.ofNullable(clazz.cast(validationFailures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DryRunProgressStatus, T> g) {
        return obj -> g.apply((DryRunProgressStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DryRunProgressStatus> {
        /**
         * <p>
         * The unique identifier of the dry run.
         * </p>
         * 
         * @param dryRunId
         *        The unique identifier of the dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunId(String dryRunId);

        /**
         * <p>
         * The current status of the dry run.
         * </p>
         * 
         * @param dryRunStatus
         *        The current status of the dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunStatus(String dryRunStatus);

        /**
         * <p>
         * The timestamp when the dry run was initiated.
         * </p>
         * 
         * @param creationDate
         *        The timestamp when the dry run was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The timestamp when the dry run was last updated.
         * </p>
         * 
         * @param updateDate
         *        The timestamp when the dry run was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(String updateDate);

        /**
         * <p>
         * Any validation failures that occurred as a result of the dry run.
         * </p>
         * 
         * @param validationFailures
         *        Any validation failures that occurred as a result of the dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationFailures(Collection<ValidationFailure> validationFailures);

        /**
         * <p>
         * Any validation failures that occurred as a result of the dry run.
         * </p>
         * 
         * @param validationFailures
         *        Any validation failures that occurred as a result of the dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationFailures(ValidationFailure... validationFailures);

        /**
         * <p>
         * Any validation failures that occurred as a result of the dry run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.ValidationFailure.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.opensearch.model.ValidationFailure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.ValidationFailure.Builder#build()} is called
         * immediately and its result is passed to {@link #validationFailures(List<ValidationFailure>)}.
         * 
         * @param validationFailures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.ValidationFailure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationFailures(java.util.Collection<ValidationFailure>)
         */
        Builder validationFailures(Consumer<ValidationFailure.Builder>... validationFailures);
    }

    static final class BuilderImpl implements Builder {
        private String dryRunId;

        private String dryRunStatus;

        private String creationDate;

        private String updateDate;

        private List<ValidationFailure> validationFailures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DryRunProgressStatus model) {
            dryRunId(model.dryRunId);
            dryRunStatus(model.dryRunStatus);
            creationDate(model.creationDate);
            updateDate(model.updateDate);
            validationFailures(model.validationFailures);
        }

        public final String getDryRunId() {
            return dryRunId;
        }

        public final void setDryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
        }

        @Override
        public final Builder dryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
            return this;
        }

        public final String getDryRunStatus() {
            return dryRunStatus;
        }

        public final void setDryRunStatus(String dryRunStatus) {
            this.dryRunStatus = dryRunStatus;
        }

        @Override
        public final Builder dryRunStatus(String dryRunStatus) {
            this.dryRunStatus = dryRunStatus;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getUpdateDate() {
            return updateDate;
        }

        public final void setUpdateDate(String updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(String updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final List<ValidationFailure.Builder> getValidationFailures() {
            List<ValidationFailure.Builder> result = ValidationFailuresCopier.copyToBuilder(this.validationFailures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationFailures(Collection<ValidationFailure.BuilderImpl> validationFailures) {
            this.validationFailures = ValidationFailuresCopier.copyFromBuilder(validationFailures);
        }

        @Override
        public final Builder validationFailures(Collection<ValidationFailure> validationFailures) {
            this.validationFailures = ValidationFailuresCopier.copy(validationFailures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationFailures(ValidationFailure... validationFailures) {
            validationFailures(Arrays.asList(validationFailures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationFailures(Consumer<ValidationFailure.Builder>... validationFailures) {
            validationFailures(Stream.of(validationFailures).map(c -> ValidationFailure.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DryRunProgressStatus build() {
            return new DryRunProgressStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
