/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options to configure a custom endpoint for an OpenSearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainEndpointOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainEndpointOptions.Builder, DomainEndpointOptions> {
    private static final SdkField<Boolean> ENFORCE_HTTPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnforceHTTPS").getter(getter(DomainEndpointOptions::enforceHTTPS)).setter(setter(Builder::enforceHTTPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceHTTPS").build()).build();

    private static final SdkField<String> TLS_SECURITY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TLSSecurityPolicy").getter(getter(DomainEndpointOptions::tlsSecurityPolicyAsString))
            .setter(setter(Builder::tlsSecurityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSSecurityPolicy").build()).build();

    private static final SdkField<Boolean> CUSTOM_ENDPOINT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CustomEndpointEnabled").getter(getter(DomainEndpointOptions::customEndpointEnabled))
            .setter(setter(Builder::customEndpointEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpointEnabled").build())
            .build();

    private static final SdkField<String> CUSTOM_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomEndpoint").getter(getter(DomainEndpointOptions::customEndpoint))
            .setter(setter(Builder::customEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpoint").build()).build();

    private static final SdkField<String> CUSTOM_ENDPOINT_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomEndpointCertificateArn")
            .getter(getter(DomainEndpointOptions::customEndpointCertificateArn))
            .setter(setter(Builder::customEndpointCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpointCertificateArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCE_HTTPS_FIELD,
            TLS_SECURITY_POLICY_FIELD, CUSTOM_ENDPOINT_ENABLED_FIELD, CUSTOM_ENDPOINT_FIELD,
            CUSTOM_ENDPOINT_CERTIFICATE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enforceHTTPS;

    private final String tlsSecurityPolicy;

    private final Boolean customEndpointEnabled;

    private final String customEndpoint;

    private final String customEndpointCertificateArn;

    private DomainEndpointOptions(BuilderImpl builder) {
        this.enforceHTTPS = builder.enforceHTTPS;
        this.tlsSecurityPolicy = builder.tlsSecurityPolicy;
        this.customEndpointEnabled = builder.customEndpointEnabled;
        this.customEndpoint = builder.customEndpoint;
        this.customEndpointCertificateArn = builder.customEndpointCertificateArn;
    }

    /**
     * <p>
     * True to require that all traffic to the domain arrive over HTTPS.
     * </p>
     * 
     * @return True to require that all traffic to the domain arrive over HTTPS.
     */
    public final Boolean enforceHTTPS() {
        return enforceHTTPS;
    }

    /**
     * <p>
     * Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.2
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLS version 1.2
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy-Min-TLS-1-0-2023-10:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.3
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy-Min-TLS-1-2-2023-10:</b> TLS security policy which supports TLS version 1.2 to TLS version 1.3 with
     * perfect forward secrecy cipher suites
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsSecurityPolicy}
     * will return {@link TLSSecurityPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tlsSecurityPolicyAsString}.
     * </p>
     * 
     * @return Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLS version 1.2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Policy-Min-TLS-1-0-2023-10:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.3
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Policy-Min-TLS-1-2-2023-10:</b> TLS security policy which supports TLS version 1.2 to TLS version 1.3
     *         with perfect forward secrecy cipher suites
     *         </p>
     *         </li>
     * @see TLSSecurityPolicy
     */
    public final TLSSecurityPolicy tlsSecurityPolicy() {
        return TLSSecurityPolicy.fromValue(tlsSecurityPolicy);
    }

    /**
     * <p>
     * Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.2
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLS version 1.2
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy-Min-TLS-1-0-2023-10:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.3
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy-Min-TLS-1-2-2023-10:</b> TLS security policy which supports TLS version 1.2 to TLS version 1.3 with
     * perfect forward secrecy cipher suites
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsSecurityPolicy}
     * will return {@link TLSSecurityPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tlsSecurityPolicyAsString}.
     * </p>
     * 
     * @return Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLS version 1.2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Policy-Min-TLS-1-0-2023-10:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.3
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Policy-Min-TLS-1-2-2023-10:</b> TLS security policy which supports TLS version 1.2 to TLS version 1.3
     *         with perfect forward secrecy cipher suites
     *         </p>
     *         </li>
     * @see TLSSecurityPolicy
     */
    public final String tlsSecurityPolicyAsString() {
        return tlsSecurityPolicy;
    }

    /**
     * <p>
     * Whether to enable a custom endpoint for the domain.
     * </p>
     * 
     * @return Whether to enable a custom endpoint for the domain.
     */
    public final Boolean customEndpointEnabled() {
        return customEndpointEnabled;
    }

    /**
     * <p>
     * The fully qualified URL for the custom endpoint.
     * </p>
     * 
     * @return The fully qualified URL for the custom endpoint.
     */
    public final String customEndpoint() {
        return customEndpoint;
    }

    /**
     * <p>
     * The ARN for your security certificate, managed in Amazon Web Services Certificate Manager (ACM).
     * </p>
     * 
     * @return The ARN for your security certificate, managed in Amazon Web Services Certificate Manager (ACM).
     */
    public final String customEndpointCertificateArn() {
        return customEndpointCertificateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enforceHTTPS());
        hashCode = 31 * hashCode + Objects.hashCode(tlsSecurityPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customEndpointEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(customEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(customEndpointCertificateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEndpointOptions)) {
            return false;
        }
        DomainEndpointOptions other = (DomainEndpointOptions) obj;
        return Objects.equals(enforceHTTPS(), other.enforceHTTPS())
                && Objects.equals(tlsSecurityPolicyAsString(), other.tlsSecurityPolicyAsString())
                && Objects.equals(customEndpointEnabled(), other.customEndpointEnabled())
                && Objects.equals(customEndpoint(), other.customEndpoint())
                && Objects.equals(customEndpointCertificateArn(), other.customEndpointCertificateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainEndpointOptions").add("EnforceHTTPS", enforceHTTPS())
                .add("TLSSecurityPolicy", tlsSecurityPolicyAsString()).add("CustomEndpointEnabled", customEndpointEnabled())
                .add("CustomEndpoint", customEndpoint()).add("CustomEndpointCertificateArn", customEndpointCertificateArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnforceHTTPS":
            return Optional.ofNullable(clazz.cast(enforceHTTPS()));
        case "TLSSecurityPolicy":
            return Optional.ofNullable(clazz.cast(tlsSecurityPolicyAsString()));
        case "CustomEndpointEnabled":
            return Optional.ofNullable(clazz.cast(customEndpointEnabled()));
        case "CustomEndpoint":
            return Optional.ofNullable(clazz.cast(customEndpoint()));
        case "CustomEndpointCertificateArn":
            return Optional.ofNullable(clazz.cast(customEndpointCertificateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainEndpointOptions, T> g) {
        return obj -> g.apply((DomainEndpointOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainEndpointOptions> {
        /**
         * <p>
         * True to require that all traffic to the domain arrive over HTTPS.
         * </p>
         * 
         * @param enforceHTTPS
         *        True to require that all traffic to the domain arrive over HTTPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforceHTTPS(Boolean enforceHTTPS);

        /**
         * <p>
         * Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.2
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLS version 1.2
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Policy-Min-TLS-1-0-2023-10:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.3
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Policy-Min-TLS-1-2-2023-10:</b> TLS security policy which supports TLS version 1.2 to TLS version 1.3 with
         * perfect forward secrecy cipher suites
         * </p>
         * </li>
         * </ul>
         * 
         * @param tlsSecurityPolicy
         *        Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of
         *        the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLS version 1.0 to TLS version
         *        1.2
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLS version 1.2
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Policy-Min-TLS-1-0-2023-10:</b> TLS security policy which supports TLS version 1.0 to TLS version
         *        1.3
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Policy-Min-TLS-1-2-2023-10:</b> TLS security policy which supports TLS version 1.2 to TLS version
         *        1.3 with perfect forward secrecy cipher suites
         *        </p>
         *        </li>
         * @see TLSSecurityPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TLSSecurityPolicy
         */
        Builder tlsSecurityPolicy(String tlsSecurityPolicy);

        /**
         * <p>
         * Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.2
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLS version 1.2
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Policy-Min-TLS-1-0-2023-10:</b> TLS security policy which supports TLS version 1.0 to TLS version 1.3
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Policy-Min-TLS-1-2-2023-10:</b> TLS security policy which supports TLS version 1.2 to TLS version 1.3 with
         * perfect forward secrecy cipher suites
         * </p>
         * </li>
         * </ul>
         * 
         * @param tlsSecurityPolicy
         *        Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of
         *        the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy which supports TLS version 1.0 to TLS version
         *        1.2
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy which supports only TLS version 1.2
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Policy-Min-TLS-1-0-2023-10:</b> TLS security policy which supports TLS version 1.0 to TLS version
         *        1.3
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Policy-Min-TLS-1-2-2023-10:</b> TLS security policy which supports TLS version 1.2 to TLS version
         *        1.3 with perfect forward secrecy cipher suites
         *        </p>
         *        </li>
         * @see TLSSecurityPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TLSSecurityPolicy
         */
        Builder tlsSecurityPolicy(TLSSecurityPolicy tlsSecurityPolicy);

        /**
         * <p>
         * Whether to enable a custom endpoint for the domain.
         * </p>
         * 
         * @param customEndpointEnabled
         *        Whether to enable a custom endpoint for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpointEnabled(Boolean customEndpointEnabled);

        /**
         * <p>
         * The fully qualified URL for the custom endpoint.
         * </p>
         * 
         * @param customEndpoint
         *        The fully qualified URL for the custom endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpoint(String customEndpoint);

        /**
         * <p>
         * The ARN for your security certificate, managed in Amazon Web Services Certificate Manager (ACM).
         * </p>
         * 
         * @param customEndpointCertificateArn
         *        The ARN for your security certificate, managed in Amazon Web Services Certificate Manager (ACM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpointCertificateArn(String customEndpointCertificateArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enforceHTTPS;

        private String tlsSecurityPolicy;

        private Boolean customEndpointEnabled;

        private String customEndpoint;

        private String customEndpointCertificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEndpointOptions model) {
            enforceHTTPS(model.enforceHTTPS);
            tlsSecurityPolicy(model.tlsSecurityPolicy);
            customEndpointEnabled(model.customEndpointEnabled);
            customEndpoint(model.customEndpoint);
            customEndpointCertificateArn(model.customEndpointCertificateArn);
        }

        public final Boolean getEnforceHTTPS() {
            return enforceHTTPS;
        }

        public final void setEnforceHTTPS(Boolean enforceHTTPS) {
            this.enforceHTTPS = enforceHTTPS;
        }

        @Override
        public final Builder enforceHTTPS(Boolean enforceHTTPS) {
            this.enforceHTTPS = enforceHTTPS;
            return this;
        }

        public final String getTlsSecurityPolicy() {
            return tlsSecurityPolicy;
        }

        public final void setTlsSecurityPolicy(String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
        }

        @Override
        public final Builder tlsSecurityPolicy(String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
            return this;
        }

        @Override
        public final Builder tlsSecurityPolicy(TLSSecurityPolicy tlsSecurityPolicy) {
            this.tlsSecurityPolicy(tlsSecurityPolicy == null ? null : tlsSecurityPolicy.toString());
            return this;
        }

        public final Boolean getCustomEndpointEnabled() {
            return customEndpointEnabled;
        }

        public final void setCustomEndpointEnabled(Boolean customEndpointEnabled) {
            this.customEndpointEnabled = customEndpointEnabled;
        }

        @Override
        public final Builder customEndpointEnabled(Boolean customEndpointEnabled) {
            this.customEndpointEnabled = customEndpointEnabled;
            return this;
        }

        public final String getCustomEndpoint() {
            return customEndpoint;
        }

        public final void setCustomEndpoint(String customEndpoint) {
            this.customEndpoint = customEndpoint;
        }

        @Override
        public final Builder customEndpoint(String customEndpoint) {
            this.customEndpoint = customEndpoint;
            return this;
        }

        public final String getCustomEndpointCertificateArn() {
            return customEndpointCertificateArn;
        }

        public final void setCustomEndpointCertificateArn(String customEndpointCertificateArn) {
            this.customEndpointCertificateArn = customEndpointCertificateArn;
        }

        @Override
        public final Builder customEndpointCertificateArn(String customEndpointCertificateArn) {
            this.customEndpointCertificateArn = customEndpointCertificateArn;
            return this;
        }

        @Override
        public DomainEndpointOptions build() {
            return new DomainEndpointOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
