/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.DomainStatus;
import software.amazon.awssdk.services.opensearch.model.DryRunProgressStatus;
import software.amazon.awssdk.services.opensearch.model.DryRunResults;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDryRunProgressResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, DescribeDryRunProgressResponse> {
    private static final SdkField<DryRunProgressStatus> DRY_RUN_PROGRESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DryRunProgressStatus").getter(DescribeDryRunProgressResponse.getter(DescribeDryRunProgressResponse::dryRunProgressStatus)).setter(DescribeDryRunProgressResponse.setter(Builder::dryRunProgressStatus)).constructor(DryRunProgressStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunProgressStatus").build()}).build();
    private static final SdkField<DomainStatus> DRY_RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DryRunConfig").getter(DescribeDryRunProgressResponse.getter(DescribeDryRunProgressResponse::dryRunConfig)).setter(DescribeDryRunProgressResponse.setter(Builder::dryRunConfig)).constructor(DomainStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunConfig").build()}).build();
    private static final SdkField<DryRunResults> DRY_RUN_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DryRunResults").getter(DescribeDryRunProgressResponse.getter(DescribeDryRunProgressResponse::dryRunResults)).setter(DescribeDryRunProgressResponse.setter(Builder::dryRunResults)).constructor(DryRunResults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_PROGRESS_STATUS_FIELD, DRY_RUN_CONFIG_FIELD, DRY_RUN_RESULTS_FIELD));
    private final DryRunProgressStatus dryRunProgressStatus;
    private final DomainStatus dryRunConfig;
    private final DryRunResults dryRunResults;

    private DescribeDryRunProgressResponse(BuilderImpl builder) {
        super(builder);
        this.dryRunProgressStatus = builder.dryRunProgressStatus;
        this.dryRunConfig = builder.dryRunConfig;
        this.dryRunResults = builder.dryRunResults;
    }

    public final DryRunProgressStatus dryRunProgressStatus() {
        return this.dryRunProgressStatus;
    }

    public final DomainStatus dryRunConfig() {
        return this.dryRunConfig;
    }

    public final DryRunResults dryRunResults() {
        return this.dryRunResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunProgressStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDryRunProgressResponse)) {
            return false;
        }
        DescribeDryRunProgressResponse other = (DescribeDryRunProgressResponse)((Object)obj);
        return Objects.equals(this.dryRunProgressStatus(), other.dryRunProgressStatus()) && Objects.equals(this.dryRunConfig(), other.dryRunConfig()) && Objects.equals(this.dryRunResults(), other.dryRunResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDryRunProgressResponse").add("DryRunProgressStatus", (Object)this.dryRunProgressStatus()).add("DryRunConfig", (Object)this.dryRunConfig()).add("DryRunResults", (Object)this.dryRunResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRunProgressStatus": {
                return Optional.ofNullable(clazz.cast(this.dryRunProgressStatus()));
            }
            case "DryRunConfig": {
                return Optional.ofNullable(clazz.cast(this.dryRunConfig()));
            }
            case "DryRunResults": {
                return Optional.ofNullable(clazz.cast(this.dryRunResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDryRunProgressResponse, T> g) {
        return obj -> g.apply((DescribeDryRunProgressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private DryRunProgressStatus dryRunProgressStatus;
        private DomainStatus dryRunConfig;
        private DryRunResults dryRunResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDryRunProgressResponse model) {
            super(model);
            this.dryRunProgressStatus(model.dryRunProgressStatus);
            this.dryRunConfig(model.dryRunConfig);
            this.dryRunResults(model.dryRunResults);
        }

        public final DryRunProgressStatus.Builder getDryRunProgressStatus() {
            return this.dryRunProgressStatus != null ? this.dryRunProgressStatus.toBuilder() : null;
        }

        public final void setDryRunProgressStatus(DryRunProgressStatus.BuilderImpl dryRunProgressStatus) {
            this.dryRunProgressStatus = dryRunProgressStatus != null ? dryRunProgressStatus.build() : null;
        }

        @Override
        public final Builder dryRunProgressStatus(DryRunProgressStatus dryRunProgressStatus) {
            this.dryRunProgressStatus = dryRunProgressStatus;
            return this;
        }

        public final DomainStatus.Builder getDryRunConfig() {
            return this.dryRunConfig != null ? this.dryRunConfig.toBuilder() : null;
        }

        public final void setDryRunConfig(DomainStatus.BuilderImpl dryRunConfig) {
            this.dryRunConfig = dryRunConfig != null ? dryRunConfig.build() : null;
        }

        @Override
        public final Builder dryRunConfig(DomainStatus dryRunConfig) {
            this.dryRunConfig = dryRunConfig;
            return this;
        }

        public final DryRunResults.Builder getDryRunResults() {
            return this.dryRunResults != null ? this.dryRunResults.toBuilder() : null;
        }

        public final void setDryRunResults(DryRunResults.BuilderImpl dryRunResults) {
            this.dryRunResults = dryRunResults != null ? dryRunResults.build() : null;
        }

        @Override
        public final Builder dryRunResults(DryRunResults dryRunResults) {
            this.dryRunResults = dryRunResults;
            return this;
        }

        @Override
        public DescribeDryRunProgressResponse build() {
            return new DescribeDryRunProgressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDryRunProgressResponse> {
        public Builder dryRunProgressStatus(DryRunProgressStatus var1);

        default public Builder dryRunProgressStatus(Consumer<DryRunProgressStatus.Builder> dryRunProgressStatus) {
            return this.dryRunProgressStatus((DryRunProgressStatus)((DryRunProgressStatus.Builder)DryRunProgressStatus.builder().applyMutation(dryRunProgressStatus)).build());
        }

        public Builder dryRunConfig(DomainStatus var1);

        default public Builder dryRunConfig(Consumer<DomainStatus.Builder> dryRunConfig) {
            return this.dryRunConfig((DomainStatus)((DomainStatus.Builder)DomainStatus.builder().applyMutation(dryRunConfig)).build());
        }

        public Builder dryRunResults(DryRunResults var1);

        default public Builder dryRunResults(Consumer<DryRunResults.Builder> dryRunResults) {
            return this.dryRunResults((DryRunResults)((DryRunResults.Builder)DryRunResults.builder().applyMutation(dryRunResults)).build());
        }
    }
}

