/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the active domain environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentInfo implements SdkPojo, Serializable, ToCopyableBuilder<EnvironmentInfo.Builder, EnvironmentInfo> {
    private static final SdkField<List<AvailabilityZoneInfo>> AVAILABILITY_ZONE_INFORMATION_FIELD = SdkField
            .<List<AvailabilityZoneInfo>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZoneInformation")
            .getter(getter(EnvironmentInfo::availabilityZoneInformation))
            .setter(setter(Builder::availabilityZoneInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneInformation")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZoneInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZoneInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AVAILABILITY_ZONE_INFORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AvailabilityZoneInfo> availabilityZoneInformation;

    private EnvironmentInfo(BuilderImpl builder) {
        this.availabilityZoneInformation = builder.availabilityZoneInformation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneInformation property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailabilityZoneInformation() {
        return availabilityZoneInformation != null && !(availabilityZoneInformation instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AvailabilityZoneInfo</code> for the domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneInformation} method.
     * </p>
     * 
     * @return A list of <code>AvailabilityZoneInfo</code> for the domain.
     */
    public final List<AvailabilityZoneInfo> availabilityZoneInformation() {
        return availabilityZoneInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneInformation() ? availabilityZoneInformation() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentInfo)) {
            return false;
        }
        EnvironmentInfo other = (EnvironmentInfo) obj;
        return hasAvailabilityZoneInformation() == other.hasAvailabilityZoneInformation()
                && Objects.equals(availabilityZoneInformation(), other.availabilityZoneInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentInfo")
                .add("AvailabilityZoneInformation", hasAvailabilityZoneInformation() ? availabilityZoneInformation() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZoneInformation":
            return Optional.ofNullable(clazz.cast(availabilityZoneInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentInfo, T> g) {
        return obj -> g.apply((EnvironmentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentInfo> {
        /**
         * <p>
         * A list of <code>AvailabilityZoneInfo</code> for the domain.
         * </p>
         * 
         * @param availabilityZoneInformation
         *        A list of <code>AvailabilityZoneInfo</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneInformation(Collection<AvailabilityZoneInfo> availabilityZoneInformation);

        /**
         * <p>
         * A list of <code>AvailabilityZoneInfo</code> for the domain.
         * </p>
         * 
         * @param availabilityZoneInformation
         *        A list of <code>AvailabilityZoneInfo</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneInformation(AvailabilityZoneInfo... availabilityZoneInformation);

        /**
         * <p>
         * A list of <code>AvailabilityZoneInfo</code> for the domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #availabilityZoneInformation(List<AvailabilityZoneInfo>)}.
         * 
         * @param availabilityZoneInformation
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.AvailabilityZoneInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZoneInformation(java.util.Collection<AvailabilityZoneInfo>)
         */
        Builder availabilityZoneInformation(Consumer<AvailabilityZoneInfo.Builder>... availabilityZoneInformation);
    }

    static final class BuilderImpl implements Builder {
        private List<AvailabilityZoneInfo> availabilityZoneInformation = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentInfo model) {
            availabilityZoneInformation(model.availabilityZoneInformation);
        }

        public final List<AvailabilityZoneInfo.Builder> getAvailabilityZoneInformation() {
            List<AvailabilityZoneInfo.Builder> result = AvailabilityZoneInfoListCopier
                    .copyToBuilder(this.availabilityZoneInformation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZoneInformation(Collection<AvailabilityZoneInfo.BuilderImpl> availabilityZoneInformation) {
            this.availabilityZoneInformation = AvailabilityZoneInfoListCopier.copyFromBuilder(availabilityZoneInformation);
        }

        @Override
        public final Builder availabilityZoneInformation(Collection<AvailabilityZoneInfo> availabilityZoneInformation) {
            this.availabilityZoneInformation = AvailabilityZoneInfoListCopier.copy(availabilityZoneInformation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneInformation(AvailabilityZoneInfo... availabilityZoneInformation) {
            availabilityZoneInformation(Arrays.asList(availabilityZoneInformation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneInformation(Consumer<AvailabilityZoneInfo.Builder>... availabilityZoneInformation) {
            availabilityZoneInformation(Stream.of(availabilityZoneInformation)
                    .map(c -> AvailabilityZoneInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EnvironmentInfo build() {
            return new EnvironmentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
