/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.opensearch.internal.OpenSearchServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.AccessDeniedException;
import software.amazon.awssdk.services.opensearch.model.AddTagsRequest;
import software.amazon.awssdk.services.opensearch.model.AddTagsResponse;
import software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.BaseException;
import software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.opensearch.model.ConflictException;
import software.amazon.awssdk.services.opensearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.opensearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.CreatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.CreatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.DeletePackageRequest;
import software.amazon.awssdk.services.opensearch.model.DeletePackageResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.DependencyFailureException;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.opensearch.model.DisabledOperationException;
import software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.DissociatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse;
import software.amazon.awssdk.services.opensearch.model.GetDomainMaintenanceStatusRequest;
import software.amazon.awssdk.services.opensearch.model.GetDomainMaintenanceStatusResponse;
import software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.opensearch.model.InternalException;
import software.amazon.awssdk.services.opensearch.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.opensearch.model.InvalidTypeException;
import software.amazon.awssdk.services.opensearch.model.LimitExceededException;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse;
import software.amazon.awssdk.services.opensearch.model.ListTagsRequest;
import software.amazon.awssdk.services.opensearch.model.ListTagsResponse;
import software.amazon.awssdk.services.opensearch.model.ListVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVersionsResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsResponse;
import software.amazon.awssdk.services.opensearch.model.OpenSearchException;
import software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest;
import software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse;
import software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.opensearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.opensearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.opensearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.SlotNotAvailableException;
import software.amazon.awssdk.services.opensearch.model.StartDomainMaintenanceRequest;
import software.amazon.awssdk.services.opensearch.model.StartDomainMaintenanceResponse;
import software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse;
import software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest;
import software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ValidationException;
import software.amazon.awssdk.services.opensearch.transform.AcceptInboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.AssociatePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.AuthorizeVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CancelServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CreateOutboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.CreateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteInboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteOutboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DeleteVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainAutoTunesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainChangeProgressRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainHealthRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainNodesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDomainsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeDryRunProgressRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeInboundConnectionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeInstanceTypeLimitsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeOutboundConnectionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribePackagesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeReservedInstanceOfferingsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DescribeVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.DissociatePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetCompatibleVersionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetDomainMaintenanceStatusRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetPackageVersionHistoryRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetUpgradeHistoryRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.GetUpgradeStatusRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListDomainMaintenancesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListDomainsForPackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListInstanceTypeDetailsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListPackagesForDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListVersionsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListVpcEndpointsForDomainRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.ListVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.PurchaseReservedInstanceOfferingRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.RejectInboundConnectionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.RevokeVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.StartDomainMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.StartServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdateDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdatePackageRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdateScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpdateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.opensearch.transform.UpgradeDomainRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link OpenSearchClient}.
 *
 * @see OpenSearchClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultOpenSearchClient implements OpenSearchClient {
    private static final Logger log = Logger.loggerFor(DefaultOpenSearchClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final OpenSearchServiceClientConfiguration serviceClientConfiguration;

    protected DefaultOpenSearchClient(OpenSearchServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Allows the destination Amazon OpenSearch Service domain owner to accept an inbound cross-cluster search
     * connection request. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param acceptInboundConnectionRequest
     *        Container for the parameters to the <code>AcceptInboundConnection</code> operation.
     * @return Result of the AcceptInboundConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.AcceptInboundConnection
     */
    @Override
    public AcceptInboundConnectionResponse acceptInboundConnection(AcceptInboundConnectionRequest acceptInboundConnectionRequest)
            throws ResourceNotFoundException, LimitExceededException, DisabledOperationException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptInboundConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptInboundConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptInboundConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptInboundConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptInboundConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptInboundConnectionRequest, AcceptInboundConnectionResponse>()
                            .withOperationName("AcceptInboundConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptInboundConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptInboundConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches tags to an existing Amazon OpenSearch Service domain. Tags are a set of case-sensitive key-value pairs.
     * A domain can have up to 10 tags. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html"
     * >Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     *
     * @param addTagsRequest
     *        Container for the parameters to the <code>AddTags</code> operation. Specifies the tags to attach to the
     *        domain.
     * @return Result of the AddTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.AddTags
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws BaseException, LimitExceededException,
            ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");

            return clientHandler.execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>()
                    .withOperationName("AddTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(addTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a package with an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param associatePackageRequest
     *        Container for the request parameters to the <code>AssociatePackage</code> operation.
     * @return Result of the AssociatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.AssociatePackage
     */
    @Override
    public AssociatePackageResponse associatePackage(AssociatePackageRequest associatePackageRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociatePackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associatePackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePackage");

            return clientHandler.execute(new ClientExecutionParams<AssociatePackageRequest, AssociatePackageResponse>()
                    .withOperationName("AssociatePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associatePackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociatePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     *
     * @param authorizeVpcEndpointAccessRequest
     * @return Result of the AuthorizeVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.AuthorizeVpcEndpointAccess
     */
    @Override
    public AuthorizeVpcEndpointAccessResponse authorizeVpcEndpointAccess(
            AuthorizeVpcEndpointAccessRequest authorizeVpcEndpointAccessRequest) throws ResourceNotFoundException,
            DisabledOperationException, LimitExceededException, ValidationException, InternalException, BaseException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AuthorizeVpcEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AuthorizeVpcEndpointAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeVpcEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeVpcEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeVpcEndpointAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<AuthorizeVpcEndpointAccessRequest, AuthorizeVpcEndpointAccessResponse>()
                            .withOperationName("AuthorizeVpcEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(authorizeVpcEndpointAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AuthorizeVpcEndpointAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this
     * operation before the <code>AutomatedUpdateDate</code> and when the domain's <code>UpdateStatus</code> is
     * <code>PENDING_UPDATE</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service
     * software updates in Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param cancelServiceSoftwareUpdateRequest
     *        Container for the request parameters to cancel a service software update.
     * @return Result of the CancelServiceSoftwareUpdate operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.CancelServiceSoftwareUpdate
     */
    @Override
    public CancelServiceSoftwareUpdateResponse cancelServiceSoftwareUpdate(
            CancelServiceSoftwareUpdateRequest cancelServiceSoftwareUpdateRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelServiceSoftwareUpdateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelServiceSoftwareUpdateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelServiceSoftwareUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelServiceSoftwareUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelServiceSoftwareUpdate");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelServiceSoftwareUpdateRequest, CancelServiceSoftwareUpdateResponse>()
                            .withOperationName("CancelServiceSoftwareUpdate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelServiceSoftwareUpdateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelServiceSoftwareUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and
     * managing Amazon OpenSearch Service domains</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws InvalidTypeException
     *         An exception for trying to create or access a sub-resource that's either invalid or not supported.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.CreateDomain
     */
    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws BaseException,
            DisabledOperationException, InternalException, InvalidTypeException, LimitExceededException,
            ResourceAlreadyExistsException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomain");

            return clientHandler.execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                    .withOperationName("CreateDomain").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new cross-cluster search connection from a source Amazon OpenSearch Service domain to a destination
     * domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param createOutboundConnectionRequest
     *        Container for the parameters to the <code>CreateOutboundConnection</code> operation.
     * @return Result of the CreateOutboundConnection operation returned by the service.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.CreateOutboundConnection
     */
    @Override
    public CreateOutboundConnectionResponse createOutboundConnection(
            CreateOutboundConnectionRequest createOutboundConnectionRequest) throws LimitExceededException, InternalException,
            ResourceAlreadyExistsException, DisabledOperationException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOutboundConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateOutboundConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOutboundConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOutboundConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOutboundConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateOutboundConnectionRequest, CreateOutboundConnectionResponse>()
                            .withOperationName("CreateOutboundConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createOutboundConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateOutboundConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a package for use with Amazon OpenSearch Service domains. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param createPackageRequest
     *        Container for request parameters to the <code>CreatePackage</code> operation.
     * @return Result of the CreatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws InvalidTypeException
     *         An exception for trying to create or access a sub-resource that's either invalid or not supported.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.CreatePackage
     */
    @Override
    public CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws BaseException,
            InternalException, LimitExceededException, InvalidTypeException, ResourceAlreadyExistsException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePackage");

            return clientHandler.execute(new ClientExecutionParams<CreatePackageRequest, CreatePackageResponse>()
                    .withOperationName("CreatePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     * </p>
     *
     * @param createVpcEndpointRequest
     * @return Result of the CreateVpcEndpoint operation returned by the service.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.CreateVpcEndpoint
     */
    @Override
    public CreateVpcEndpointResponse createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest)
            throws ConflictException, ValidationException, LimitExceededException, InternalException, DisabledOperationException,
            BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVpcEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateVpcEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpoint");

            return clientHandler.execute(new ClientExecutionParams<CreateVpcEndpointRequest, CreateVpcEndpointResponse>()
                    .withOperationName("CreateVpcEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVpcEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVpcEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service domain and all of its data. You can't recover a domain after you delete it.
     * </p>
     *
     * @param deleteDomainRequest
     *        Container for the parameters to the <code>DeleteDomain</code> operation.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DeleteDomain
     */
    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomain");

            return clientHandler.execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                    .withOperationName("DeleteDomain").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows the destination Amazon OpenSearch Service domain owner to delete an existing inbound cross-cluster search
     * connection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param deleteInboundConnectionRequest
     *        Container for the parameters to the <code>DeleteInboundConnection</code> operation.
     * @return Result of the DeleteInboundConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DeleteInboundConnection
     */
    @Override
    public DeleteInboundConnectionResponse deleteInboundConnection(DeleteInboundConnectionRequest deleteInboundConnectionRequest)
            throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInboundConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInboundConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInboundConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInboundConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInboundConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInboundConnectionRequest, DeleteInboundConnectionResponse>()
                            .withOperationName("DeleteInboundConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteInboundConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteInboundConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows the source Amazon OpenSearch Service domain owner to delete an existing outbound cross-cluster search
     * connection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param deleteOutboundConnectionRequest
     *        Container for the parameters to the <code>DeleteOutboundConnection</code> operation.
     * @return Result of the DeleteOutboundConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DeleteOutboundConnection
     */
    @Override
    public DeleteOutboundConnectionResponse deleteOutboundConnection(
            DeleteOutboundConnectionRequest deleteOutboundConnectionRequest) throws ResourceNotFoundException,
            DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOutboundConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteOutboundConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOutboundConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOutboundConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOutboundConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOutboundConnectionRequest, DeleteOutboundConnectionResponse>()
                            .withOperationName("DeleteOutboundConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteOutboundConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteOutboundConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service package. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param deletePackageRequest
     *        Deletes a package from OpenSearch Service. The package can't be associated with any OpenSearch Service
     *        domain.
     * @return Result of the DeletePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DeletePackage
     */
    @Override
    public DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePackage");

            return clientHandler.execute(new ClientExecutionParams<DeletePackageRequest, DeletePackageResponse>()
                    .withOperationName("DeletePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     *
     * @param deleteVpcEndpointRequest
     * @return Result of the DeleteVpcEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DeleteVpcEndpoint
     */
    @Override
    public DeleteVpcEndpointResponse deleteVpcEndpoint(DeleteVpcEndpointRequest deleteVpcEndpointRequest)
            throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVpcEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteVpcEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DeleteVpcEndpointRequest, DeleteVpcEndpointResponse>()
                    .withOperationName("DeleteVpcEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVpcEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVpcEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the domain configuration for the specified Amazon OpenSearch Service domain, including the domain ID,
     * domain service endpoint, and domain ARN.
     * </p>
     *
     * @param describeDomainRequest
     *        Container for the parameters to the <code>DescribeDomain</code> operation.
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeDomain
     */
    @Override
    public DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomain");

            return clientHandler.execute(new ClientExecutionParams<DescribeDomainRequest, DescribeDomainResponse>()
                    .withOperationName("DescribeDomain").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch Service domain. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon
     * OpenSearch Service</a>.
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return Result of the DescribeDomainAutoTunes operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeDomainAutoTunes
     */
    @Override
    public DescribeDomainAutoTunesResponse describeDomainAutoTunes(DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainAutoTunesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDomainAutoTunesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainAutoTunesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainAutoTunesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainAutoTunes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainAutoTunesRequest, DescribeDomainAutoTunesResponse>()
                            .withOperationName("DescribeDomainAutoTunes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDomainAutoTunesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDomainAutoTunesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the current blue/green deployment happening on an Amazon OpenSearch Service domain. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html"
     * >Making configuration changes in Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeDomainChangeProgressRequest
     *        Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation.
     * @return Result of the DescribeDomainChangeProgress operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeDomainChangeProgress
     */
    @Override
    public DescribeDomainChangeProgressResponse describeDomainChangeProgress(
            DescribeDomainChangeProgressRequest describeDomainChangeProgressRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainChangeProgressResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDomainChangeProgressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainChangeProgressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainChangeProgressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainChangeProgress");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainChangeProgressRequest, DescribeDomainChangeProgressResponse>()
                            .withOperationName("DescribeDomainChangeProgress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDomainChangeProgressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDomainChangeProgressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the configuration of an Amazon OpenSearch Service domain.
     * </p>
     *
     * @param describeDomainConfigRequest
     *        Container for the parameters to the <code>DescribeDomainConfig</code> operation.
     * @return Result of the DescribeDomainConfig operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeDomainConfig
     */
    @Override
    public DescribeDomainConfigResponse describeDomainConfig(DescribeDomainConfigRequest describeDomainConfigRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDomainConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainConfig");

            return clientHandler.execute(new ClientExecutionParams<DescribeDomainConfigRequest, DescribeDomainConfigResponse>()
                    .withOperationName("DescribeDomainConfig").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDomainConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDomainConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about domain and node health, the standby Availability Zone, number of nodes per Availability
     * Zone, and shard count per node.
     * </p>
     *
     * @param describeDomainHealthRequest
     *        Container for the parameters to the <code>DescribeDomainHealth</code> operation.
     * @return Result of the DescribeDomainHealth operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeDomainHealth
     */
    @Override
    public DescribeDomainHealthResponse describeDomainHealth(DescribeDomainHealthRequest describeDomainHealthRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainHealthResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDomainHealthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainHealthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainHealthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainHealth");

            return clientHandler.execute(new ClientExecutionParams<DescribeDomainHealthRequest, DescribeDomainHealthResponse>()
                    .withOperationName("DescribeDomainHealth").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDomainHealthRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDomainHealthRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about domain and nodes, including data nodes, master nodes, ultrawarm nodes, Availability
     * Zone(s), standby nodes, node configurations, and node states.
     * </p>
     *
     * @param describeDomainNodesRequest
     *        Container for the parameters to the <code>DescribeDomainNodes</code> operation.
     * @return Result of the DescribeDomainNodes operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws DependencyFailureException
     *         An exception for when a failure in one of the dependencies results in the service being unable to fetch
     *         details about the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeDomainNodes
     */
    @Override
    public DescribeDomainNodesResponse describeDomainNodes(DescribeDomainNodesRequest describeDomainNodesRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException,
            DependencyFailureException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainNodesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDomainNodesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainNodesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainNodes");

            return clientHandler.execute(new ClientExecutionParams<DescribeDomainNodesRequest, DescribeDomainNodesResponse>()
                    .withOperationName("DescribeDomainNodes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDomainNodesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDomainNodesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Amazon OpenSearch Service domains.
     * </p>
     *
     * @param describeDomainsRequest
     *        Container for the parameters to the <code>DescribeDomains</code> operation.
     * @return Result of the DescribeDomains operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeDomains
     */
    @Override
    public DescribeDomainsResponse describeDomains(DescribeDomainsRequest describeDomainsRequest) throws BaseException,
            InternalException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDomainsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomains");

            return clientHandler.execute(new ClientExecutionParams<DescribeDomainsRequest, DescribeDomainsResponse>()
                    .withOperationName("DescribeDomains").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDomainsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDomainsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch Service domain. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#dryrun"
     * >Determining whether a change will cause a blue/green deployment</a>.
     * </p>
     *
     * @param describeDryRunProgressRequest
     * @return Result of the DescribeDryRunProgress operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeDryRunProgress
     */
    @Override
    public DescribeDryRunProgressResponse describeDryRunProgress(DescribeDryRunProgressRequest describeDryRunProgressRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDryRunProgressResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDryRunProgressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDryRunProgressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDryRunProgressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDryRunProgress");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDryRunProgressRequest, DescribeDryRunProgressResponse>()
                            .withOperationName("DescribeDryRunProgress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDryRunProgressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDryRunProgressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination (remote) Amazon OpenSearch Service
     * domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        Container for the parameters to the <code>DescribeInboundConnections</code> operation.
     * @return Result of the DescribeInboundConnections operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         Request processing failed because you provided an invalid pagination token.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeInboundConnections
     */
    @Override
    public DescribeInboundConnectionsResponse describeInboundConnections(
            DescribeInboundConnectionsRequest describeInboundConnectionsRequest) throws InvalidPaginationTokenException,
            DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInboundConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInboundConnectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInboundConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInboundConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInboundConnections");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInboundConnectionsRequest, DescribeInboundConnectionsResponse>()
                            .withOperationName("DescribeInboundConnections").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeInboundConnectionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInboundConnectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the instance count, storage, and master node limits for a given OpenSearch or Elasticsearch version and
     * instance type.
     * </p>
     *
     * @param describeInstanceTypeLimitsRequest
     *        Container for the parameters to the <code>DescribeInstanceTypeLimits</code> operation.
     * @return Result of the DescribeInstanceTypeLimits operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws InvalidTypeException
     *         An exception for trying to create or access a sub-resource that's either invalid or not supported.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeInstanceTypeLimits
     */
    @Override
    public DescribeInstanceTypeLimitsResponse describeInstanceTypeLimits(
            DescribeInstanceTypeLimitsRequest describeInstanceTypeLimitsRequest) throws BaseException, InternalException,
            InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInstanceTypeLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInstanceTypeLimitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInstanceTypeLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstanceTypeLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceTypeLimits");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceTypeLimitsRequest, DescribeInstanceTypeLimitsResponse>()
                            .withOperationName("DescribeInstanceTypeLimits").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeInstanceTypeLimitsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInstanceTypeLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster connections for a local (source) Amazon OpenSearch Service domain. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        Container for the parameters to the <code>DescribeOutboundConnections</code> operation.
     * @return Result of the DescribeOutboundConnections operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         Request processing failed because you provided an invalid pagination token.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeOutboundConnections
     */
    @Override
    public DescribeOutboundConnectionsResponse describeOutboundConnections(
            DescribeOutboundConnectionsRequest describeOutboundConnectionsRequest) throws InvalidPaginationTokenException,
            DisabledOperationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOutboundConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeOutboundConnectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOutboundConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOutboundConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOutboundConnections");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOutboundConnectionsRequest, DescribeOutboundConnectionsResponse>()
                            .withOperationName("DescribeOutboundConnections").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeOutboundConnectionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOutboundConnectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes all packages available to OpenSearch Service. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describePackagesRequest
     *        Container for the request parameters to the <code>DescribePackage</code> operation.
     * @return Result of the DescribePackages operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribePackages
     */
    @Override
    public DescribePackagesResponse describePackages(DescribePackagesRequest describePackagesRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePackagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribePackagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePackagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePackages");

            return clientHandler.execute(new ClientExecutionParams<DescribePackagesRequest, DescribePackagesResponse>()
                    .withOperationName("DescribePackages").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describePackagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePackagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the available Amazon OpenSearch Service Reserved Instance offerings for a given Region. For more
     * information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html">Reserved
     * Instances in Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        Container for the request parameters to a <code>DescribeReservedInstanceOfferings</code> operation.
     * @return Result of the DescribeReservedInstanceOfferings operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeReservedInstanceOfferings
     */
    @Override
    public DescribeReservedInstanceOfferingsResponse describeReservedInstanceOfferings(
            DescribeReservedInstanceOfferingsRequest describeReservedInstanceOfferingsRequest) throws ResourceNotFoundException,
            ValidationException, DisabledOperationException, InternalException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReservedInstanceOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReservedInstanceOfferingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedInstanceOfferingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedInstanceOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedInstanceOfferings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedInstanceOfferingsRequest, DescribeReservedInstanceOfferingsResponse>()
                            .withOperationName("DescribeReservedInstanceOfferings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeReservedInstanceOfferingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReservedInstanceOfferingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the Amazon OpenSearch Service instances that you have reserved in a given Region. For more information,
     * see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html">Reserved Instances in
     * Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        Container for the request parameters to the <code>DescribeReservedInstances</code> operation.
     * @return Result of the DescribeReservedInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeReservedInstances
     */
    @Override
    public DescribeReservedInstancesResponse describeReservedInstances(
            DescribeReservedInstancesRequest describeReservedInstancesRequest) throws ResourceNotFoundException,
            InternalException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReservedInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReservedInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservedInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedInstancesRequest, DescribeReservedInstancesResponse>()
                            .withOperationName("DescribeReservedInstances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeReservedInstancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReservedInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     * </p>
     *
     * @param describeVpcEndpointsRequest
     * @return Result of the DescribeVpcEndpoints operation returned by the service.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DescribeVpcEndpoints
     */
    @Override
    public DescribeVpcEndpointsResponse describeVpcEndpoints(DescribeVpcEndpointsRequest describeVpcEndpointsRequest)
            throws ValidationException, InternalException, DisabledOperationException, BaseException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeVpcEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeVpcEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVpcEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeVpcEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVpcEndpoints");

            return clientHandler.execute(new ClientExecutionParams<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResponse>()
                    .withOperationName("DescribeVpcEndpoints").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeVpcEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeVpcEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a package from the specified Amazon OpenSearch Service domain. The package can't be in use with any
     * OpenSearch index for the dissociation to succeed. The package is still available in OpenSearch Service for
     * association later. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param dissociatePackageRequest
     *        Container for the request parameters to the <code>DissociatePackage</code> operation.
     * @return Result of the DissociatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.DissociatePackage
     */
    @Override
    public DissociatePackageResponse dissociatePackage(DissociatePackageRequest dissociatePackageRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DissociatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DissociatePackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(dissociatePackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, dissociatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DissociatePackage");

            return clientHandler.execute(new ClientExecutionParams<DissociatePackageRequest, DissociatePackageResponse>()
                    .withOperationName("DissociatePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(dissociatePackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DissociatePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
     * </p>
     *
     * @param getCompatibleVersionsRequest
     *        Container for the request parameters to <code>GetCompatibleVersions</code> operation.
     * @return Result of the GetCompatibleVersions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.GetCompatibleVersions
     */
    @Override
    public GetCompatibleVersionsResponse getCompatibleVersions(GetCompatibleVersionsRequest getCompatibleVersionsRequest)
            throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCompatibleVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCompatibleVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCompatibleVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCompatibleVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCompatibleVersions");

            return clientHandler.execute(new ClientExecutionParams<GetCompatibleVersionsRequest, GetCompatibleVersionsResponse>()
                    .withOperationName("GetCompatibleVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCompatibleVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCompatibleVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The status of the maintenance action.
     * </p>
     *
     * @param getDomainMaintenanceStatusRequest
     *        Container for the parameters to the <code>GetDomainMaintenanceStatus</code> operation.
     * @return Result of the GetDomainMaintenanceStatus operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.GetDomainMaintenanceStatus
     */
    @Override
    public GetDomainMaintenanceStatusResponse getDomainMaintenanceStatus(
            GetDomainMaintenanceStatusRequest getDomainMaintenanceStatusRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDomainMaintenanceStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDomainMaintenanceStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDomainMaintenanceStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainMaintenanceStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainMaintenanceStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDomainMaintenanceStatusRequest, GetDomainMaintenanceStatusResponse>()
                            .withOperationName("GetDomainMaintenanceStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getDomainMaintenanceStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDomainMaintenanceStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of Amazon OpenSearch Service package versions, along with their creation time, commit message, and
     * plugin properties (if the package is a zip plugin package). For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for the request parameters to the <code>GetPackageVersionHistory</code> operation.
     * @return Result of the GetPackageVersionHistory operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.GetPackageVersionHistory
     */
    @Override
    public GetPackageVersionHistoryResponse getPackageVersionHistory(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPackageVersionHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPackageVersionHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPackageVersionHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPackageVersionHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPackageVersionHistory");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPackageVersionHistoryRequest, GetPackageVersionHistoryResponse>()
                            .withOperationName("GetPackageVersionHistory").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getPackageVersionHistoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPackageVersionHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades performed on an Amazon OpenSearch Service domain.
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for the request parameters to the <code>GetUpgradeHistory</code> operation.
     * @return Result of the GetUpgradeHistory operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.GetUpgradeHistory
     */
    @Override
    public GetUpgradeHistoryResponse getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) throws BaseException,
            ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUpgradeHistoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUpgradeHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUpgradeHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUpgradeHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUpgradeHistory");

            return clientHandler.execute(new ClientExecutionParams<GetUpgradeHistoryRequest, GetUpgradeHistoryResponse>()
                    .withOperationName("GetUpgradeHistory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getUpgradeHistoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUpgradeHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the most recent status of the last upgrade or upgrade eligibility check performed on an Amazon OpenSearch
     * Service domain.
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        Container for the request parameters to the <code>GetUpgradeStatus</code> operation.
     * @return Result of the GetUpgradeStatus operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.GetUpgradeStatus
     */
    @Override
    public GetUpgradeStatusResponse getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) throws BaseException,
            ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUpgradeStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUpgradeStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUpgradeStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUpgradeStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUpgradeStatus");

            return clientHandler.execute(new ClientExecutionParams<GetUpgradeStatusRequest, GetUpgradeStatusResponse>()
                    .withOperationName("GetUpgradeStatus").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getUpgradeStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUpgradeStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of maintenance actions for the domain.
     * </p>
     *
     * @param listDomainMaintenancesRequest
     *        Container for the parameters to the <code>ListDomainMaintenances</code> operation.
     * @return Result of the ListDomainMaintenances operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListDomainMaintenances
     */
    @Override
    public ListDomainMaintenancesResponse listDomainMaintenances(ListDomainMaintenancesRequest listDomainMaintenancesRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDomainMaintenancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDomainMaintenancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDomainMaintenancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainMaintenancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainMaintenances");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDomainMaintenancesRequest, ListDomainMaintenancesResponse>()
                            .withOperationName("ListDomainMaintenances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listDomainMaintenancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDomainMaintenancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the names of all Amazon OpenSearch Service domains owned by the current user in the active Region.
     * </p>
     *
     * @param listDomainNamesRequest
     *        Container for the parameters to the <code>ListDomainNames</code> operation.
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListDomainNames
     */
    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDomainNamesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDomainNamesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainNames");

            return clientHandler.execute(new ClientExecutionParams<ListDomainNamesRequest, ListDomainNamesResponse>()
                    .withOperationName("ListDomainNames").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDomainNamesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDomainNamesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Amazon OpenSearch Service domains associated with a given package. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for the request parameters to the <code>ListDomainsForPackage</code> operation.
     * @return Result of the ListDomainsForPackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListDomainsForPackage
     */
    @Override
    public ListDomainsForPackageResponse listDomainsForPackage(ListDomainsForPackageRequest listDomainsForPackageRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDomainsForPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDomainsForPackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDomainsForPackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainsForPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainsForPackage");

            return clientHandler.execute(new ClientExecutionParams<ListDomainsForPackageRequest, ListDomainsForPackageResponse>()
                    .withOperationName("ListDomainsForPackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDomainsForPackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDomainsForPackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all instance types and available features for a given OpenSearch or Elasticsearch version.
     * </p>
     *
     * @param listInstanceTypeDetailsRequest
     * @return Result of the ListInstanceTypeDetails operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListInstanceTypeDetails
     */
    @Override
    public ListInstanceTypeDetailsResponse listInstanceTypeDetails(ListInstanceTypeDetailsRequest listInstanceTypeDetailsRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInstanceTypeDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListInstanceTypeDetailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInstanceTypeDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstanceTypeDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstanceTypeDetails");

            return clientHandler
                    .execute(new ClientExecutionParams<ListInstanceTypeDetailsRequest, ListInstanceTypeDetailsResponse>()
                            .withOperationName("ListInstanceTypeDetails").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listInstanceTypeDetailsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListInstanceTypeDetailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all packages associated with an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for the request parameters to the <code>ListPackagesForDomain</code> operation.
     * @return Result of the ListPackagesForDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListPackagesForDomain
     */
    @Override
    public ListPackagesForDomainResponse listPackagesForDomain(ListPackagesForDomainRequest listPackagesForDomainRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPackagesForDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPackagesForDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPackagesForDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPackagesForDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPackagesForDomain");

            return clientHandler.execute(new ClientExecutionParams<ListPackagesForDomainRequest, ListPackagesForDomainResponse>()
                    .withOperationName("ListPackagesForDomain").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPackagesForDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPackagesForDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of configuration changes that are scheduled for a domain. These changes can be <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service
     * software updates</a> or <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types"
     * >blue/green Auto-Tune enhancements</a>.
     * </p>
     *
     * @param listScheduledActionsRequest
     * @return Result of the ListScheduledActions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InvalidPaginationTokenException
     *         Request processing failed because you provided an invalid pagination token.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListScheduledActions
     */
    @Override
    public ListScheduledActionsResponse listScheduledActions(ListScheduledActionsRequest listScheduledActionsRequest)
            throws BaseException, InternalException, ResourceNotFoundException, InvalidPaginationTokenException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListScheduledActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListScheduledActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listScheduledActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listScheduledActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListScheduledActions");

            return clientHandler.execute(new ClientExecutionParams<ListScheduledActionsRequest, ListScheduledActionsResponse>()
                    .withOperationName("ListScheduledActions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listScheduledActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListScheduledActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns all resource tags for an Amazon OpenSearch Service domain. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html"
     * >Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     *
     * @param listTagsRequest
     *        Container for the parameters to the <code>ListTags</code> operation.
     * @return Result of the ListTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListTags
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws BaseException, ResourceNotFoundException,
            ValidationException, InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");

            return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>()
                    .withOperationName("ListTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.
     * </p>
     *
     * @param listVersionsRequest
     *        Container for the request parameters to the <code>ListVersions</code> operation.
     * @return Result of the ListVersions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListVersions
     */
    @Override
    public ListVersionsResponse listVersions(ListVersionsRequest listVersionsRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVersions");

            return clientHandler.execute(new ClientExecutionParams<ListVersionsRequest, ListVersionsResponse>()
                    .withOperationName("ListVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about each Amazon Web Services principal that is allowed to access a given Amazon
     * OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     *
     * @param listVpcEndpointAccessRequest
     * @return Result of the ListVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListVpcEndpointAccess
     */
    @Override
    public ListVpcEndpointAccessResponse listVpcEndpointAccess(ListVpcEndpointAccessRequest listVpcEndpointAccessRequest)
            throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException,
            SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVpcEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVpcEndpointAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpcEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVpcEndpointAccess");

            return clientHandler.execute(new ClientExecutionParams<ListVpcEndpointAccessRequest, ListVpcEndpointAccessResponse>()
                    .withOperationName("ListVpcEndpointAccess").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listVpcEndpointAccessRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVpcEndpointAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current Amazon Web Services account and
     * Region.
     * </p>
     *
     * @param listVpcEndpointsRequest
     * @return Result of the ListVpcEndpoints operation returned by the service.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListVpcEndpoints
     */
    @Override
    public ListVpcEndpointsResponse listVpcEndpoints(ListVpcEndpointsRequest listVpcEndpointsRequest) throws InternalException,
            DisabledOperationException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVpcEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListVpcEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpcEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVpcEndpoints");

            return clientHandler.execute(new ClientExecutionParams<ListVpcEndpointsRequest, ListVpcEndpointsResponse>()
                    .withOperationName("ListVpcEndpoints").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listVpcEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVpcEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     * </p>
     *
     * @param listVpcEndpointsForDomainRequest
     * @return Result of the ListVpcEndpointsForDomain operation returned by the service.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.ListVpcEndpointsForDomain
     */
    @Override
    public ListVpcEndpointsForDomainResponse listVpcEndpointsForDomain(
            ListVpcEndpointsForDomainRequest listVpcEndpointsForDomainRequest) throws InternalException,
            DisabledOperationException, ResourceNotFoundException, BaseException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVpcEndpointsForDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVpcEndpointsForDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcEndpointsForDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpcEndpointsForDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVpcEndpointsForDomain");

            return clientHandler
                    .execute(new ClientExecutionParams<ListVpcEndpointsForDomainRequest, ListVpcEndpointsForDomainResponse>()
                            .withOperationName("ListVpcEndpointsForDomain").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listVpcEndpointsForDomainRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListVpcEndpointsForDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to purchase Amazon OpenSearch Service Reserved Instances.
     * </p>
     *
     * @param purchaseReservedInstanceOfferingRequest
     *        Container for request parameters to the <code>PurchaseReservedInstanceOffering</code> operation.
     * @return Result of the PurchaseReservedInstanceOffering operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.PurchaseReservedInstanceOffering
     */
    @Override
    public PurchaseReservedInstanceOfferingResponse purchaseReservedInstanceOffering(
            PurchaseReservedInstanceOfferingRequest purchaseReservedInstanceOfferingRequest) throws ResourceNotFoundException,
            ResourceAlreadyExistsException, LimitExceededException, DisabledOperationException, ValidationException,
            InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PurchaseReservedInstanceOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PurchaseReservedInstanceOfferingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseReservedInstanceOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                purchaseReservedInstanceOfferingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedInstanceOffering");

            return clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedInstanceOfferingRequest, PurchaseReservedInstanceOfferingResponse>()
                            .withOperationName("PurchaseReservedInstanceOffering").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(purchaseReservedInstanceOfferingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PurchaseReservedInstanceOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows the remote Amazon OpenSearch Service domain owner to reject an inbound cross-cluster connection request.
     * </p>
     *
     * @param rejectInboundConnectionRequest
     *        Container for the request parameters to the <code>RejectInboundConnection</code> operation.
     * @return Result of the RejectInboundConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.RejectInboundConnection
     */
    @Override
    public RejectInboundConnectionResponse rejectInboundConnection(RejectInboundConnectionRequest rejectInboundConnectionRequest)
            throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException,
            OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectInboundConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RejectInboundConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectInboundConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectInboundConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectInboundConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<RejectInboundConnectionRequest, RejectInboundConnectionResponse>()
                            .withOperationName("RejectInboundConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(rejectInboundConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RejectInboundConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified set of tags from an Amazon OpenSearch Service domain. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging"
     * > Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     *
     * @param removeTagsRequest
     *        Container for the request parameters to the <code>RemoveTags</code> operation.
     * @return Result of the RemoveTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.RemoveTags
     */
    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws BaseException, ValidationException,
            InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTags");

            return clientHandler.execute(new ClientExecutionParams<RemoveTagsRequest, RemoveTagsResponse>()
                    .withOperationName("RemoveTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(removeTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     * </p>
     *
     * @param revokeVpcEndpointAccessRequest
     * @return Result of the RevokeVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.RevokeVpcEndpointAccess
     */
    @Override
    public RevokeVpcEndpointAccessResponse revokeVpcEndpointAccess(RevokeVpcEndpointAccessRequest revokeVpcEndpointAccessRequest)
            throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException, BaseException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RevokeVpcEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RevokeVpcEndpointAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeVpcEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeVpcEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeVpcEndpointAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<RevokeVpcEndpointAccessRequest, RevokeVpcEndpointAccessResponse>()
                            .withOperationName("RevokeVpcEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(revokeVpcEndpointAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RevokeVpcEndpointAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the node maintenance process on the data node. These processes can include a node reboot, an Opensearch or
     * Elasticsearch process restart, or a Dashboard or Kibana restart.
     * </p>
     *
     * @param startDomainMaintenanceRequest
     *        Container for the parameters to the <code>StartDomainMaintenance</code> operation.
     * @return Result of the StartDomainMaintenance operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.StartDomainMaintenance
     */
    @Override
    public StartDomainMaintenanceResponse startDomainMaintenance(StartDomainMaintenanceRequest startDomainMaintenanceRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartDomainMaintenanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartDomainMaintenanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDomainMaintenanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDomainMaintenanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDomainMaintenance");

            return clientHandler
                    .execute(new ClientExecutionParams<StartDomainMaintenanceRequest, StartDomainMaintenanceResponse>()
                            .withOperationName("StartDomainMaintenance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startDomainMaintenanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartDomainMaintenanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service
     * software updates in Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param startServiceSoftwareUpdateRequest
     *        Container for the request parameters to the <code>StartServiceSoftwareUpdate</code> operation.
     * @return Result of the StartServiceSoftwareUpdate operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.StartServiceSoftwareUpdate
     */
    @Override
    public StartServiceSoftwareUpdateResponse startServiceSoftwareUpdate(
            StartServiceSoftwareUpdateRequest startServiceSoftwareUpdateRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartServiceSoftwareUpdateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartServiceSoftwareUpdateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startServiceSoftwareUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startServiceSoftwareUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartServiceSoftwareUpdate");

            return clientHandler
                    .execute(new ClientExecutionParams<StartServiceSoftwareUpdateRequest, StartServiceSoftwareUpdateResponse>()
                            .withOperationName("StartServiceSoftwareUpdate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startServiceSoftwareUpdateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartServiceSoftwareUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Amazon OpenSearch Service domain.
     * </p>
     *
     * @param updateDomainConfigRequest
     *        Container for the request parameters to the <code>UpdateDomain</code> operation.
     * @return Result of the UpdateDomainConfig operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws InvalidTypeException
     *         An exception for trying to create or access a sub-resource that's either invalid or not supported.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.UpdateDomainConfig
     */
    @Override
    public UpdateDomainConfigResponse updateDomainConfig(UpdateDomainConfigRequest updateDomainConfigRequest)
            throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDomainConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDomainConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDomainConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDomainConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDomainConfig");

            return clientHandler.execute(new ClientExecutionParams<UpdateDomainConfigRequest, UpdateDomainConfigResponse>()
                    .withOperationName("UpdateDomainConfig").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDomainConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDomainConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a package for use with Amazon OpenSearch Service domains. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param updatePackageRequest
     *        Container for request parameters to the <code>UpdatePackage</code> operation.
     * @return Result of the UpdatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws AccessDeniedException
     *         An error occurred because you don't have permissions to access the resource.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.UpdatePackage
     */
    @Override
    public UpdatePackageResponse updatePackage(UpdatePackageRequest updatePackageRequest) throws BaseException,
            InternalException, LimitExceededException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePackage");

            return clientHandler.execute(new ClientExecutionParams<UpdatePackageRequest, UpdatePackageResponse>()
                    .withOperationName("UpdatePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updatePackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reschedules a planned domain configuration change for a later time. This change can be a scheduled <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service
     * software update</a> or a <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types"
     * >blue/green Auto-Tune enhancement</a>.
     * </p>
     *
     * @param updateScheduledActionRequest
     * @return Result of the UpdateScheduledAction operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SlotNotAvailableException
     *         An exception for attempting to schedule a domain action during an unavailable time slot.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use.
     * @throws LimitExceededException
     *         An exception for trying to create more than the allowed number of resources or sub-resources.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.UpdateScheduledAction
     */
    @Override
    public UpdateScheduledActionResponse updateScheduledAction(UpdateScheduledActionRequest updateScheduledActionRequest)
            throws BaseException, InternalException, ResourceNotFoundException, SlotNotAvailableException, ConflictException,
            LimitExceededException, ValidationException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateScheduledActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateScheduledActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateScheduledActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateScheduledActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateScheduledAction");

            return clientHandler.execute(new ClientExecutionParams<UpdateScheduledActionRequest, UpdateScheduledActionResponse>()
                    .withOperationName("UpdateScheduledAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateScheduledActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateScheduledActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     *
     * @param updateVpcEndpointRequest
     * @return Result of the UpdateVpcEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.UpdateVpcEndpoint
     */
    @Override
    public UpdateVpcEndpointResponse updateVpcEndpoint(UpdateVpcEndpointRequest updateVpcEndpointRequest)
            throws ResourceNotFoundException, DisabledOperationException, InternalException, ValidationException,
            ConflictException, BaseException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVpcEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateVpcEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVpcEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVpcEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVpcEndpoint");

            return clientHandler.execute(new ClientExecutionParams<UpdateVpcEndpointRequest, UpdateVpcEndpointResponse>()
                    .withOperationName("UpdateVpcEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateVpcEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVpcEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to either upgrade your Amazon OpenSearch Service domain or perform an upgrade eligibility check to a
     * compatible version of OpenSearch or Elasticsearch.
     * </p>
     *
     * @param upgradeDomainRequest
     *        Container for the request parameters to the <code>UpgradeDomain</code> operation.
     * @return Result of the UpgradeDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access an unsupported operation.
     * @throws ValidationException
     *         An exception for accessing or deleting a resource that doesn't exist.
     * @throws InternalException
     *         Request processing failed because of an unknown error, exception, or internal failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchClient.UpgradeDomain
     */
    @Override
    public UpgradeDomainResponse upgradeDomain(UpgradeDomainRequest upgradeDomainRequest) throws BaseException,
            ResourceNotFoundException, ResourceAlreadyExistsException, DisabledOperationException, ValidationException,
            InternalException, AwsServiceException, SdkClientException, OpenSearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpgradeDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpgradeDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(upgradeDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, upgradeDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "OpenSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpgradeDomain");

            return clientHandler.execute(new ClientExecutionParams<UpgradeDomainRequest, UpgradeDomainResponse>()
                    .withOperationName("UpgradeDomain").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(upgradeDomainRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpgradeDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        OpenSearchServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = OpenSearchServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(OpenSearchException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DisabledOperationException")
                                .exceptionBuilderSupplier(DisabledOperationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SlotNotAvailableException")
                                .exceptionBuilderSupplier(SlotNotAvailableException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DependencyFailureException")
                                .exceptionBuilderSupplier(DependencyFailureException::builder).httpStatusCode(424).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTypeException")
                                .exceptionBuilderSupplier(InvalidTypeException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalException")
                                .exceptionBuilderSupplier(InternalException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder)
                                .build());
    }

    @Override
    public final OpenSearchServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
