/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The duration of a maintenance schedule. For more information, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon
 * OpenSearch Service</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Duration implements SdkPojo, Serializable, ToCopyableBuilder<Duration.Builder, Duration> {
    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Value")
            .getter(getter(Duration::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(Duration::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long value;

    private final String unit;

    private Duration(BuilderImpl builder) {
        this.value = builder.value;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * Integer to specify the value of a maintenance schedule duration.
     * </p>
     * 
     * @return Integer to specify the value of a maintenance schedule duration.
     */
    public final Long value() {
        return value;
    }

    /**
     * <p>
     * The unit of measurement for the duration of a maintenance schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measurement for the duration of a maintenance schedule.
     * @see TimeUnit
     */
    public final TimeUnit unit() {
        return TimeUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of measurement for the duration of a maintenance schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measurement for the duration of a maintenance schedule.
     * @see TimeUnit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration other = (Duration) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Duration").add("Value", value()).add("Unit", unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Duration, T> g) {
        return obj -> g.apply((Duration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Duration> {
        /**
         * <p>
         * Integer to specify the value of a maintenance schedule duration.
         * </p>
         * 
         * @param value
         *        Integer to specify the value of a maintenance schedule duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);

        /**
         * <p>
         * The unit of measurement for the duration of a maintenance schedule.
         * </p>
         * 
         * @param unit
         *        The unit of measurement for the duration of a maintenance schedule.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of measurement for the duration of a maintenance schedule.
         * </p>
         * 
         * @param unit
         *        The unit of measurement for the duration of a maintenance schedule.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder unit(TimeUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Long value;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Duration model) {
            value(model.value);
            unit(model.unit);
        }

        public final Long getValue() {
            return value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(TimeUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public Duration build() {
            return new Duration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
