/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReadSetActivationJobsResponse extends OmicsResponse implements
        ToCopyableBuilder<ListReadSetActivationJobsResponse.Builder, ListReadSetActivationJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReadSetActivationJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ActivateReadSetJobItem>> ACTIVATION_JOBS_FIELD = SdkField
            .<List<ActivateReadSetJobItem>> builder(MarshallingType.LIST)
            .memberName("activationJobs")
            .getter(getter(ListReadSetActivationJobsResponse::activationJobs))
            .setter(setter(Builder::activationJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActivateReadSetJobItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActivateReadSetJobItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ACTIVATION_JOBS_FIELD));

    private final String nextToken;

    private final List<ActivateReadSetJobItem> activationJobs;

    private ListReadSetActivationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.activationJobs = builder.activationJobs;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActivationJobs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActivationJobs() {
        return activationJobs != null && !(activationJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActivationJobs} method.
     * </p>
     * 
     * @return A list of jobs.
     */
    public final List<ActivateReadSetJobItem> activationJobs() {
        return activationJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasActivationJobs() ? activationJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetActivationJobsResponse)) {
            return false;
        }
        ListReadSetActivationJobsResponse other = (ListReadSetActivationJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasActivationJobs() == other.hasActivationJobs()
                && Objects.equals(activationJobs(), other.activationJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReadSetActivationJobsResponse").add("NextToken", nextToken())
                .add("ActivationJobs", hasActivationJobs() ? activationJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "activationJobs":
            return Optional.ofNullable(clazz.cast(activationJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetActivationJobsResponse, T> g) {
        return obj -> g.apply((ListReadSetActivationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReadSetActivationJobsResponse> {
        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param activationJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationJobs(Collection<ActivateReadSetJobItem> activationJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param activationJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationJobs(ActivateReadSetJobItem... activationJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem.Builder#build()} is called
         * immediately and its result is passed to {@link #activationJobs(List<ActivateReadSetJobItem>)}.
         * 
         * @param activationJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activationJobs(java.util.Collection<ActivateReadSetJobItem>)
         */
        Builder activationJobs(Consumer<ActivateReadSetJobItem.Builder>... activationJobs);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ActivateReadSetJobItem> activationJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetActivationJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            activationJobs(model.activationJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ActivateReadSetJobItem.Builder> getActivationJobs() {
            List<ActivateReadSetJobItem.Builder> result = ActivateReadSetJobListCopier.copyToBuilder(this.activationJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActivationJobs(Collection<ActivateReadSetJobItem.BuilderImpl> activationJobs) {
            this.activationJobs = ActivateReadSetJobListCopier.copyFromBuilder(activationJobs);
        }

        @Override
        public final Builder activationJobs(Collection<ActivateReadSetJobItem> activationJobs) {
            this.activationJobs = ActivateReadSetJobListCopier.copy(activationJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationJobs(ActivateReadSetJobItem... activationJobs) {
            activationJobs(Arrays.asList(activationJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationJobs(Consumer<ActivateReadSetJobItem.Builder>... activationJobs) {
            activationJobs(Stream.of(activationJobs).map(c -> ActivateReadSetJobItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReadSetActivationJobsResponse build() {
            return new ListReadSetActivationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
