/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for annotation import jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnnotationImportJobsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListAnnotationImportJobsFilter.Builder, ListAnnotationImportJobsFilter> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListAnnotationImportJobsFilter::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeName").getter(getter(ListAnnotationImportJobsFilter::storeName)).setter(setter(Builder::storeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STATUS_FIELD, STORE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String storeName;

    private ListAnnotationImportJobsFilter(BuilderImpl builder) {
        this.status = builder.status;
        this.storeName = builder.storeName;
    }

    /**
     * <p>
     * A status to filter on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status to filter on.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * A status to filter on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status to filter on.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A store name to filter on.
     * </p>
     * 
     * @return A store name to filter on.
     */
    public final String storeName() {
        return storeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnnotationImportJobsFilter)) {
            return false;
        }
        ListAnnotationImportJobsFilter other = (ListAnnotationImportJobsFilter) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(storeName(), other.storeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnnotationImportJobsFilter").add("Status", statusAsString()).add("StoreName", storeName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "storeName":
            return Optional.ofNullable(clazz.cast(storeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnnotationImportJobsFilter, T> g) {
        return obj -> g.apply((ListAnnotationImportJobsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListAnnotationImportJobsFilter> {
        /**
         * <p>
         * A status to filter on.
         * </p>
         * 
         * @param status
         *        A status to filter on.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status to filter on.
         * </p>
         * 
         * @param status
         *        A status to filter on.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * A store name to filter on.
         * </p>
         * 
         * @param storeName
         *        A store name to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeName(String storeName);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String storeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnnotationImportJobsFilter model) {
            status(model.status);
            storeName(model.storeName);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStoreName() {
            return storeName;
        }

        public final void setStoreName(String storeName) {
            this.storeName = storeName;
        }

        @Override
        public final Builder storeName(String storeName) {
            this.storeName = storeName;
            return this;
        }

        @Override
        public ListAnnotationImportJobsFilter build() {
            return new ListAnnotationImportJobsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
