/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A workflow run task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskListItem implements SdkPojo, Serializable, ToCopyableBuilder<TaskListItem.Builder, TaskListItem> {
    private static final SdkField<Integer> CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("cpus")
            .getter(getter(TaskListItem::cpus)).setter(setter(Builder::cpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(TaskListItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memory").getter(getter(TaskListItem::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TaskListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(TaskListItem::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TaskListItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopTime")
            .getter(getter(TaskListItem::stopTime))
            .setter(setter(Builder::stopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(TaskListItem::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPUS_FIELD,
            CREATION_TIME_FIELD, MEMORY_FIELD, NAME_FIELD, START_TIME_FIELD, STATUS_FIELD, STOP_TIME_FIELD, TASK_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer cpus;

    private final Instant creationTime;

    private final Integer memory;

    private final String name;

    private final Instant startTime;

    private final String status;

    private final Instant stopTime;

    private final String taskId;

    private TaskListItem(BuilderImpl builder) {
        this.cpus = builder.cpus;
        this.creationTime = builder.creationTime;
        this.memory = builder.memory;
        this.name = builder.name;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.stopTime = builder.stopTime;
        this.taskId = builder.taskId;
    }

    /**
     * <p>
     * The task's CPU count.
     * </p>
     * 
     * @return The task's CPU count.
     */
    public final Integer cpus() {
        return cpus;
    }

    /**
     * <p>
     * When the task was created.
     * </p>
     * 
     * @return When the task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The task's memory use in gigabyes.
     * </p>
     * 
     * @return The task's memory use in gigabyes.
     */
    public final Integer memory() {
        return memory;
    }

    /**
     * <p>
     * The task's name.
     * </p>
     * 
     * @return The task's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * When the task started.
     * </p>
     * 
     * @return When the task started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The task's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The task's status.
     * @see TaskStatus
     */
    public final TaskStatus status() {
        return TaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The task's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The task's status.
     * @see TaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the task stopped.
     * </p>
     * 
     * @return When the task stopped.
     */
    public final Instant stopTime() {
        return stopTime;
    }

    /**
     * <p>
     * The task's ID.
     * </p>
     * 
     * @return The task's ID.
     */
    public final String taskId() {
        return taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpus());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskListItem)) {
            return false;
        }
        TaskListItem other = (TaskListItem) obj;
        return Objects.equals(cpus(), other.cpus()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(memory(), other.memory()) && Objects.equals(name(), other.name())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(stopTime(), other.stopTime()) && Objects.equals(taskId(), other.taskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskListItem").add("Cpus", cpus()).add("CreationTime", creationTime()).add("Memory", memory())
                .add("Name", name()).add("StartTime", startTime()).add("Status", statusAsString()).add("StopTime", stopTime())
                .add("TaskId", taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpus":
            return Optional.ofNullable(clazz.cast(cpus()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "stopTime":
            return Optional.ofNullable(clazz.cast(stopTime()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskListItem, T> g) {
        return obj -> g.apply((TaskListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskListItem> {
        /**
         * <p>
         * The task's CPU count.
         * </p>
         * 
         * @param cpus
         *        The task's CPU count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpus(Integer cpus);

        /**
         * <p>
         * When the task was created.
         * </p>
         * 
         * @param creationTime
         *        When the task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The task's memory use in gigabyes.
         * </p>
         * 
         * @param memory
         *        The task's memory use in gigabyes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The task's name.
         * </p>
         * 
         * @param name
         *        The task's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When the task started.
         * </p>
         * 
         * @param startTime
         *        When the task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The task's status.
         * </p>
         * 
         * @param status
         *        The task's status.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The task's status.
         * </p>
         * 
         * @param status
         *        The task's status.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder status(TaskStatus status);

        /**
         * <p>
         * When the task stopped.
         * </p>
         * 
         * @param stopTime
         *        When the task stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTime(Instant stopTime);

        /**
         * <p>
         * The task's ID.
         * </p>
         * 
         * @param taskId
         *        The task's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);
    }

    static final class BuilderImpl implements Builder {
        private Integer cpus;

        private Instant creationTime;

        private Integer memory;

        private String name;

        private Instant startTime;

        private String status;

        private Instant stopTime;

        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskListItem model) {
            cpus(model.cpus);
            creationTime(model.creationTime);
            memory(model.memory);
            name(model.name);
            startTime(model.startTime);
            status(model.status);
            stopTime(model.stopTime);
            taskId(model.taskId);
        }

        public final Integer getCpus() {
            return cpus;
        }

        public final void setCpus(Integer cpus) {
            this.cpus = cpus;
        }

        @Override
        public final Builder cpus(Integer cpus) {
            this.cpus = cpus;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getMemory() {
            return memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStopTime() {
            return stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public TaskListItem build() {
            return new TaskListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
