/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of genome reference files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceFiles implements SdkPojo, Serializable, ToCopyableBuilder<ReferenceFiles.Builder, ReferenceFiles> {
    private static final SdkField<FileInformation> INDEX_FIELD = SdkField.<FileInformation> builder(MarshallingType.SDK_POJO)
            .memberName("index").getter(getter(ReferenceFiles::index)).setter(setter(Builder::index))
            .constructor(FileInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final SdkField<FileInformation> SOURCE_FIELD = SdkField.<FileInformation> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(ReferenceFiles::source)).setter(setter(Builder::source))
            .constructor(FileInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final FileInformation index;

    private final FileInformation source;

    private ReferenceFiles(BuilderImpl builder) {
        this.index = builder.index;
        this.source = builder.source;
    }

    /**
     * <p>
     * The files' index.
     * </p>
     * 
     * @return The files' index.
     */
    public final FileInformation index() {
        return index;
    }

    /**
     * <p>
     * The source file's location in Amazon S3.
     * </p>
     * 
     * @return The source file's location in Amazon S3.
     */
    public final FileInformation source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceFiles)) {
            return false;
        }
        ReferenceFiles other = (ReferenceFiles) obj;
        return Objects.equals(index(), other.index()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceFiles").add("Index", index()).add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceFiles, T> g) {
        return obj -> g.apply((ReferenceFiles) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceFiles> {
        /**
         * <p>
         * The files' index.
         * </p>
         * 
         * @param index
         *        The files' index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(FileInformation index);

        /**
         * <p>
         * The files' index.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileInformation.Builder} avoiding the
         * need to create one manually via {@link FileInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #index(FileInformation)}.
         * 
         * @param index
         *        a consumer that will call methods on {@link FileInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #index(FileInformation)
         */
        default Builder index(Consumer<FileInformation.Builder> index) {
            return index(FileInformation.builder().applyMutation(index).build());
        }

        /**
         * <p>
         * The source file's location in Amazon S3.
         * </p>
         * 
         * @param source
         *        The source file's location in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(FileInformation source);

        /**
         * <p>
         * The source file's location in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileInformation.Builder} avoiding the
         * need to create one manually via {@link FileInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #source(FileInformation)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link FileInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(FileInformation)
         */
        default Builder source(Consumer<FileInformation.Builder> source) {
            return source(FileInformation.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileInformation index;

        private FileInformation source;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceFiles model) {
            index(model.index);
            source(model.source);
        }

        public final FileInformation.Builder getIndex() {
            return index != null ? index.toBuilder() : null;
        }

        public final void setIndex(FileInformation.BuilderImpl index) {
            this.index = index != null ? index.build() : null;
        }

        @Override
        public final Builder index(FileInformation index) {
            this.index = index;
            return this;
        }

        public final FileInformation.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(FileInformation.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(FileInformation source) {
            this.source = source;
            return this;
        }

        @Override
        public ReferenceFiles build() {
            return new ReferenceFiles(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
