/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRunsRequest extends OmicsRequest implements ToCopyableBuilder<ListRunsRequest.Builder, ListRunsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRunsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ListRunsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> RUN_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runGroupId").getter(getter(ListRunsRequest::runGroupId)).setter(setter(Builder::runGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("runGroupId").build()).build();

    private static final SdkField<String> STARTING_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startingToken").getter(getter(ListRunsRequest::startingToken)).setter(setter(Builder::startingToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startingToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NAME_FIELD,
            RUN_GROUP_ID_FIELD, STARTING_TOKEN_FIELD));

    private final Integer maxResults;

    private final String name;

    private final String runGroupId;

    private final String startingToken;

    private ListRunsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.runGroupId = builder.runGroupId;
        this.startingToken = builder.startingToken;
    }

    /**
     * <p>
     * The maximum number of runs to return in one page of results.
     * </p>
     * 
     * @return The maximum number of runs to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter the list by run name.
     * </p>
     * 
     * @return Filter the list by run name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Filter the list by run group ID.
     * </p>
     * 
     * @return Filter the list by run group ID.
     */
    public final String runGroupId() {
        return runGroupId;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String startingToken() {
        return startingToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(runGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(startingToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRunsRequest)) {
            return false;
        }
        ListRunsRequest other = (ListRunsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(name(), other.name())
                && Objects.equals(runGroupId(), other.runGroupId()) && Objects.equals(startingToken(), other.startingToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRunsRequest").add("MaxResults", maxResults()).add("Name", name())
                .add("RunGroupId", runGroupId()).add("StartingToken", startingToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "runGroupId":
            return Optional.ofNullable(clazz.cast(runGroupId()));
        case "startingToken":
            return Optional.ofNullable(clazz.cast(startingToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRunsRequest, T> g) {
        return obj -> g.apply((ListRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRunsRequest> {
        /**
         * <p>
         * The maximum number of runs to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of runs to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter the list by run name.
         * </p>
         * 
         * @param name
         *        Filter the list by run name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Filter the list by run group ID.
         * </p>
         * 
         * @param runGroupId
         *        Filter the list by run group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runGroupId(String runGroupId);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param startingToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingToken(String startingToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String name;

        private String runGroupId;

        private String startingToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRunsRequest model) {
            super(model);
            maxResults(model.maxResults);
            name(model.name);
            runGroupId(model.runGroupId);
            startingToken(model.startingToken);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRunGroupId() {
            return runGroupId;
        }

        public final void setRunGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
        }

        @Override
        public final Builder runGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        public final String getStartingToken() {
            return startingToken;
        }

        public final void setStartingToken(String startingToken) {
            this.startingToken = startingToken;
        }

        @Override
        public final Builder startingToken(String startingToken) {
            this.startingToken = startingToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRunsRequest build() {
            return new ListRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
