/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReferenceStoresRequest extends OmicsRequest implements
        ToCopyableBuilder<ListReferenceStoresRequest.Builder, ListReferenceStoresRequest> {
    private static final SdkField<ReferenceStoreFilter> FILTER_FIELD = SdkField
            .<ReferenceStoreFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListReferenceStoresRequest::filter)).setter(setter(Builder::filter))
            .constructor(ReferenceStoreFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListReferenceStoresRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReferenceStoresRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final ReferenceStoreFilter filter;

    private final Integer maxResults;

    private final String nextToken;

    private ListReferenceStoresRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A filter to apply to the list.
     * </p>
     * 
     * @return A filter to apply to the list.
     */
    public final ReferenceStoreFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The maximum number of stores to return in one page of results.
     * </p>
     * 
     * @return The maximum number of stores to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReferenceStoresRequest)) {
            return false;
        }
        ListReferenceStoresRequest other = (ListReferenceStoresRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReferenceStoresRequest").add("Filter", filter()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReferenceStoresRequest, T> g) {
        return obj -> g.apply((ListReferenceStoresRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListReferenceStoresRequest> {
        /**
         * <p>
         * A filter to apply to the list.
         * </p>
         * 
         * @param filter
         *        A filter to apply to the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ReferenceStoreFilter filter);

        /**
         * <p>
         * A filter to apply to the list.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceStoreFilter.Builder} avoiding
         * the need to create one manually via {@link ReferenceStoreFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceStoreFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(ReferenceStoreFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ReferenceStoreFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ReferenceStoreFilter)
         */
        default Builder filter(Consumer<ReferenceStoreFilter.Builder> filter) {
            return filter(ReferenceStoreFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The maximum number of stores to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of stores to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private ReferenceStoreFilter filter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReferenceStoresRequest model) {
            super(model);
            filter(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final ReferenceStoreFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ReferenceStoreFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ReferenceStoreFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReferenceStoresRequest build() {
            return new ListReferenceStoresRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
