/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowResponse extends OmicsResponse implements
        ToCopyableBuilder<GetWorkflowResponse.Builder, GetWorkflowResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetWorkflowResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetWorkflowResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(GetWorkflowResponse::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetWorkflowResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("digest")
            .getter(getter(GetWorkflowResponse::digest)).setter(setter(Builder::digest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("engine")
            .getter(getter(GetWorkflowResponse::engineAsString)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetWorkflowResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("main")
            .getter(getter(GetWorkflowResponse::main)).setter(setter(Builder::main))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("main").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetWorkflowResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, WorkflowParameter>> PARAMETER_TEMPLATE_FIELD = SdkField
            .<Map<String, WorkflowParameter>> builder(MarshallingType.MAP)
            .memberName("parameterTemplate")
            .getter(getter(GetWorkflowResponse::parameterTemplate))
            .setter(setter(Builder::parameterTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplate").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<WorkflowParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetWorkflowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetWorkflowResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(GetWorkflowResponse::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetWorkflowResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetWorkflowResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD, DIGEST_FIELD, ENGINE_FIELD, ID_FIELD, MAIN_FIELD,
            NAME_FIELD, PARAMETER_TEMPLATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STORAGE_CAPACITY_FIELD, TAGS_FIELD,
            TYPE_FIELD));

    private final String arn;

    private final Instant creationTime;

    private final String definition;

    private final String description;

    private final String digest;

    private final String engine;

    private final String id;

    private final String main;

    private final String name;

    private final Map<String, WorkflowParameter> parameterTemplate;

    private final String status;

    private final String statusMessage;

    private final Integer storageCapacity;

    private final Map<String, String> tags;

    private final String type;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.definition = builder.definition;
        this.description = builder.description;
        this.digest = builder.digest;
        this.engine = builder.engine;
        this.id = builder.id;
        this.main = builder.main;
        this.name = builder.name;
        this.parameterTemplate = builder.parameterTemplate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.storageCapacity = builder.storageCapacity;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The workflow's ARN.
     * </p>
     * 
     * @return The workflow's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When the workflow was created.
     * </p>
     * 
     * @return When the workflow was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The workflow's definition.
     * </p>
     * 
     * @return The workflow's definition.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The workflow's description.
     * </p>
     * 
     * @return The workflow's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The workflow's digest.
     * </p>
     * 
     * @return The workflow's digest.
     */
    public final String digest() {
        return digest;
    }

    /**
     * <p>
     * The workflow's engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link WorkflowEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return The workflow's engine.
     * @see WorkflowEngine
     */
    public final WorkflowEngine engine() {
        return WorkflowEngine.fromValue(engine);
    }

    /**
     * <p>
     * The workflow's engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link WorkflowEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return The workflow's engine.
     * @see WorkflowEngine
     */
    public final String engineAsString() {
        return engine;
    }

    /**
     * <p>
     * The workflow's ID.
     * </p>
     * 
     * @return The workflow's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The path of the main definition file for the workflow.
     * </p>
     * 
     * @return The path of the main definition file for the workflow.
     */
    public final String main() {
        return main;
    }

    /**
     * <p>
     * The workflow's name.
     * </p>
     * 
     * @return The workflow's name.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterTemplate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterTemplate() {
        return parameterTemplate != null && !(parameterTemplate instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The workflow's parameter template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterTemplate} method.
     * </p>
     * 
     * @return The workflow's parameter template.
     */
    public final Map<String, WorkflowParameter> parameterTemplate() {
        return parameterTemplate;
    }

    /**
     * <p>
     * The workflow's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The workflow's status.
     * @see WorkflowStatus
     */
    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(status);
    }

    /**
     * <p>
     * The workflow's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The workflow's status.
     * @see WorkflowStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The workflow's status message.
     * </p>
     * 
     * @return The workflow's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The workflow's storage capacity in gigabytes.
     * </p>
     * 
     * @return The workflow's storage capacity in gigabytes.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The workflow's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The workflow's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The workflow's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The workflow's type.
     * @see WorkflowType
     */
    public final WorkflowType type() {
        return WorkflowType.fromValue(type);
    }

    /**
     * <p>
     * The workflow's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The workflow's type.
     * @see WorkflowType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(digest());
        hashCode = 31 * hashCode + Objects.hashCode(engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(main());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterTemplate() ? parameterTemplate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(definition(), other.definition()) && Objects.equals(description(), other.description())
                && Objects.equals(digest(), other.digest()) && Objects.equals(engineAsString(), other.engineAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(main(), other.main())
                && Objects.equals(name(), other.name()) && hasParameterTemplate() == other.hasParameterTemplate()
                && Objects.equals(parameterTemplate(), other.parameterTemplate())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(storageCapacity(), other.storageCapacity()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("Definition", definition()).add("Description", description()).add("Digest", digest())
                .add("Engine", engineAsString()).add("Id", id()).add("Main", main()).add("Name", name())
                .add("ParameterTemplate", hasParameterTemplate() ? parameterTemplate() : null).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("StorageCapacity", storageCapacity())
                .add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "digest":
            return Optional.ofNullable(clazz.cast(digest()));
        case "engine":
            return Optional.ofNullable(clazz.cast(engineAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "main":
            return Optional.ofNullable(clazz.cast(main()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "parameterTemplate":
            return Optional.ofNullable(clazz.cast(parameterTemplate()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowResponse> {
        /**
         * <p>
         * The workflow's ARN.
         * </p>
         * 
         * @param arn
         *        The workflow's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When the workflow was created.
         * </p>
         * 
         * @param creationTime
         *        When the workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The workflow's definition.
         * </p>
         * 
         * @param definition
         *        The workflow's definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The workflow's description.
         * </p>
         * 
         * @param description
         *        The workflow's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The workflow's digest.
         * </p>
         * 
         * @param digest
         *        The workflow's digest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digest(String digest);

        /**
         * <p>
         * The workflow's engine.
         * </p>
         * 
         * @param engine
         *        The workflow's engine.
         * @see WorkflowEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowEngine
         */
        Builder engine(String engine);

        /**
         * <p>
         * The workflow's engine.
         * </p>
         * 
         * @param engine
         *        The workflow's engine.
         * @see WorkflowEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowEngine
         */
        Builder engine(WorkflowEngine engine);

        /**
         * <p>
         * The workflow's ID.
         * </p>
         * 
         * @param id
         *        The workflow's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The path of the main definition file for the workflow.
         * </p>
         * 
         * @param main
         *        The path of the main definition file for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder main(String main);

        /**
         * <p>
         * The workflow's name.
         * </p>
         * 
         * @param name
         *        The workflow's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The workflow's parameter template.
         * </p>
         * 
         * @param parameterTemplate
         *        The workflow's parameter template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate);

        /**
         * <p>
         * The workflow's status.
         * </p>
         * 
         * @param status
         *        The workflow's status.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The workflow's status.
         * </p>
         * 
         * @param status
         *        The workflow's status.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(WorkflowStatus status);

        /**
         * <p>
         * The workflow's status message.
         * </p>
         * 
         * @param statusMessage
         *        The workflow's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The workflow's storage capacity in gigabytes.
         * </p>
         * 
         * @param storageCapacity
         *        The workflow's storage capacity in gigabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * The workflow's tags.
         * </p>
         * 
         * @param tags
         *        The workflow's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The workflow's type.
         * </p>
         * 
         * @param type
         *        The workflow's type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(String type);

        /**
         * <p>
         * The workflow's type.
         * </p>
         * 
         * @param type
         *        The workflow's type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(WorkflowType type);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String definition;

        private String description;

        private String digest;

        private String engine;

        private String id;

        private String main;

        private String name;

        private Map<String, WorkflowParameter> parameterTemplate = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private String statusMessage;

        private Integer storageCapacity;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            definition(model.definition);
            description(model.description);
            digest(model.digest);
            engine(model.engine);
            id(model.id);
            main(model.main);
            name(model.name);
            parameterTemplate(model.parameterTemplate);
            status(model.status);
            statusMessage(model.statusMessage);
            storageCapacity(model.storageCapacity);
            tags(model.tags);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDigest() {
            return digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(WorkflowEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMain() {
            return main;
        }

        public final void setMain(String main) {
            this.main = main;
        }

        @Override
        public final Builder main(String main) {
            this.main = main;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, WorkflowParameter.Builder> getParameterTemplate() {
            Map<String, WorkflowParameter.Builder> result = WorkflowParameterTemplateCopier.copyToBuilder(this.parameterTemplate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterTemplate(Map<String, WorkflowParameter.BuilderImpl> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copyFromBuilder(parameterTemplate);
        }

        @Override
        public final Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copy(parameterTemplate);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
