/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRunGroupRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateRunGroupRequest.Builder, CreateRunGroupRequest> {
    private static final SdkField<Integer> MAX_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCpus").getter(getter(CreateRunGroupRequest::maxCpus)).setter(setter(Builder::maxCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpus").build()).build();

    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxDuration").getter(getter(CreateRunGroupRequest::maxDuration)).setter(setter(Builder::maxDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDuration").build()).build();

    private static final SdkField<Integer> MAX_RUNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRuns").getter(getter(CreateRunGroupRequest::maxRuns)).setter(setter(Builder::maxRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRuns").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRunGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestId")
            .getter(getter(CreateRunGroupRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRunGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CPUS_FIELD,
            MAX_DURATION_FIELD, MAX_RUNS_FIELD, NAME_FIELD, REQUEST_ID_FIELD, TAGS_FIELD));

    private final Integer maxCpus;

    private final Integer maxDuration;

    private final Integer maxRuns;

    private final String name;

    private final String requestIdValue;

    private final Map<String, String> tags;

    private CreateRunGroupRequest(BuilderImpl builder) {
        super(builder);
        this.maxCpus = builder.maxCpus;
        this.maxDuration = builder.maxDuration;
        this.maxRuns = builder.maxRuns;
        this.name = builder.name;
        this.requestIdValue = builder.requestIdValue;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The maximum number of CPUs to use in the group.
     * </p>
     * 
     * @return The maximum number of CPUs to use in the group.
     */
    public final Integer maxCpus() {
        return maxCpus;
    }

    /**
     * <p>
     * A maximum run time for the group in minutes.
     * </p>
     * 
     * @return A maximum run time for the group in minutes.
     */
    public final Integer maxDuration() {
        return maxDuration;
    }

    /**
     * <p>
     * The maximum number of concurrent runs for the group.
     * </p>
     * 
     * @return The maximum number of concurrent runs for the group.
     */
    public final Integer maxRuns() {
        return maxRuns;
    }

    /**
     * <p>
     * A name for the group.
     * </p>
     * 
     * @return A name for the group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * To ensure that requests don't run multiple times, specify a unique ID for each request.
     * </p>
     * 
     * @return To ensure that requests don't run multiple times, specify a unique ID for each request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxCpus());
        hashCode = 31 * hashCode + Objects.hashCode(maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(maxRuns());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRunGroupRequest)) {
            return false;
        }
        CreateRunGroupRequest other = (CreateRunGroupRequest) obj;
        return Objects.equals(maxCpus(), other.maxCpus()) && Objects.equals(maxDuration(), other.maxDuration())
                && Objects.equals(maxRuns(), other.maxRuns()) && Objects.equals(name(), other.name())
                && Objects.equals(requestId(), other.requestId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRunGroupRequest").add("MaxCpus", maxCpus()).add("MaxDuration", maxDuration())
                .add("MaxRuns", maxRuns()).add("Name", name()).add("RequestId", requestId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxCpus":
            return Optional.ofNullable(clazz.cast(maxCpus()));
        case "maxDuration":
            return Optional.ofNullable(clazz.cast(maxDuration()));
        case "maxRuns":
            return Optional.ofNullable(clazz.cast(maxRuns()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRunGroupRequest, T> g) {
        return obj -> g.apply((CreateRunGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRunGroupRequest> {
        /**
         * <p>
         * The maximum number of CPUs to use in the group.
         * </p>
         * 
         * @param maxCpus
         *        The maximum number of CPUs to use in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCpus(Integer maxCpus);

        /**
         * <p>
         * A maximum run time for the group in minutes.
         * </p>
         * 
         * @param maxDuration
         *        A maximum run time for the group in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Integer maxDuration);

        /**
         * <p>
         * The maximum number of concurrent runs for the group.
         * </p>
         * 
         * @param maxRuns
         *        The maximum number of concurrent runs for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRuns(Integer maxRuns);

        /**
         * <p>
         * A name for the group.
         * </p>
         * 
         * @param name
         *        A name for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * To ensure that requests don't run multiple times, specify a unique ID for each request.
         * </p>
         * 
         * @param requestIdValue
         *        To ensure that requests don't run multiple times, specify a unique ID for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * Tags for the group.
         * </p>
         * 
         * @param tags
         *        Tags for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private Integer maxCpus;

        private Integer maxDuration;

        private Integer maxRuns;

        private String name;

        private String requestIdValue;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRunGroupRequest model) {
            super(model);
            maxCpus(model.maxCpus);
            maxDuration(model.maxDuration);
            maxRuns(model.maxRuns);
            name(model.name);
            requestId(model.requestIdValue);
            tags(model.tags);
        }

        public final Integer getMaxCpus() {
            return maxCpus;
        }

        public final void setMaxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
        }

        @Override
        public final Builder maxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
            return this;
        }

        public final Integer getMaxDuration() {
            return maxDuration;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Integer getMaxRuns() {
            return maxRuns;
        }

        public final void setMaxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
        }

        @Override
        public final Builder maxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRunGroupRequest build() {
            return new CreateRunGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
