/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbortMultipartReadSetUploadRequest extends OmicsRequest implements
        ToCopyableBuilder<AbortMultipartReadSetUploadRequest.Builder, AbortMultipartReadSetUploadRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(AbortMultipartReadSetUploadRequest::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(AbortMultipartReadSetUploadRequest::uploadId))
            .setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD,
            UPLOAD_ID_FIELD));

    private final String sequenceStoreId;

    private final String uploadId;

    private AbortMultipartReadSetUploadRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.uploadId = builder.uploadId;
    }

    /**
     * <p>
     * The sequence store ID for the store involved in the multipart upload.
     * </p>
     * 
     * @return The sequence store ID for the store involved in the multipart upload.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    /**
     * <p>
     * The ID for the multipart upload.
     * </p>
     * 
     * @return The ID for the multipart upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortMultipartReadSetUploadRequest)) {
            return false;
        }
        AbortMultipartReadSetUploadRequest other = (AbortMultipartReadSetUploadRequest) obj;
        return Objects.equals(sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(uploadId(), other.uploadId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbortMultipartReadSetUploadRequest").add("SequenceStoreId", sequenceStoreId())
                .add("UploadId", uploadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AbortMultipartReadSetUploadRequest, T> g) {
        return obj -> g.apply((AbortMultipartReadSetUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AbortMultipartReadSetUploadRequest> {
        /**
         * <p>
         * The sequence store ID for the store involved in the multipart upload.
         * </p>
         * 
         * @param sequenceStoreId
         *        The sequence store ID for the store involved in the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        /**
         * <p>
         * The ID for the multipart upload.
         * </p>
         * 
         * @param uploadId
         *        The ID for the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String sequenceStoreId;

        private String uploadId;

        private BuilderImpl() {
        }

        private BuilderImpl(AbortMultipartReadSetUploadRequest model) {
            super(model);
            sequenceStoreId(model.sequenceStoreId);
            uploadId(model.uploadId);
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AbortMultipartReadSetUploadRequest build() {
            return new AbortMultipartReadSetUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
