/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.oam.DefaultOamBaseClientBuilder;
import software.amazon.awssdk.services.oam.DefaultOamClient;
import software.amazon.awssdk.services.oam.OamClient;
import software.amazon.awssdk.services.oam.OamClientBuilder;
import software.amazon.awssdk.services.oam.OamServiceClientConfiguration;
import software.amazon.awssdk.services.oam.endpoints.OamEndpointProvider;

@SdkInternalApi
final class DefaultOamClientBuilder
extends DefaultOamBaseClientBuilder<OamClientBuilder, OamClient>
implements OamClientBuilder {
    DefaultOamClientBuilder() {
    }

    @Override
    public DefaultOamClientBuilder endpointProvider(OamEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OamClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOamClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        OamServiceClientConfiguration serviceClientConfiguration = OamServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultOamClient(serviceClientConfiguration, clientConfiguration);
    }
}

