/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A required parameter is missing from the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MissingRequiredParameterException extends OamException implements
        ToCopyableBuilder<MissingRequiredParameterException.Builder, MissingRequiredParameterException> {
    private static final SdkField<String> AMZN_ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amznErrorType").getter(getter(MissingRequiredParameterException::amznErrorType))
            .setter(setter(Builder::amznErrorType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-ErrorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_ERROR_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amznErrorType;

    private MissingRequiredParameterException(BuilderImpl builder) {
        super(builder);
        this.amznErrorType = builder.amznErrorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The name of the exception.
     * </p>
     * 
     * @return The name of the exception.
     */
    public String amznErrorType() {
        return amznErrorType;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MissingRequiredParameterException, T> g) {
        return obj -> g.apply((MissingRequiredParameterException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MissingRequiredParameterException>, OamException.Builder {
        /**
         * <p>
         * The name of the exception.
         * </p>
         * 
         * @param amznErrorType
         *        The name of the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznErrorType(String amznErrorType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends OamException.BuilderImpl implements Builder {
        private String amznErrorType;

        private BuilderImpl() {
        }

        private BuilderImpl(MissingRequiredParameterException model) {
            super(model);
            amznErrorType(model.amznErrorType);
        }

        public final String getAmznErrorType() {
            return amznErrorType;
        }

        public final void setAmznErrorType(String amznErrorType) {
            this.amznErrorType = amznErrorType;
        }

        @Override
        public final Builder amznErrorType(String amznErrorType) {
            this.amznErrorType = amznErrorType;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public MissingRequiredParameterException build() {
            return new MissingRequiredParameterException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
