/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStudioRequest extends NimbleRequest implements
        ToCopyableBuilder<CreateStudioRequest.Builder, CreateStudioRequest> {
    private static final SdkField<String> ADMIN_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminRoleArn").getter(getter(CreateStudioRequest::adminRoleArn)).setter(setter(Builder::adminRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminRoleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateStudioRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateStudioRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<StudioEncryptionConfiguration> STUDIO_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<StudioEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("studioEncryptionConfiguration")
            .getter(getter(CreateStudioRequest::studioEncryptionConfiguration))
            .setter(setter(Builder::studioEncryptionConfiguration))
            .constructor(StudioEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<String> STUDIO_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioName").getter(getter(CreateStudioRequest::studioName)).setter(setter(Builder::studioName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateStudioRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> USER_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userRoleArn").getter(getter(CreateStudioRequest::userRoleArn)).setter(setter(Builder::userRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ROLE_ARN_FIELD,
            CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, STUDIO_ENCRYPTION_CONFIGURATION_FIELD, STUDIO_NAME_FIELD, TAGS_FIELD,
            USER_ROLE_ARN_FIELD));

    private final String adminRoleArn;

    private final String clientToken;

    private final String displayName;

    private final StudioEncryptionConfiguration studioEncryptionConfiguration;

    private final String studioName;

    private final Map<String, String> tags;

    private final String userRoleArn;

    private CreateStudioRequest(BuilderImpl builder) {
        super(builder);
        this.adminRoleArn = builder.adminRoleArn;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.studioEncryptionConfiguration = builder.studioEncryptionConfiguration;
        this.studioName = builder.studioName;
        this.tags = builder.tags;
        this.userRoleArn = builder.userRoleArn;
    }

    /**
     * <p>
     * The IAM role that studio admins will assume when logging in to the Nimble Studio portal.
     * </p>
     * 
     * @return The IAM role that studio admins will assume when logging in to the Nimble Studio portal.
     */
    public final String adminRoleArn() {
        return adminRoleArn;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to
     * ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *         specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it
     *         for the request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A friendly name for the studio.
     * </p>
     * 
     * @return A friendly name for the studio.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The studio encryption configuration.
     * </p>
     * 
     * @return The studio encryption configuration.
     */
    public final StudioEncryptionConfiguration studioEncryptionConfiguration() {
        return studioEncryptionConfiguration;
    }

    /**
     * <p>
     * The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.
     * </p>
     * 
     * @return The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.
     */
    public final String studioName() {
        return studioName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of labels, in the form of key-value pairs, that apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of labels, in the form of key-value pairs, that apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The IAM role that studio users will assume when logging in to the Nimble Studio portal.
     * </p>
     * 
     * @return The IAM role that studio users will assume when logging in to the Nimble Studio portal.
     */
    public final String userRoleArn() {
        return userRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(studioEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(studioName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioRequest)) {
            return false;
        }
        CreateStudioRequest other = (CreateStudioRequest) obj;
        return Objects.equals(adminRoleArn(), other.adminRoleArn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(studioEncryptionConfiguration(), other.studioEncryptionConfiguration())
                && Objects.equals(studioName(), other.studioName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(userRoleArn(), other.userRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStudioRequest").add("AdminRoleArn", adminRoleArn()).add("ClientToken", clientToken())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StudioEncryptionConfiguration", studioEncryptionConfiguration()).add("StudioName", studioName())
                .add("Tags", hasTags() ? tags() : null).add("UserRoleArn", userRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminRoleArn":
            return Optional.ofNullable(clazz.cast(adminRoleArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "studioEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(studioEncryptionConfiguration()));
        case "studioName":
            return Optional.ofNullable(clazz.cast(studioName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "userRoleArn":
            return Optional.ofNullable(clazz.cast(userRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStudioRequest, T> g) {
        return obj -> g.apply((CreateStudioRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStudioRequest> {
        /**
         * <p>
         * The IAM role that studio admins will assume when logging in to the Nimble Studio portal.
         * </p>
         * 
         * @param adminRoleArn
         *        The IAM role that studio admins will assume when logging in to the Nimble Studio portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminRoleArn(String adminRoleArn);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
         * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for
         * the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and
         *        uses it for the request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A friendly name for the studio.
         * </p>
         * 
         * @param displayName
         *        A friendly name for the studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The studio encryption configuration.
         * </p>
         * 
         * @param studioEncryptionConfiguration
         *        The studio encryption configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioEncryptionConfiguration(StudioEncryptionConfiguration studioEncryptionConfiguration);

        /**
         * <p>
         * The studio encryption configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link StudioEncryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link StudioEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StudioEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #studioEncryptionConfiguration(StudioEncryptionConfiguration)}.
         * 
         * @param studioEncryptionConfiguration
         *        a consumer that will call methods on {@link StudioEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #studioEncryptionConfiguration(StudioEncryptionConfiguration)
         */
        default Builder studioEncryptionConfiguration(
                Consumer<StudioEncryptionConfiguration.Builder> studioEncryptionConfiguration) {
            return studioEncryptionConfiguration(StudioEncryptionConfiguration.builder()
                    .applyMutation(studioEncryptionConfiguration).build());
        }

        /**
         * <p>
         * The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.
         * </p>
         * 
         * @param studioName
         *        The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioName(String studioName);

        /**
         * <p>
         * A collection of labels, in the form of key-value pairs, that apply to this resource.
         * </p>
         * 
         * @param tags
         *        A collection of labels, in the form of key-value pairs, that apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The IAM role that studio users will assume when logging in to the Nimble Studio portal.
         * </p>
         * 
         * @param userRoleArn
         *        The IAM role that studio users will assume when logging in to the Nimble Studio portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRoleArn(String userRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String adminRoleArn;

        private String clientToken;

        private String displayName;

        private StudioEncryptionConfiguration studioEncryptionConfiguration;

        private String studioName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String userRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStudioRequest model) {
            super(model);
            adminRoleArn(model.adminRoleArn);
            clientToken(model.clientToken);
            displayName(model.displayName);
            studioEncryptionConfiguration(model.studioEncryptionConfiguration);
            studioName(model.studioName);
            tags(model.tags);
            userRoleArn(model.userRoleArn);
        }

        public final String getAdminRoleArn() {
            return adminRoleArn;
        }

        public final void setAdminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
        }

        @Override
        public final Builder adminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final StudioEncryptionConfiguration.Builder getStudioEncryptionConfiguration() {
            return studioEncryptionConfiguration != null ? studioEncryptionConfiguration.toBuilder() : null;
        }

        public final void setStudioEncryptionConfiguration(StudioEncryptionConfiguration.BuilderImpl studioEncryptionConfiguration) {
            this.studioEncryptionConfiguration = studioEncryptionConfiguration != null ? studioEncryptionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder studioEncryptionConfiguration(StudioEncryptionConfiguration studioEncryptionConfiguration) {
            this.studioEncryptionConfiguration = studioEncryptionConfiguration;
            return this;
        }

        public final String getStudioName() {
            return studioName;
        }

        public final void setStudioName(String studioName) {
            this.studioName = studioName;
        }

        @Override
        public final Builder studioName(String studioName) {
            this.studioName = studioName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getUserRoleArn() {
            return userRoleArn;
        }

        public final void setUserRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
        }

        @Override
        public final Builder userRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStudioRequest build() {
            return new CreateStudioRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
