/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchProfileStatusCode {
    LAUNCH_PROFILE_CREATED("LAUNCH_PROFILE_CREATED"),
    LAUNCH_PROFILE_UPDATED("LAUNCH_PROFILE_UPDATED"),
    LAUNCH_PROFILE_DELETED("LAUNCH_PROFILE_DELETED"),
    LAUNCH_PROFILE_CREATE_IN_PROGRESS("LAUNCH_PROFILE_CREATE_IN_PROGRESS"),
    LAUNCH_PROFILE_UPDATE_IN_PROGRESS("LAUNCH_PROFILE_UPDATE_IN_PROGRESS"),
    LAUNCH_PROFILE_DELETE_IN_PROGRESS("LAUNCH_PROFILE_DELETE_IN_PROGRESS"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    STREAMING_IMAGE_NOT_FOUND("STREAMING_IMAGE_NOT_FOUND"),
    STREAMING_IMAGE_NOT_READY("STREAMING_IMAGE_NOT_READY"),
    LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED("LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED"),
    ENCRYPTION_KEY_ACCESS_DENIED("ENCRYPTION_KEY_ACCESS_DENIED"),
    ENCRYPTION_KEY_NOT_FOUND("ENCRYPTION_KEY_NOT_FOUND"),
    INVALID_SUBNETS_PROVIDED("INVALID_SUBNETS_PROVIDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchProfileStatusCode> VALUE_MAP;
    private final String value;

    private LaunchProfileStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchProfileStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchProfileStatusCode> knownValues() {
        EnumSet<LaunchProfileStatusCode> knownValues = EnumSet.allOf(LaunchProfileStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchProfileStatusCode.class, LaunchProfileStatusCode::toString);
    }
}

