/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchProfileInitializationScript
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchProfileInitializationScript> {
    private static final SdkField<String> SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("script").getter(LaunchProfileInitializationScript.getter(LaunchProfileInitializationScript::script)).setter(LaunchProfileInitializationScript.setter(Builder::script)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()}).build();
    private static final SdkField<String> STUDIO_COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioComponentId").getter(LaunchProfileInitializationScript.getter(LaunchProfileInitializationScript::studioComponentId)).setter(LaunchProfileInitializationScript.setter(Builder::studioComponentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentId").build()}).build();
    private static final SdkField<String> STUDIO_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioComponentName").getter(LaunchProfileInitializationScript.getter(LaunchProfileInitializationScript::studioComponentName)).setter(LaunchProfileInitializationScript.setter(Builder::studioComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_FIELD, STUDIO_COMPONENT_ID_FIELD, STUDIO_COMPONENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String script;
    private final String studioComponentId;
    private final String studioComponentName;

    private LaunchProfileInitializationScript(BuilderImpl builder) {
        this.script = builder.script;
        this.studioComponentId = builder.studioComponentId;
        this.studioComponentName = builder.studioComponentName;
    }

    public final String script() {
        return this.script;
    }

    public final String studioComponentId() {
        return this.studioComponentId;
    }

    public final String studioComponentName() {
        return this.studioComponentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.script());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioComponentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchProfileInitializationScript)) {
            return false;
        }
        LaunchProfileInitializationScript other = (LaunchProfileInitializationScript)obj;
        return Objects.equals(this.script(), other.script()) && Objects.equals(this.studioComponentId(), other.studioComponentId()) && Objects.equals(this.studioComponentName(), other.studioComponentName());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchProfileInitializationScript").add("Script", (Object)(this.script() == null ? null : "*** Sensitive Data Redacted ***")).add("StudioComponentId", (Object)this.studioComponentId()).add("StudioComponentName", (Object)(this.studioComponentName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "script": {
                return Optional.ofNullable(clazz.cast(this.script()));
            }
            case "studioComponentId": {
                return Optional.ofNullable(clazz.cast(this.studioComponentId()));
            }
            case "studioComponentName": {
                return Optional.ofNullable(clazz.cast(this.studioComponentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchProfileInitializationScript, T> g) {
        return obj -> g.apply((LaunchProfileInitializationScript)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String script;
        private String studioComponentId;
        private String studioComponentName;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchProfileInitializationScript model) {
            this.script(model.script);
            this.studioComponentId(model.studioComponentId);
            this.studioComponentName(model.studioComponentName);
        }

        public final String getScript() {
            return this.script;
        }

        public final void setScript(String script) {
            this.script = script;
        }

        @Override
        public final Builder script(String script) {
            this.script = script;
            return this;
        }

        public final String getStudioComponentId() {
            return this.studioComponentId;
        }

        public final void setStudioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
        }

        @Override
        public final Builder studioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
            return this;
        }

        public final String getStudioComponentName() {
            return this.studioComponentName;
        }

        public final void setStudioComponentName(String studioComponentName) {
            this.studioComponentName = studioComponentName;
        }

        @Override
        public final Builder studioComponentName(String studioComponentName) {
            this.studioComponentName = studioComponentName;
            return this;
        }

        public LaunchProfileInitializationScript build() {
            return new LaunchProfileInitializationScript(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchProfileInitializationScript> {
        public Builder script(String var1);

        public Builder studioComponentId(String var1);

        public Builder studioComponentName(String var1);
    }
}

