/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmonitor.model.Protocol;
import software.amazon.awssdk.services.networkmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProbeInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProbeInput> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceArn").getter(ProbeInput.getter(ProbeInput::sourceArn)).setter(ProbeInput.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(ProbeInput.getter(ProbeInput::destination)).setter(ProbeInput.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("destinationPort").getter(ProbeInput.getter(ProbeInput::destinationPort)).setter(ProbeInput.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(ProbeInput.getter(ProbeInput::protocolAsString)).setter(ProbeInput.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Integer> PACKET_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("packetSize").getter(ProbeInput.getter(ProbeInput::packetSize)).setter(ProbeInput.setter(Builder::packetSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetSize").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ProbeInput.getter(ProbeInput::tags)).setter(ProbeInput.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, DESTINATION_FIELD, DESTINATION_PORT_FIELD, PROTOCOL_FIELD, PACKET_SIZE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceArn;
    private final String destination;
    private final Integer destinationPort;
    private final String protocol;
    private final Integer packetSize;
    private final Map<String, String> tags;

    private ProbeInput(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.destination = builder.destination;
        this.destinationPort = builder.destinationPort;
        this.protocol = builder.protocol;
        this.packetSize = builder.packetSize;
        this.tags = builder.tags;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String destination() {
        return this.destination;
    }

    public final Integer destinationPort() {
        return this.destinationPort;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer packetSize() {
        return this.packetSize;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProbeInput)) {
            return false;
        }
        ProbeInput other = (ProbeInput)obj;
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationPort(), other.destinationPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.packetSize(), other.packetSize()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ProbeInput").add("SourceArn", (Object)this.sourceArn()).add("Destination", (Object)this.destination()).add("DestinationPort", (Object)this.destinationPort()).add("Protocol", (Object)this.protocolAsString()).add("PacketSize", (Object)this.packetSize()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "destinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "packetSize": {
                return Optional.ofNullable(clazz.cast(this.packetSize()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProbeInput, T> g) {
        return obj -> g.apply((ProbeInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceArn;
        private String destination;
        private Integer destinationPort;
        private String protocol;
        private Integer packetSize;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProbeInput model) {
            this.sourceArn(model.sourceArn);
            this.destination(model.destination);
            this.destinationPort(model.destinationPort);
            this.protocol(model.protocol);
            this.packetSize(model.packetSize);
            this.tags(model.tags);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPacketSize() {
            return this.packetSize;
        }

        public final void setPacketSize(Integer packetSize) {
            this.packetSize = packetSize;
        }

        @Override
        public final Builder packetSize(Integer packetSize) {
            this.packetSize = packetSize;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public ProbeInput build() {
            return new ProbeInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProbeInput> {
        public Builder sourceArn(String var1);

        public Builder destination(String var1);

        public Builder destinationPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder packetSize(Integer var1);

        public Builder tags(Map<String, String> var1);
    }
}

