/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<CreateConnectionRequest.Builder, CreateConnectionRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(CreateConnectionRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(CreateConnectionRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> CONNECTED_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectedDeviceId").getter(getter(CreateConnectionRequest::connectedDeviceId))
            .setter(setter(Builder::connectedDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDeviceId").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LinkId")
            .getter(getter(CreateConnectionRequest::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()).build();

    private static final SdkField<String> CONNECTED_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectedLinkId").getter(getter(CreateConnectionRequest::connectedLinkId))
            .setter(setter(Builder::connectedLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedLinkId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateConnectionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateConnectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            DEVICE_ID_FIELD, CONNECTED_DEVICE_ID_FIELD, LINK_ID_FIELD, CONNECTED_LINK_ID_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private final String globalNetworkId;

    private final String deviceId;

    private final String connectedDeviceId;

    private final String linkId;

    private final String connectedLinkId;

    private final String description;

    private final List<Tag> tags;

    private CreateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.connectedDeviceId = builder.connectedDeviceId;
        this.linkId = builder.linkId;
        this.connectedLinkId = builder.connectedLinkId;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of the first device in the connection.
     * </p>
     * 
     * @return The ID of the first device in the connection.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The ID of the second device in the connection.
     * </p>
     * 
     * @return The ID of the second device in the connection.
     */
    public final String connectedDeviceId() {
        return connectedDeviceId;
    }

    /**
     * <p>
     * The ID of the link for the first device.
     * </p>
     * 
     * @return The ID of the link for the first device.
     */
    public final String linkId() {
        return linkId;
    }

    /**
     * <p>
     * The ID of the link for the second device.
     * </p>
     * 
     * @return The ID of the link for the second device.
     */
    public final String connectedLinkId() {
        return connectedLinkId;
    }

    /**
     * <p>
     * A description of the connection.
     * </p>
     * <p>
     * Length Constraints: Maximum length of 256 characters.
     * </p>
     * 
     * @return A description of the connection.</p>
     *         <p>
     *         Length Constraints: Maximum length of 256 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the resource during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the resource during creation.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        hashCode = 31 * hashCode + Objects.hashCode(connectedLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(connectedDeviceId(), other.connectedDeviceId()) && Objects.equals(linkId(), other.linkId())
                && Objects.equals(connectedLinkId(), other.connectedLinkId())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectionRequest").add("GlobalNetworkId", globalNetworkId()).add("DeviceId", deviceId())
                .add("ConnectedDeviceId", connectedDeviceId()).add("LinkId", linkId()).add("ConnectedLinkId", connectedLinkId())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "ConnectedDeviceId":
            return Optional.ofNullable(clazz.cast(connectedDeviceId()));
        case "LinkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        case "ConnectedLinkId":
            return Optional.ofNullable(clazz.cast(connectedLinkId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionRequest, T> g) {
        return obj -> g.apply((CreateConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectionRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of the first device in the connection.
         * </p>
         * 
         * @param deviceId
         *        The ID of the first device in the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The ID of the second device in the connection.
         * </p>
         * 
         * @param connectedDeviceId
         *        The ID of the second device in the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedDeviceId(String connectedDeviceId);

        /**
         * <p>
         * The ID of the link for the first device.
         * </p>
         * 
         * @param linkId
         *        The ID of the link for the first device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        /**
         * <p>
         * The ID of the link for the second device.
         * </p>
         * 
         * @param connectedLinkId
         *        The ID of the link for the second device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedLinkId(String connectedLinkId);

        /**
         * <p>
         * A description of the connection.
         * </p>
         * <p>
         * Length Constraints: Maximum length of 256 characters.
         * </p>
         * 
         * @param description
         *        A description of the connection.</p>
         *        <p>
         *        Length Constraints: Maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags to apply to the resource during creation.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the resource during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to apply to the resource during creation.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the resource during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to apply to the resource during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private String deviceId;

        private String connectedDeviceId;

        private String linkId;

        private String connectedLinkId;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            deviceId(model.deviceId);
            connectedDeviceId(model.connectedDeviceId);
            linkId(model.linkId);
            connectedLinkId(model.connectedLinkId);
            description(model.description);
            tags(model.tags);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getConnectedDeviceId() {
            return connectedDeviceId;
        }

        public final void setConnectedDeviceId(String connectedDeviceId) {
            this.connectedDeviceId = connectedDeviceId;
        }

        @Override
        public final Builder connectedDeviceId(String connectedDeviceId) {
            this.connectedDeviceId = connectedDeviceId;
            return this;
        }

        public final String getLinkId() {
            return linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getConnectedLinkId() {
            return connectedLinkId;
        }

        public final void setConnectedLinkId(String connectedLinkId) {
            this.connectedLinkId = connectedLinkId;
        }

        @Override
        public final Builder connectedLinkId(String connectedLinkId) {
            this.connectedLinkId = connectedLinkId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
