/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of an analysis at completion.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteAnalysisCompletion implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteAnalysisCompletion.Builder, RouteAnalysisCompletion> {
    private static final SdkField<String> RESULT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultCode").getter(getter(RouteAnalysisCompletion::resultCodeAsString))
            .setter(setter(Builder::resultCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultCode").build()).build();

    private static final SdkField<String> REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReasonCode").getter(getter(RouteAnalysisCompletion::reasonCodeAsString))
            .setter(setter(Builder::reasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()).build();

    private static final SdkField<Map<String, String>> REASON_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ReasonContext")
            .getter(getter(RouteAnalysisCompletion::reasonContext))
            .setter(setter(Builder::reasonContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_CODE_FIELD,
            REASON_CODE_FIELD, REASON_CONTEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resultCode;

    private final String reasonCode;

    private final Map<String, String> reasonContext;

    private RouteAnalysisCompletion(BuilderImpl builder) {
        this.resultCode = builder.resultCode;
        this.reasonCode = builder.reasonCode;
        this.reasonContext = builder.reasonContext;
    }

    /**
     * <p>
     * The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultCode} will
     * return {@link RouteAnalysisCompletionResultCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultCodeAsString}.
     * </p>
     * 
     * @return The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.
     * @see RouteAnalysisCompletionResultCode
     */
    public final RouteAnalysisCompletionResultCode resultCode() {
        return RouteAnalysisCompletionResultCode.fromValue(resultCode);
    }

    /**
     * <p>
     * The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultCode} will
     * return {@link RouteAnalysisCompletionResultCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultCodeAsString}.
     * </p>
     * 
     * @return The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.
     * @see RouteAnalysisCompletionResultCode
     */
    public final String resultCodeAsString() {
        return resultCode;
    }

    /**
     * <p>
     * The reason code. Available only if a connection is not found.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not
     * associated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reasonCode} will
     * return {@link RouteAnalysisCompletionReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonCodeAsString}.
     * </p>
     * 
     * @return The reason code. Available only if a connection is not found.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR
     *         block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR
     *         block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not
     *         associated.
     *         </p>
     *         </li>
     * @see RouteAnalysisCompletionReasonCode
     */
    public final RouteAnalysisCompletionReasonCode reasonCode() {
        return RouteAnalysisCompletionReasonCode.fromValue(reasonCode);
    }

    /**
     * <p>
     * The reason code. Available only if a connection is not found.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not
     * associated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reasonCode} will
     * return {@link RouteAnalysisCompletionReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonCodeAsString}.
     * </p>
     * 
     * @return The reason code. Available only if a connection is not found.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR
     *         block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR
     *         block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not
     *         associated.
     *         </p>
     *         </li>
     * @see RouteAnalysisCompletionReasonCode
     */
    public final String reasonCodeAsString() {
        return reasonCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReasonContext property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReasonContext() {
        return reasonContext != null && !(reasonContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional information about the path. Available only if a connection is not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasonContext} method.
     * </p>
     * 
     * @return Additional information about the path. Available only if a connection is not found.
     */
    public final Map<String, String> reasonContext() {
        return reasonContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReasonContext() ? reasonContext() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysisCompletion)) {
            return false;
        }
        RouteAnalysisCompletion other = (RouteAnalysisCompletion) obj;
        return Objects.equals(resultCodeAsString(), other.resultCodeAsString())
                && Objects.equals(reasonCodeAsString(), other.reasonCodeAsString())
                && hasReasonContext() == other.hasReasonContext() && Objects.equals(reasonContext(), other.reasonContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteAnalysisCompletion").add("ResultCode", resultCodeAsString())
                .add("ReasonCode", reasonCodeAsString()).add("ReasonContext", hasReasonContext() ? reasonContext() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultCode":
            return Optional.ofNullable(clazz.cast(resultCodeAsString()));
        case "ReasonCode":
            return Optional.ofNullable(clazz.cast(reasonCodeAsString()));
        case "ReasonContext":
            return Optional.ofNullable(clazz.cast(reasonContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteAnalysisCompletion, T> g) {
        return obj -> g.apply((RouteAnalysisCompletion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteAnalysisCompletion> {
        /**
         * <p>
         * The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.
         * </p>
         * 
         * @param resultCode
         *        The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.
         * @see RouteAnalysisCompletionResultCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteAnalysisCompletionResultCode
         */
        Builder resultCode(String resultCode);

        /**
         * <p>
         * The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.
         * </p>
         * 
         * @param resultCode
         *        The result of the analysis. If the status is <code>NOT_CONNECTED</code>, check the reason code.
         * @see RouteAnalysisCompletionResultCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteAnalysisCompletionResultCode
         */
        Builder resultCode(RouteAnalysisCompletionResultCode resultCode);

        /**
         * <p>
         * The reason code. Available only if a connection is not found.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR
         * block.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not
         * associated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCode
         *        The reason code. Available only if a connection is not found.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination
         *        CIDR block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR
         *        block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not
         *        associated.
         *        </p>
         *        </li>
         * @see RouteAnalysisCompletionReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteAnalysisCompletionReasonCode
         */
        Builder reasonCode(String reasonCode);

        /**
         * <p>
         * The reason code. Available only if a connection is not found.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination CIDR
         * block.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR block.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not
         * associated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCode
         *        The reason code. Available only if a connection is not found.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLACKHOLE_ROUTE_FOR_DESTINATION_FOUND</code> - Found a black hole route with the destination
         *        CIDR block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CYCLIC_PATH_DETECTED</code> - Found the same resource multiple times while traversing the path.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE_ROUTE_FOR_DESTINATION_FOUND</code> - Found an inactive route with the destination CIDR
         *        block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MAX_HOPS_EXCEEDED</code> - Analysis exceeded 64 hops without finding the destination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROUTE_NOT_FOUND</code> - Cannot find a route table with the destination CIDR block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TGW_ATTACH_ARN_NO_MATCH</code> - Found an attachment, but not with the correct destination ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TGW_ATTACH_NOT_FOUND</code> - Cannot find an attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TGW_ATTACH_NOT_IN_TGW</code> - Found an attachment, but not to the correct transit gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TGW_ATTACH_STABLE_ROUTE_TABLE_NOT_FOUND</code> - The state of the route table association is not
         *        associated.
         *        </p>
         *        </li>
         * @see RouteAnalysisCompletionReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteAnalysisCompletionReasonCode
         */
        Builder reasonCode(RouteAnalysisCompletionReasonCode reasonCode);

        /**
         * <p>
         * Additional information about the path. Available only if a connection is not found.
         * </p>
         * 
         * @param reasonContext
         *        Additional information about the path. Available only if a connection is not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonContext(Map<String, String> reasonContext);
    }

    static final class BuilderImpl implements Builder {
        private String resultCode;

        private String reasonCode;

        private Map<String, String> reasonContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAnalysisCompletion model) {
            resultCode(model.resultCode);
            reasonCode(model.reasonCode);
            reasonContext(model.reasonContext);
        }

        public final String getResultCode() {
            return resultCode;
        }

        public final void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        @Override
        public final Builder resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        @Override
        public final Builder resultCode(RouteAnalysisCompletionResultCode resultCode) {
            this.resultCode(resultCode == null ? null : resultCode.toString());
            return this;
        }

        public final String getReasonCode() {
            return reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        @Override
        public final Builder reasonCode(RouteAnalysisCompletionReasonCode reasonCode) {
            this.reasonCode(reasonCode == null ? null : reasonCode.toString());
            return this;
        }

        public final Map<String, String> getReasonContext() {
            if (reasonContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return reasonContext;
        }

        public final void setReasonContext(Map<String, String> reasonContext) {
            this.reasonContext = ReasonContextMapCopier.copy(reasonContext);
        }

        @Override
        public final Builder reasonContext(Map<String, String> reasonContext) {
            this.reasonContext = ReasonContextMapCopier.copy(reasonContext);
            return this;
        }

        @Override
        public RouteAnalysisCompletion build() {
            return new RouteAnalysisCompletion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
