/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network policy version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkPolicyVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkPolicyVersion.Builder, CoreNetworkPolicyVersion> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(CoreNetworkPolicyVersion::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<Integer> POLICY_VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PolicyVersionId").getter(getter(CoreNetworkPolicyVersion::policyVersionId))
            .setter(setter(Builder::policyVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersionId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(CoreNetworkPolicyVersion::aliasAsString)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CoreNetworkPolicyVersion::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(CoreNetworkPolicyVersion::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> CHANGE_SET_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetState").getter(getter(CoreNetworkPolicyVersion::changeSetStateAsString))
            .setter(setter(Builder::changeSetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            POLICY_VERSION_ID_FIELD, ALIAS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, CHANGE_SET_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String coreNetworkId;

    private final Integer policyVersionId;

    private final String alias;

    private final String description;

    private final Instant createdAt;

    private final String changeSetState;

    private CoreNetworkPolicyVersion(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.policyVersionId = builder.policyVersionId;
        this.alias = builder.alias;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.changeSetState = builder.changeSetState;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ID of the policy version.
     * </p>
     * 
     * @return The ID of the policy version.
     */
    public final Integer policyVersionId() {
        return policyVersionId;
    }

    /**
     * <p>
     * Whether a core network policy is the current policy or the most recently submitted policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alias} will return
     * {@link CoreNetworkPolicyAlias#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aliasAsString}.
     * </p>
     * 
     * @return Whether a core network policy is the current policy or the most recently submitted policy.
     * @see CoreNetworkPolicyAlias
     */
    public final CoreNetworkPolicyAlias alias() {
        return CoreNetworkPolicyAlias.fromValue(alias);
    }

    /**
     * <p>
     * Whether a core network policy is the current policy or the most recently submitted policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alias} will return
     * {@link CoreNetworkPolicyAlias#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aliasAsString}.
     * </p>
     * 
     * @return Whether a core network policy is the current policy or the most recently submitted policy.
     * @see CoreNetworkPolicyAlias
     */
    public final String aliasAsString() {
        return alias;
    }

    /**
     * <p>
     * The description of a core network policy version.
     * </p>
     * 
     * @return The description of a core network policy version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when a core network policy version was created.
     * </p>
     * 
     * @return The timestamp when a core network policy version was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the policy version change set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeSetState}
     * will return {@link ChangeSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #changeSetStateAsString}.
     * </p>
     * 
     * @return The status of the policy version change set.
     * @see ChangeSetState
     */
    public final ChangeSetState changeSetState() {
        return ChangeSetState.fromValue(changeSetState);
    }

    /**
     * <p>
     * The status of the policy version change set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeSetState}
     * will return {@link ChangeSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #changeSetStateAsString}.
     * </p>
     * 
     * @return The status of the policy version change set.
     * @see ChangeSetState
     */
    public final String changeSetStateAsString() {
        return changeSetState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkPolicyVersion)) {
            return false;
        }
        CoreNetworkPolicyVersion other = (CoreNetworkPolicyVersion) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(policyVersionId(), other.policyVersionId())
                && Objects.equals(aliasAsString(), other.aliasAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(changeSetStateAsString(), other.changeSetStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkPolicyVersion").add("CoreNetworkId", coreNetworkId())
                .add("PolicyVersionId", policyVersionId()).add("Alias", aliasAsString()).add("Description", description())
                .add("CreatedAt", createdAt()).add("ChangeSetState", changeSetStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "PolicyVersionId":
            return Optional.ofNullable(clazz.cast(policyVersionId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(aliasAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ChangeSetState":
            return Optional.ofNullable(clazz.cast(changeSetStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkPolicyVersion, T> g) {
        return obj -> g.apply((CoreNetworkPolicyVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkPolicyVersion> {
        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ID of the policy version.
         * </p>
         * 
         * @param policyVersionId
         *        The ID of the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionId(Integer policyVersionId);

        /**
         * <p>
         * Whether a core network policy is the current policy or the most recently submitted policy.
         * </p>
         * 
         * @param alias
         *        Whether a core network policy is the current policy or the most recently submitted policy.
         * @see CoreNetworkPolicyAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreNetworkPolicyAlias
         */
        Builder alias(String alias);

        /**
         * <p>
         * Whether a core network policy is the current policy or the most recently submitted policy.
         * </p>
         * 
         * @param alias
         *        Whether a core network policy is the current policy or the most recently submitted policy.
         * @see CoreNetworkPolicyAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreNetworkPolicyAlias
         */
        Builder alias(CoreNetworkPolicyAlias alias);

        /**
         * <p>
         * The description of a core network policy version.
         * </p>
         * 
         * @param description
         *        The description of a core network policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when a core network policy version was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when a core network policy version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the policy version change set.
         * </p>
         * 
         * @param changeSetState
         *        The status of the policy version change set.
         * @see ChangeSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetState
         */
        Builder changeSetState(String changeSetState);

        /**
         * <p>
         * The status of the policy version change set.
         * </p>
         * 
         * @param changeSetState
         *        The status of the policy version change set.
         * @see ChangeSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetState
         */
        Builder changeSetState(ChangeSetState changeSetState);
    }

    static final class BuilderImpl implements Builder {
        private String coreNetworkId;

        private Integer policyVersionId;

        private String alias;

        private String description;

        private Instant createdAt;

        private String changeSetState;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkPolicyVersion model) {
            coreNetworkId(model.coreNetworkId);
            policyVersionId(model.policyVersionId);
            alias(model.alias);
            description(model.description);
            createdAt(model.createdAt);
            changeSetState(model.changeSetState);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final Integer getPolicyVersionId() {
            return policyVersionId;
        }

        public final void setPolicyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public final Builder policyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public final Builder alias(CoreNetworkPolicyAlias alias) {
            this.alias(alias == null ? null : alias.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getChangeSetState() {
            return changeSetState;
        }

        public final void setChangeSetState(String changeSetState) {
            this.changeSetState = changeSetState;
        }

        @Override
        public final Builder changeSetState(String changeSetState) {
            this.changeSetState = changeSetState;
            return this;
        }

        @Override
        public final Builder changeSetState(ChangeSetState changeSetState) {
            this.changeSetState(changeSetState == null ? null : changeSetState.toString());
            return this;
        }

        @Override
        public CoreNetworkPolicyVersion build() {
            return new CoreNetworkPolicyVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
