/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network edge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkEdge implements SdkPojo, Serializable, ToCopyableBuilder<CoreNetworkEdge.Builder, CoreNetworkEdge> {
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(CoreNetworkEdge::edgeLocation)).setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()).build();

    private static final SdkField<Long> ASN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Asn")
            .getter(getter(CoreNetworkEdge::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").build()).build();

    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsideCidrBlocks")
            .getter(getter(CoreNetworkEdge::insideCidrBlocks))
            .setter(setter(Builder::insideCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_LOCATION_FIELD,
            ASN_FIELD, INSIDE_CIDR_BLOCKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String edgeLocation;

    private final Long asn;

    private final List<String> insideCidrBlocks;

    private CoreNetworkEdge(BuilderImpl builder) {
        this.edgeLocation = builder.edgeLocation;
        this.asn = builder.asn;
        this.insideCidrBlocks = builder.insideCidrBlocks;
    }

    /**
     * <p>
     * The Region where a core network edge is located.
     * </p>
     * 
     * @return The Region where a core network edge is located.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    /**
     * <p>
     * The ASN of a core network edge.
     * </p>
     * 
     * @return The ASN of a core network edge.
     */
    public final Long asn() {
        return asn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsideCidrBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsideCidrBlocks() {
        return insideCidrBlocks != null && !(insideCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inside IP addresses used for core network edges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsideCidrBlocks} method.
     * </p>
     * 
     * @return The inside IP addresses used for core network edges.
     */
    public final List<String> insideCidrBlocks() {
        return insideCidrBlocks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsideCidrBlocks() ? insideCidrBlocks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkEdge)) {
            return false;
        }
        CoreNetworkEdge other = (CoreNetworkEdge) obj;
        return Objects.equals(edgeLocation(), other.edgeLocation()) && Objects.equals(asn(), other.asn())
                && hasInsideCidrBlocks() == other.hasInsideCidrBlocks()
                && Objects.equals(insideCidrBlocks(), other.insideCidrBlocks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkEdge").add("EdgeLocation", edgeLocation()).add("Asn", asn())
                .add("InsideCidrBlocks", hasInsideCidrBlocks() ? insideCidrBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        case "Asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "InsideCidrBlocks":
            return Optional.ofNullable(clazz.cast(insideCidrBlocks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkEdge, T> g) {
        return obj -> g.apply((CoreNetworkEdge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkEdge> {
        /**
         * <p>
         * The Region where a core network edge is located.
         * </p>
         * 
         * @param edgeLocation
         *        The Region where a core network edge is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);

        /**
         * <p>
         * The ASN of a core network edge.
         * </p>
         * 
         * @param asn
         *        The ASN of a core network edge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(Long asn);

        /**
         * <p>
         * The inside IP addresses used for core network edges.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The inside IP addresses used for core network edges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(Collection<String> insideCidrBlocks);

        /**
         * <p>
         * The inside IP addresses used for core network edges.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The inside IP addresses used for core network edges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(String... insideCidrBlocks);
    }

    static final class BuilderImpl implements Builder {
        private String edgeLocation;

        private Long asn;

        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkEdge model) {
            edgeLocation(model.edgeLocation);
            asn(model.asn);
            insideCidrBlocks(model.insideCidrBlocks);
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final Long getAsn() {
            return asn;
        }

        public final void setAsn(Long asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Long asn) {
            this.asn = asn;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String... insideCidrBlocks) {
            insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        @Override
        public CoreNetworkEdge build() {
            return new CoreNetworkEdge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
