/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworksResponse;

public class ListCoreNetworksPublisher
implements SdkPublisher<ListCoreNetworksResponse> {
    private final NetworkManagerAsyncClient client;
    private final ListCoreNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCoreNetworksPublisher(NetworkManagerAsyncClient client, ListCoreNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCoreNetworksPublisher(NetworkManagerAsyncClient client, ListCoreNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCoreNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCoreNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CoreNetworkSummary> coreNetworks() {
        Function<ListCoreNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworks() != null) {
                return response.coreNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCoreNetworksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCoreNetworksResponseFetcher
    implements AsyncPageFetcher<ListCoreNetworksResponse> {
        private ListCoreNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCoreNetworksResponse> nextPage(ListCoreNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListCoreNetworksPublisher.this.client.listCoreNetworks(ListCoreNetworksPublisher.this.firstRequest);
            }
            return ListCoreNetworksPublisher.this.client.listCoreNetworks((ListCoreNetworksRequest)((Object)ListCoreNetworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

