/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TCP flags and masks to inspect packets for, used in stateless rules <a>MatchAttributes</a> settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TCPFlagField implements SdkPojo, Serializable, ToCopyableBuilder<TCPFlagField.Builder, TCPFlagField> {
    private static final SdkField<List<String>> FLAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Flags")
            .getter(getter(TCPFlagField::flagsAsStrings))
            .setter(setter(Builder::flagsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MASKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Masks")
            .getter(getter(TCPFlagField::masksAsStrings))
            .setter(setter(Builder::masksWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Masks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAGS_FIELD, MASKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> flags;

    private final List<String> masks;

    private TCPFlagField(BuilderImpl builder) {
        this.flags = builder.flags;
        this.masks = builder.masks;
    }

    /**
     * <p>
     * Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must
     * not be set in order for the packet to match. This setting can only specify values that are also specified in the
     * <code>Masks</code> setting.
     * </p>
     * <p>
     * For the flags that are specified in the masks setting, the following must be true for the packet to match:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The ones that are set in this flags setting must be set in the packet.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ones that are not set in this flags setting must also not be set in the packet.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlags} method.
     * </p>
     * 
     * @return Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags
     *         that must not be set in order for the packet to match. This setting can only specify values that are also
     *         specified in the <code>Masks</code> setting.</p>
     *         <p>
     *         For the flags that are specified in the masks setting, the following must be true for the packet to
     *         match:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The ones that are set in this flags setting must be set in the packet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The ones that are not set in this flags setting must also not be set in the packet.
     *         </p>
     *         </li>
     */
    public final List<TCPFlag> flags() {
        return FlagsCopier.copyStringToEnum(flags);
    }

    /**
     * For responses, this returns true if the service returned a value for the Flags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFlags() {
        return flags != null && !(flags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that must
     * not be set in order for the packet to match. This setting can only specify values that are also specified in the
     * <code>Masks</code> setting.
     * </p>
     * <p>
     * For the flags that are specified in the masks setting, the following must be true for the packet to match:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The ones that are set in this flags setting must be set in the packet.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ones that are not set in this flags setting must also not be set in the packet.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlags} method.
     * </p>
     * 
     * @return Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags
     *         that must not be set in order for the packet to match. This setting can only specify values that are also
     *         specified in the <code>Masks</code> setting.</p>
     *         <p>
     *         For the flags that are specified in the masks setting, the following must be true for the packet to
     *         match:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The ones that are set in this flags setting must be set in the packet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The ones that are not set in this flags setting must also not be set in the packet.
     *         </p>
     *         </li>
     */
    public final List<String> flagsAsStrings() {
        return flags;
    }

    /**
     * <p>
     * The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no
     * setting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMasks} method.
     * </p>
     * 
     * @return The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this
     *         with no setting.
     */
    public final List<TCPFlag> masks() {
        return FlagsCopier.copyStringToEnum(masks);
    }

    /**
     * For responses, this returns true if the service returned a value for the Masks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasMasks() {
        return masks != null && !(masks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no
     * setting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMasks} method.
     * </p>
     * 
     * @return The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this
     *         with no setting.
     */
    public final List<String> masksAsStrings() {
        return masks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFlags() ? flagsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMasks() ? masksAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TCPFlagField)) {
            return false;
        }
        TCPFlagField other = (TCPFlagField) obj;
        return hasFlags() == other.hasFlags() && Objects.equals(flagsAsStrings(), other.flagsAsStrings())
                && hasMasks() == other.hasMasks() && Objects.equals(masksAsStrings(), other.masksAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TCPFlagField").add("Flags", hasFlags() ? flagsAsStrings() : null)
                .add("Masks", hasMasks() ? masksAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Flags":
            return Optional.ofNullable(clazz.cast(flagsAsStrings()));
        case "Masks":
            return Optional.ofNullable(clazz.cast(masksAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TCPFlagField, T> g) {
        return obj -> g.apply((TCPFlagField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TCPFlagField> {
        /**
         * <p>
         * Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that
         * must not be set in order for the packet to match. This setting can only specify values that are also
         * specified in the <code>Masks</code> setting.
         * </p>
         * <p>
         * For the flags that are specified in the masks setting, the following must be true for the packet to match:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The ones that are set in this flags setting must be set in the packet.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ones that are not set in this flags setting must also not be set in the packet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flags
         *        Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags
         *        that must not be set in order for the packet to match. This setting can only specify values that are
         *        also specified in the <code>Masks</code> setting.</p>
         *        <p>
         *        For the flags that are specified in the masks setting, the following must be true for the packet to
         *        match:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The ones that are set in this flags setting must be set in the packet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ones that are not set in this flags setting must also not be set in the packet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flagsWithStrings(Collection<String> flags);

        /**
         * <p>
         * Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that
         * must not be set in order for the packet to match. This setting can only specify values that are also
         * specified in the <code>Masks</code> setting.
         * </p>
         * <p>
         * For the flags that are specified in the masks setting, the following must be true for the packet to match:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The ones that are set in this flags setting must be set in the packet.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ones that are not set in this flags setting must also not be set in the packet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flags
         *        Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags
         *        that must not be set in order for the packet to match. This setting can only specify values that are
         *        also specified in the <code>Masks</code> setting.</p>
         *        <p>
         *        For the flags that are specified in the masks setting, the following must be true for the packet to
         *        match:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The ones that are set in this flags setting must be set in the packet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ones that are not set in this flags setting must also not be set in the packet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flagsWithStrings(String... flags);

        /**
         * <p>
         * Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that
         * must not be set in order for the packet to match. This setting can only specify values that are also
         * specified in the <code>Masks</code> setting.
         * </p>
         * <p>
         * For the flags that are specified in the masks setting, the following must be true for the packet to match:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The ones that are set in this flags setting must be set in the packet.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ones that are not set in this flags setting must also not be set in the packet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flags
         *        Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags
         *        that must not be set in order for the packet to match. This setting can only specify values that are
         *        also specified in the <code>Masks</code> setting.</p>
         *        <p>
         *        For the flags that are specified in the masks setting, the following must be true for the packet to
         *        match:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The ones that are set in this flags setting must be set in the packet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ones that are not set in this flags setting must also not be set in the packet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flags(Collection<TCPFlag> flags);

        /**
         * <p>
         * Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags that
         * must not be set in order for the packet to match. This setting can only specify values that are also
         * specified in the <code>Masks</code> setting.
         * </p>
         * <p>
         * For the flags that are specified in the masks setting, the following must be true for the packet to match:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The ones that are set in this flags setting must be set in the packet.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ones that are not set in this flags setting must also not be set in the packet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flags
         *        Used in conjunction with the <code>Masks</code> setting to define the flags that must be set and flags
         *        that must not be set in order for the packet to match. This setting can only specify values that are
         *        also specified in the <code>Masks</code> setting.</p>
         *        <p>
         *        For the flags that are specified in the masks setting, the following must be true for the packet to
         *        match:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The ones that are set in this flags setting must be set in the packet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ones that are not set in this flags setting must also not be set in the packet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flags(TCPFlag... flags);

        /**
         * <p>
         * The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this
         * with no setting.
         * </p>
         * 
         * @param masks
         *        The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave
         *        this with no setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masksWithStrings(Collection<String> masks);

        /**
         * <p>
         * The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this
         * with no setting.
         * </p>
         * 
         * @param masks
         *        The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave
         *        this with no setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masksWithStrings(String... masks);

        /**
         * <p>
         * The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this
         * with no setting.
         * </p>
         * 
         * @param masks
         *        The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave
         *        this with no setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masks(Collection<TCPFlag> masks);

        /**
         * <p>
         * The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this
         * with no setting.
         * </p>
         * 
         * @param masks
         *        The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave
         *        this with no setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masks(TCPFlag... masks);
    }

    static final class BuilderImpl implements Builder {
        private List<String> flags = DefaultSdkAutoConstructList.getInstance();

        private List<String> masks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TCPFlagField model) {
            flagsWithStrings(model.flags);
            masksWithStrings(model.masks);
        }

        public final Collection<String> getFlags() {
            if (flags instanceof SdkAutoConstructList) {
                return null;
            }
            return flags;
        }

        public final void setFlags(Collection<String> flags) {
            this.flags = FlagsCopier.copy(flags);
        }

        @Override
        public final Builder flagsWithStrings(Collection<String> flags) {
            this.flags = FlagsCopier.copy(flags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flagsWithStrings(String... flags) {
            flagsWithStrings(Arrays.asList(flags));
            return this;
        }

        @Override
        public final Builder flags(Collection<TCPFlag> flags) {
            this.flags = FlagsCopier.copyEnumToString(flags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flags(TCPFlag... flags) {
            flags(Arrays.asList(flags));
            return this;
        }

        public final Collection<String> getMasks() {
            if (masks instanceof SdkAutoConstructList) {
                return null;
            }
            return masks;
        }

        public final void setMasks(Collection<String> masks) {
            this.masks = FlagsCopier.copy(masks);
        }

        @Override
        public final Builder masksWithStrings(Collection<String> masks) {
            this.masks = FlagsCopier.copy(masks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder masksWithStrings(String... masks) {
            masksWithStrings(Arrays.asList(masks));
            return this;
        }

        @Override
        public final Builder masks(Collection<TCPFlag> masks) {
            this.masks = FlagsCopier.copyEnumToString(masks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder masks(TCPFlag... masks) {
            masks(Arrays.asList(masks));
            return this;
        }

        @Override
        public TCPFlagField build() {
            return new TCPFlagField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
