/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class IPSetReferenceMapCopier {
    static Map<String, IPSetReference> copy(Map<String, ? extends IPSetReference> ipSetReferenceMapParam) {
        Map<String, IPSetReference> map;
        if (ipSetReferenceMapParam == null || ipSetReferenceMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, IPSetReference> modifiableMap = new LinkedHashMap<>();
            ipSetReferenceMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, IPSetReference> copyFromBuilder(Map<String, ? extends IPSetReference.Builder> ipSetReferenceMapParam) {
        Map<String, IPSetReference> map;
        if (ipSetReferenceMapParam == null || ipSetReferenceMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, IPSetReference> modifiableMap = new LinkedHashMap<>();
            ipSetReferenceMapParam.forEach((key, value) -> {
                IPSetReference member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, IPSetReference.Builder> copyToBuilder(Map<String, ? extends IPSetReference> ipSetReferenceMapParam) {
        Map<String, IPSetReference.Builder> map;
        if (ipSetReferenceMapParam == null || ipSetReferenceMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, IPSetReference.Builder> modifiableMap = new LinkedHashMap<>();
            ipSetReferenceMapParam.forEach((key, value) -> {
                IPSetReference.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
