/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.InsufficientCapacityException;
import software.amazon.awssdk.services.networkfirewall.model.InternalServerErrorException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidOperationException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidRequestException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidResourcePolicyException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidTokenException;
import software.amazon.awssdk.services.networkfirewall.model.LimitExceededException;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.LogDestinationPermissionException;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallException;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkfirewall.model.ResourceOwnerCheckException;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ThrottlingException;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable;
import software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable;

/**
 * Service client for accessing Network Firewall. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the API Reference for Network Firewall. This guide is for developers who need detailed information about the
 * Network Firewall API actions, data types, and errors.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The REST API requires you to handle connection details, such as calculating signatures, handling request retries, and
 * error handling. For general information about using the Amazon Web Services REST APIs, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/aws-apis.html">Amazon Web Services APIs</a>.
 * </p>
 * <p>
 * To access Network Firewall using the REST API endpoint:
 * <code>https://network-firewall.&lt;region&gt;.amazonaws.com </code>
 * </p>
 * </li>
 * <li>
 * <p>
 * Alternatively, you can use one of the Amazon Web Services SDKs to access an API that's tailored to the programming
 * language or platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon
 * Web Services SDKs</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For descriptions of Network Firewall features, including and step-by-step instructions on how to use them through the
 * Network Firewall console, see the <a
 * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/">Network Firewall Developer Guide</a>.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Network Firewall is a stateful, managed, network firewall and intrusion detection and prevention service for Amazon
 * Virtual Private Cloud (Amazon VPC). With Network Firewall, you can filter traffic at the perimeter of your VPC. This
 * includes filtering traffic going to and coming from an internet gateway, NAT gateway, or over VPN or Direct Connect.
 * Network Firewall uses rules that are compatible with Suricata, a free, open source network analysis and threat
 * detection engine. Network Firewall supports Suricata version 6.0.9. For information about Suricata, see the <a
 * href="https://suricata.io/">Suricata website</a>.
 * </p>
 * <p>
 * You can use Network Firewall to monitor and protect your VPC traffic in a number of ways. The following are just a
 * few examples:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Allow domains or IP addresses for known Amazon Web Services service endpoints, such as Amazon S3, and block all other
 * forms of traffic.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use custom lists of known bad domains to limit the types of domain names that your applications can access.
 * </p>
 * </li>
 * <li>
 * <p>
 * Perform deep packet inspection on traffic entering or leaving your VPC.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use stateful protocol detection to filter protocols like HTTPS, regardless of the port used.
 * </p>
 * </li>
 * </ul>
 * <p>
 * To enable Network Firewall for your VPCs, you perform steps in both Amazon VPC and in Network Firewall. For
 * information about using Amazon VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon VPC User
 * Guide</a>.
 * </p>
 * <p>
 * To start using Network Firewall, do the following:
 * </p>
 * <ol>
 * <li>
 * <p>
 * (Optional) If you don't already have a VPC that you want to protect, create it in Amazon VPC.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Amazon VPC, in each Availability Zone where you want to have a firewall endpoint, create a subnet for the sole use
 * of Network Firewall.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Network Firewall, create stateless and stateful rule groups, to define the components of the network traffic
 * filtering behavior that you want your firewall to have.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Network Firewall, create a firewall policy that uses your rule groups and specifies additional default traffic
 * filtering behavior.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Network Firewall, create a firewall and specify your new firewall policy and VPC subnets. Network Firewall creates
 * a firewall endpoint in each subnet that you specify, with the behavior that's defined in the firewall policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Amazon VPC, use ingress routing enhancements to route traffic through the new firewall endpoints.
 * </p>
 * </li>
 * </ol>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NetworkFirewallClient extends AwsClient {
    String SERVICE_NAME = "network-firewall";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "network-firewall";

    /**
     * <p>
     * Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>.
     * </p>
     * <p>
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection
     * rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same
     * firewall policy for multiple firewalls.
     * </p>
     *
     * @param associateFirewallPolicyRequest
     * @return Result of the AssociateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateFirewallPolicyResponse associateFirewallPolicy(AssociateFirewallPolicyRequest associateFirewallPolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>.
     * </p>
     * <p>
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection
     * rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same
     * firewall policy for multiple firewalls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFirewallPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param associateFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on {@link AssociateFirewallPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateFirewallPolicyResponse associateFirewallPolicy(
            Consumer<AssociateFirewallPolicyRequest.Builder> associateFirewallPolicyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return associateFirewallPolicy(AssociateFirewallPolicyRequest.builder().applyMutation(associateFirewallPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the
     * Availability Zones that the VPC spans.
     * </p>
     * <p>
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's
     * protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the
     * traffic that's coming into and going out of the zone through the firewall endpoint.
     * </p>
     *
     * @param associateSubnetsRequest
     * @return Result of the AssociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSubnetsResponse associateSubnets(AssociateSubnetsRequest associateSubnetsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, InsufficientCapacityException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the
     * Availability Zones that the VPC spans.
     * </p>
     * <p>
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's
     * protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the
     * traffic that's coming into and going out of the zone through the firewall endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSubnetsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateSubnetsRequest#builder()}
     * </p>
     *
     * @param associateSubnetsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSubnetsRequest.Builder} to create a request.
     * @return Result of the AssociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSubnetsResponse associateSubnets(Consumer<AssociateSubnetsRequest.Builder> associateSubnetsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, InsufficientCapacityException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return associateSubnets(AssociateSubnetsRequest.builder().applyMutation(associateSubnetsRequest).build());
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC.
     * </p>
     * <p>
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can
     * define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and
     * any tags that are attached to the firewall Amazon Web Services resource.
     * </p>
     * <p>
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     * </p>
     * <p>
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example
     * <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>.
     * </p>
     * <p>
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.
     * </p>
     *
     * @param createFirewallRequest
     * @return Result of the CreateFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallResponse createFirewall(CreateFirewallRequest createFirewallRequest) throws InvalidRequestException,
            LimitExceededException, InternalServerErrorException, ThrottlingException, InsufficientCapacityException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC.
     * </p>
     * <p>
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can
     * define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and
     * any tags that are attached to the firewall Amazon Web Services resource.
     * </p>
     * <p>
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     * </p>
     * <p>
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example
     * <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>.
     * </p>
     * <p>
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFirewallRequest#builder()}
     * </p>
     *
     * @param createFirewallRequest
     *        A {@link Consumer} that will call methods on {@link CreateFirewallRequest.Builder} to create a request.
     * @return Result of the CreateFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallResponse createFirewall(Consumer<CreateFirewallRequest.Builder> createFirewallRequest)
            throws InvalidRequestException, LimitExceededException, InternalServerErrorException, ThrottlingException,
            InsufficientCapacityException, InvalidOperationException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        return createFirewall(CreateFirewallRequest.builder().applyMutation(createFirewallRequest).build());
    }

    /**
     * <p>
     * Creates the firewall policy for the firewall according to the specifications.
     * </p>
     * <p>
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful
     * rule groups and other settings. You can use one firewall policy for multiple firewalls.
     * </p>
     *
     * @param createFirewallPolicyRequest
     * @return Result of the CreateFirewallPolicy operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallPolicyResponse createFirewallPolicy(CreateFirewallPolicyRequest createFirewallPolicyRequest)
            throws LimitExceededException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the firewall policy for the firewall according to the specifications.
     * </p>
     * <p>
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful
     * rule groups and other settings. You can use one firewall policy for multiple firewalls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param createFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateFirewallPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFirewallPolicy operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallPolicyResponse createFirewallPolicy(
            Consumer<CreateFirewallPolicyRequest.Builder> createFirewallPolicyRequest) throws LimitExceededException,
            InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return createFirewallPolicy(CreateFirewallPolicyRequest.builder().applyMutation(createFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection,
     * a capacity setting, and tags.
     * </p>
     * <p>
     * You provide your rule group specification in your request using either <code>RuleGroup</code> or
     * <code>Rules</code>.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return Result of the CreateRuleGroup operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRuleGroupResponse createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) throws LimitExceededException,
            InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection,
     * a capacity setting, and tags.
     * </p>
     * <p>
     * You provide your rule group specification in your request using either <code>RuleGroup</code> or
     * <code>Rules</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRuleGroupRequest#builder()}
     * </p>
     *
     * @param createRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateRuleGroupRequest.Builder} to create a request.
     * @return Result of the CreateRuleGroup operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRuleGroupResponse createRuleGroup(Consumer<CreateRuleGroupRequest.Builder> createRuleGroupRequest)
            throws LimitExceededException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return createRuleGroup(CreateRuleGroupRequest.builder().applyMutation(createRuleGroupRequest).build());
    }

    /**
     * <p>
     * Creates an Network Firewall TLS inspection configuration. A TLS inspection configuration contains the Certificate
     * Manager certificate references that Network Firewall uses to decrypt and re-encrypt inbound traffic.
     * </p>
     * <p>
     * After you create a TLS inspection configuration, you associate it with a firewall policy.
     * </p>
     * <p>
     * To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * To manage a TLS inspection configuration's tags, use the standard Amazon Web Services resource tagging
     * operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and
     * <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * For more information about TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     *
     * @param createTlsInspectionConfigurationRequest
     * @return Result of the CreateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTlsInspectionConfigurationResponse createTLSInspectionConfiguration(
            CreateTlsInspectionConfigurationRequest createTlsInspectionConfigurationRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall TLS inspection configuration. A TLS inspection configuration contains the Certificate
     * Manager certificate references that Network Firewall uses to decrypt and re-encrypt inbound traffic.
     * </p>
     * <p>
     * After you create a TLS inspection configuration, you associate it with a firewall policy.
     * </p>
     * <p>
     * To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * To manage a TLS inspection configuration's tags, use the standard Amazon Web Services resource tagging
     * operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and
     * <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * For more information about TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param createTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateTLSInspectionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTlsInspectionConfigurationResponse createTLSInspectionConfiguration(
            Consumer<CreateTlsInspectionConfigurationRequest.Builder> createTlsInspectionConfigurationRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return createTLSInspectionConfiguration(CreateTlsInspectionConfigurationRequest.builder()
                .applyMutation(createTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall's
     * <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation.
     * </p>
     * <p>
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you
     * have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and
     * update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the
     * firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall
     * safely.
     * </p>
     * <p>
     * To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
     * then delete the firewall by calling <a>DeleteFirewall</a>.
     * </p>
     *
     * @param deleteFirewallRequest
     * @return Result of the DeleteFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallResponse deleteFirewall(DeleteFirewallRequest deleteFirewallRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall's
     * <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation.
     * </p>
     * <p>
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you
     * have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and
     * update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the
     * firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall
     * safely.
     * </p>
     * <p>
     * To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
     * then delete the firewall by calling <a>DeleteFirewall</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFirewallRequest#builder()}
     * </p>
     *
     * @param deleteFirewallRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFirewallRequest.Builder} to create a request.
     * @return Result of the DeleteFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallResponse deleteFirewall(Consumer<DeleteFirewallRequest.Builder> deleteFirewallRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteFirewall(DeleteFirewallRequest.builder().applyMutation(deleteFirewallRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>FirewallPolicy</a>.
     * </p>
     *
     * @param deleteFirewallPolicyRequest
     * @return Result of the DeleteFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallPolicyResponse deleteFirewallPolicy(DeleteFirewallPolicyRequest deleteFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>FirewallPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param deleteFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFirewallPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallPolicyResponse deleteFirewallPolicy(
            Consumer<DeleteFirewallPolicyRequest.Builder> deleteFirewallPolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteFirewallPolicy(DeleteFirewallPolicyRequest.builder().applyMutation(deleteFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidResourcePolicyException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return Result of the DeleteRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRuleGroupResponse deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRuleGroupRequest#builder()}
     * </p>
     *
     * @param deleteRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRuleGroupRequest.Builder} to create a request.
     * @return Result of the DeleteRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRuleGroupResponse deleteRuleGroup(Consumer<DeleteRuleGroupRequest.Builder> deleteRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteRuleGroup(DeleteRuleGroupRequest.builder().applyMutation(deleteRuleGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>TLSInspectionConfiguration</a>.
     * </p>
     *
     * @param deleteTlsInspectionConfigurationRequest
     * @return Result of the DeleteTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTlsInspectionConfigurationResponse deleteTLSInspectionConfiguration(
            DeleteTlsInspectionConfigurationRequest deleteTlsInspectionConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>TLSInspectionConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTLSInspectionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTlsInspectionConfigurationResponse deleteTLSInspectionConfiguration(
            Consumer<DeleteTlsInspectionConfigurationRequest.Builder> deleteTlsInspectionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return deleteTLSInspectionConfiguration(DeleteTlsInspectionConfigurationRequest.builder()
                .applyMutation(deleteTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall.
     * </p>
     *
     * @param describeFirewallRequest
     * @return Result of the DescribeFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallResponse describeFirewall(DescribeFirewallRequest describeFirewallRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFirewallRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFirewallRequest#builder()}
     * </p>
     *
     * @param describeFirewallRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFirewallRequest.Builder} to create a request.
     * @return Result of the DescribeFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallResponse describeFirewall(Consumer<DescribeFirewallRequest.Builder> describeFirewallRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeFirewall(DescribeFirewallRequest.builder().applyMutation(describeFirewallRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall policy.
     * </p>
     *
     * @param describeFirewallPolicyRequest
     * @return Result of the DescribeFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallPolicyResponse describeFirewallPolicy(DescribeFirewallPolicyRequest describeFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param describeFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFirewallPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFirewallPolicyResponse describeFirewallPolicy(
            Consumer<DescribeFirewallPolicyRequest.Builder> describeFirewallPolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeFirewallPolicy(DescribeFirewallPolicyRequest.builder().applyMutation(describeFirewallPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the logging configuration for the specified firewall.
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     * @return Result of the DescribeLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoggingConfigurationResponse describeLoggingConfiguration(
            DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the logging configuration for the specified firewall.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLoggingConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoggingConfigurationResponse describeLoggingConfiguration(
            Consumer<DescribeLoggingConfigurationRequest.Builder> describeLoggingConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeLoggingConfiguration(DescribeLoggingConfigurationRequest.builder()
                .applyMutation(describeLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourcePolicyResponse describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the data objects for the specified rule group.
     * </p>
     *
     * @param describeRuleGroupRequest
     * @return Result of the DescribeRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupResponse describeRuleGroup(DescribeRuleGroupRequest describeRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRuleGroupRequest#builder()}
     * </p>
     *
     * @param describeRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRuleGroupRequest.Builder} to create a request.
     * @return Result of the DescribeRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupResponse describeRuleGroup(Consumer<DescribeRuleGroupRequest.Builder> describeRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeRuleGroup(DescribeRuleGroupRequest.builder().applyMutation(describeRuleGroupRequest).build());
    }

    /**
     * <p>
     * High-level information about a rule group, returned by operations like create and describe. You can use the
     * information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule
     * group by calling <a>DescribeRuleGroup</a>.
     * </p>
     *
     * @param describeRuleGroupMetadataRequest
     * @return Result of the DescribeRuleGroupMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroupMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupMetadataResponse describeRuleGroupMetadata(
            DescribeRuleGroupMetadataRequest describeRuleGroupMetadataRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * High-level information about a rule group, returned by operations like create and describe. You can use the
     * information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule
     * group by calling <a>DescribeRuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleGroupMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRuleGroupMetadataRequest#builder()}
     * </p>
     *
     * @param describeRuleGroupMetadataRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRuleGroupMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRuleGroupMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroupMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRuleGroupMetadataResponse describeRuleGroupMetadata(
            Consumer<DescribeRuleGroupMetadataRequest.Builder> describeRuleGroupMetadataRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return describeRuleGroupMetadata(DescribeRuleGroupMetadataRequest.builder()
                .applyMutation(describeRuleGroupMetadataRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified TLS inspection configuration.
     * </p>
     *
     * @param describeTlsInspectionConfigurationRequest
     * @return Result of the DescribeTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTlsInspectionConfigurationResponse describeTLSInspectionConfiguration(
            DescribeTlsInspectionConfigurationRequest describeTlsInspectionConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified TLS inspection configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param describeTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTLSInspectionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTlsInspectionConfigurationResponse describeTLSInspectionConfiguration(
            Consumer<DescribeTlsInspectionConfigurationRequest.Builder> describeTlsInspectionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return describeTLSInspectionConfiguration(DescribeTlsInspectionConfigurationRequest.builder()
                .applyMutation(describeTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets
     * and removes any network filtering protections that the endpoints were providing.
     * </p>
     *
     * @param disassociateSubnetsRequest
     * @return Result of the DisassociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DisassociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSubnetsResponse disassociateSubnets(DisassociateSubnetsRequest disassociateSubnetsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets
     * and removes any network filtering protections that the endpoints were providing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSubnetsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateSubnetsRequest#builder()}
     * </p>
     *
     * @param disassociateSubnetsRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSubnetsRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DisassociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSubnetsResponse disassociateSubnets(
            Consumer<DisassociateSubnetsRequest.Builder> disassociateSubnetsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return disassociateSubnets(DisassociateSubnetsRequest.builder().applyMutation(disassociateSubnetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     *
     * @param listFirewallPoliciesRequest
     * @return Result of the ListFirewallPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesResponse listFirewallPolicies(ListFirewallPoliciesRequest listFirewallPoliciesRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallPoliciesRequest#builder()}
     * </p>
     *
     * @param listFirewallPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallPoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListFirewallPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesResponse listFirewallPolicies(
            Consumer<ListFirewallPoliciesRequest.Builder> listFirewallPoliciesRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return listFirewallPolicies(ListFirewallPoliciesRequest.builder().applyMutation(listFirewallPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client.listFirewallPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client
     *             .listFirewallPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client.listFirewallPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesIterable listFirewallPoliciesPaginator(ListFirewallPoliciesRequest listFirewallPoliciesRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client.listFirewallPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client
     *             .listFirewallPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesIterable responses = client.listFirewallPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallPoliciesRequest#builder()}
     * </p>
     *
     * @param listFirewallPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesIterable listFirewallPoliciesPaginator(
            Consumer<ListFirewallPoliciesRequest.Builder> listFirewallPoliciesRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return listFirewallPoliciesPaginator(ListFirewallPoliciesRequest.builder().applyMutation(listFirewallPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     *
     * @param listFirewallsRequest
     * @return Result of the ListFirewalls operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsResponse listFirewalls(ListFirewallsRequest listFirewallsRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFirewallsRequest#builder()}
     * </p>
     *
     * @param listFirewallsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallsRequest.Builder} to create a request.
     * @return Result of the ListFirewalls operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsResponse listFirewalls(Consumer<ListFirewallsRequest.Builder> listFirewallsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listFirewalls(ListFirewallsRequest.builder().applyMutation(listFirewallsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client.listFirewallsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client
     *             .listFirewallsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client.listFirewallsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation.</b>
     * </p>
     *
     * @param listFirewallsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsIterable listFirewallsPaginator(ListFirewallsRequest listFirewallsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client.listFirewallsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client
     *             .listFirewallsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsIterable responses = client.listFirewallsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFirewallsRequest#builder()}
     * </p>
     *
     * @param listFirewallsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsIterable listFirewallsPaginator(Consumer<ListFirewallsRequest.Builder> listFirewallsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listFirewallsPaginator(ListFirewallsRequest.builder().applyMutation(listFirewallsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return Result of the ListRuleGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsResponse listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRuleGroupsRequest.Builder} to create a request.
     * @return Result of the ListRuleGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsResponse listRuleGroups(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listRuleGroups(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client.listRuleGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client
     *             .listRuleGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client.listRuleGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsIterable listRuleGroupsPaginator(ListRuleGroupsRequest listRuleGroupsRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client.listRuleGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client
     *             .listRuleGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsIterable responses = client.listRuleGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRuleGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsIterable listRuleGroupsPaginator(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listRuleGroupsPaginator(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     * @return Result of the ListTLSInspectionConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTlsInspectionConfigurationsResponse listTLSInspectionConfigurations(
            ListTlsInspectionConfigurationsRequest listTlsInspectionConfigurationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTlsInspectionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTlsInspectionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTLSInspectionConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListTLSInspectionConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTlsInspectionConfigurationsResponse listTLSInspectionConfigurations(
            Consumer<ListTlsInspectionConfigurationsRequest.Builder> listTlsInspectionConfigurationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listTLSInspectionConfigurations(ListTlsInspectionConfigurationsRequest.builder()
                .applyMutation(listTlsInspectionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client.listTLSInspectionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client
     *             .listTLSInspectionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client.listTLSInspectionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTLSInspectionConfigurationsIterable listTLSInspectionConfigurationsPaginator(
            ListTlsInspectionConfigurationsRequest listTlsInspectionConfigurationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client.listTLSInspectionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client
     *             .listTLSInspectionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsIterable responses = client.listTLSInspectionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTlsInspectionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTlsInspectionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTLSInspectionConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTLSInspectionConfigurationsIterable listTLSInspectionConfigurationsPaginator(
            Consumer<ListTlsInspectionConfigurationsRequest.Builder> listTlsInspectionConfigurationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listTLSInspectionConfigurationsPaginator(ListTlsInspectionConfigurationsRequest.builder()
                .applyMutation(listTlsInspectionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and
     * firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource
     * Access Manager (RAM) service to manage resource sharing for Network Firewall.
     * </p>
     * <p>
     * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy,
     * you specify the accounts that you want to share the resource with and the operations that you want the accounts
     * to be able to perform.
     * </p>
     * <p>
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM)
     * operations to access and accept the shared rule group or firewall policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">
     * GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">
     * AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information about resource sharing using RAM, see <a
     * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and
     * firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource
     * Access Manager (RAM) service to manage resource sharing for Network Firewall.
     * </p>
     * <p>
     * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy,
     * you specify the accounts that you want to share the resource with and the operations that you want the accounts
     * to be able to perform.
     * </p>
     * <p>
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM)
     * operations to access and accept the shared rule group or firewall policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">
     * GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">
     * AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information about resource sharing using RAM, see <a
     * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyRequest.Builder} to create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource,
     * up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource,
     * up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use
     * to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls,
     * firewall policies, and rule groups.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use
     * to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls,
     * firewall policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect
     * against accidentally deleting a firewall that's in use.
     * </p>
     *
     * @param updateFirewallDeleteProtectionRequest
     * @return Result of the UpdateFirewallDeleteProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDeleteProtectionResponse updateFirewallDeleteProtection(
            UpdateFirewallDeleteProtectionRequest updateFirewallDeleteProtectionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect
     * against accidentally deleting a firewall that's in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDeleteProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFirewallDeleteProtectionRequest#builder()}
     * </p>
     *
     * @param updateFirewallDeleteProtectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallDeleteProtectionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFirewallDeleteProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDeleteProtectionResponse updateFirewallDeleteProtection(
            Consumer<UpdateFirewallDeleteProtectionRequest.Builder> updateFirewallDeleteProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallDeleteProtection(UpdateFirewallDeleteProtectionRequest.builder()
                .applyMutation(updateFirewallDeleteProtectionRequest).build());
    }

    /**
     * <p>
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when
     * you're working with it.
     * </p>
     *
     * @param updateFirewallDescriptionRequest
     * @return Result of the UpdateFirewallDescription operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDescriptionResponse updateFirewallDescription(
            UpdateFirewallDescriptionRequest updateFirewallDescriptionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when
     * you're working with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDescriptionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFirewallDescriptionRequest#builder()}
     * </p>
     *
     * @param updateFirewallDescriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallDescriptionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFirewallDescription operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDescriptionResponse updateFirewallDescription(
            Consumer<UpdateFirewallDescriptionRequest.Builder> updateFirewallDescriptionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallDescription(UpdateFirewallDescriptionRequest.builder()
                .applyMutation(updateFirewallDescriptionRequest).build());
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     *
     * @param updateFirewallEncryptionConfigurationRequest
     * @return Result of the UpdateFirewallEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallEncryptionConfigurationResponse updateFirewallEncryptionConfiguration(
            UpdateFirewallEncryptionConfigurationRequest updateFirewallEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateFirewallEncryptionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateFirewallEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateFirewallEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateFirewallEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallEncryptionConfigurationResponse updateFirewallEncryptionConfiguration(
            Consumer<UpdateFirewallEncryptionConfigurationRequest.Builder> updateFirewallEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallEncryptionConfiguration(UpdateFirewallEncryptionConfigurationRequest.builder()
                .applyMutation(updateFirewallEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the properties of the specified firewall policy.
     * </p>
     *
     * @param updateFirewallPolicyRequest
     * @return Result of the UpdateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallPolicyResponse updateFirewallPolicy(UpdateFirewallPolicyRequest updateFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of the specified firewall policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param updateFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallPolicyResponse updateFirewallPolicy(
            Consumer<UpdateFirewallPolicyRequest.Builder> updateFirewallPolicyRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallPolicy(UpdateFirewallPolicyRequest.builder().applyMutation(updateFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect
     * against accidentally changing a firewall that's in use.
     * </p>
     *
     * @param updateFirewallPolicyChangeProtectionRequest
     * @return Result of the UpdateFirewallPolicyChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicyChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallPolicyChangeProtectionResponse updateFirewallPolicyChangeProtection(
            UpdateFirewallPolicyChangeProtectionRequest updateFirewallPolicyChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect
     * against accidentally changing a firewall that's in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateFirewallPolicyChangeProtectionRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateFirewallPolicyChangeProtectionRequest#builder()}
     * </p>
     *
     * @param updateFirewallPolicyChangeProtectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallPolicyChangeProtectionRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateFirewallPolicyChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicyChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallPolicyChangeProtectionResponse updateFirewallPolicyChangeProtection(
            Consumer<UpdateFirewallPolicyChangeProtectionRequest.Builder> updateFirewallPolicyChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateFirewallPolicyChangeProtection(UpdateFirewallPolicyChangeProtectionRequest.builder()
                .applyMutation(updateFirewallPolicyChangeProtectionRequest).build());
    }

    /**
     * <p>
     * Sets the logging configuration for the specified firewall.
     * </p>
     * <p>
     * To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling
     * <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must
     * change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved
     * <a>LoggingConfiguration</a> object.
     * </p>
     * <p>
     * You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
     * <code>LogDestinationConfig</code>. To change these settings, delete the existing
     * <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     * @return Result of the UpdateLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws LogDestinationPermissionException
     *         Unable to send logs to a configured logging destination.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLoggingConfigurationResponse updateLoggingConfiguration(
            UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            LogDestinationPermissionException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the logging configuration for the specified firewall.
     * </p>
     * <p>
     * To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling
     * <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must
     * change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved
     * <a>LoggingConfiguration</a> object.
     * </p>
     * <p>
     * You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
     * <code>LogDestinationConfig</code>. To change these settings, delete the existing
     * <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws LogDestinationPermissionException
     *         Unable to send logs to a configured logging destination.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLoggingConfigurationResponse updateLoggingConfiguration(
            Consumer<UpdateLoggingConfigurationRequest.Builder> updateLoggingConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, LogDestinationPermissionException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        return updateLoggingConfiguration(UpdateLoggingConfigurationRequest.builder()
                .applyMutation(updateLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall
     * policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     * </p>
     * <p>
     * To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object,
     * update the object as needed, and then provide the updated object to this call.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return Result of the UpdateRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRuleGroupResponse updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall
     * policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     * </p>
     * <p>
     * To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object,
     * update the object as needed, and then provide the updated object to this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleGroupRequest#builder()}
     * </p>
     *
     * @param updateRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleGroupRequest.Builder} to create a request.
     * @return Result of the UpdateRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRuleGroupResponse updateRuleGroup(Consumer<UpdateRuleGroupRequest.Builder> updateRuleGroupRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateRuleGroup(UpdateRuleGroupRequest.builder().applyMutation(updateRuleGroupRequest).build());
    }

    /**
     * <p/>
     *
     * @param updateSubnetChangeProtectionRequest
     * @return Result of the UpdateSubnetChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateSubnetChangeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubnetChangeProtectionResponse updateSubnetChangeProtection(
            UpdateSubnetChangeProtectionRequest updateSubnetChangeProtectionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubnetChangeProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSubnetChangeProtectionRequest#builder()}
     * </p>
     *
     * @param updateSubnetChangeProtectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubnetChangeProtectionRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateSubnetChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateSubnetChangeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubnetChangeProtectionResponse updateSubnetChangeProtection(
            Consumer<UpdateSubnetChangeProtectionRequest.Builder> updateSubnetChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateSubnetChangeProtection(UpdateSubnetChangeProtectionRequest.builder()
                .applyMutation(updateSubnetChangeProtectionRequest).build());
    }

    /**
     * <p>
     * Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS
     * inspection configuration by reference in one or more firewall policies. When you modify a TLS inspection
     * configuration, you modify all firewall policies that use the TLS inspection configuration.
     * </p>
     * <p>
     * To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the
     * current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated
     * object to this call.
     * </p>
     *
     * @param updateTlsInspectionConfigurationRequest
     * @return Result of the UpdateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTlsInspectionConfigurationResponse updateTLSInspectionConfiguration(
            UpdateTlsInspectionConfigurationRequest updateTlsInspectionConfigurationRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS
     * inspection configuration by reference in one or more firewall policies. When you modify a TLS inspection
     * configuration, you modify all firewall policies that use the TLS inspection configuration.
     * </p>
     * <p>
     * To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the
     * current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated
     * object to this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTLSInspectionConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn’t perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTlsInspectionConfigurationResponse updateTLSInspectionConfiguration(
            Consumer<UpdateTlsInspectionConfigurationRequest.Builder> updateTlsInspectionConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        return updateTLSInspectionConfiguration(UpdateTlsInspectionConfigurationRequest.builder()
                .applyMutation(updateTlsInspectionConfigurationRequest).build());
    }

    /**
     * Create a {@link NetworkFirewallClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NetworkFirewallClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NetworkFirewallClient}.
     */
    static NetworkFirewallClientBuilder builder() {
        return new DefaultNetworkFirewallClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default NetworkFirewallServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
