/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration;
import software.amazon.awssdk.services.networkfirewall.model.ResourceStatus;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallPolicyResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallPolicyResponse> {
    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyName").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::firewallPolicyName)).setter(FirewallPolicyResponse.setter(Builder::firewallPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyArn").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::firewallPolicyArn)).setter(FirewallPolicyResponse.setter(Builder::firewallPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyId").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::firewallPolicyId)).setter(FirewallPolicyResponse.setter(Builder::firewallPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::description)).setter(FirewallPolicyResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyStatus").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::firewallPolicyStatusAsString)).setter(FirewallPolicyResponse.setter(Builder::firewallPolicyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyStatus").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::tags)).setter(FirewallPolicyResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CONSUMED_STATELESS_RULE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConsumedStatelessRuleCapacity").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::consumedStatelessRuleCapacity)).setter(FirewallPolicyResponse.setter(Builder::consumedStatelessRuleCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedStatelessRuleCapacity").build()}).build();
    private static final SdkField<Integer> CONSUMED_STATEFUL_RULE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConsumedStatefulRuleCapacity").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::consumedStatefulRuleCapacity)).setter(FirewallPolicyResponse.setter(Builder::consumedStatefulRuleCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedStatefulRuleCapacity").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAssociations").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::numberOfAssociations)).setter(FirewallPolicyResponse.setter(Builder::numberOfAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociations").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::encryptionConfiguration)).setter(FirewallPolicyResponse.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(FirewallPolicyResponse.getter(FirewallPolicyResponse::lastModifiedTime)).setter(FirewallPolicyResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_POLICY_NAME_FIELD, FIREWALL_POLICY_ARN_FIELD, FIREWALL_POLICY_ID_FIELD, DESCRIPTION_FIELD, FIREWALL_POLICY_STATUS_FIELD, TAGS_FIELD, CONSUMED_STATELESS_RULE_CAPACITY_FIELD, CONSUMED_STATEFUL_RULE_CAPACITY_FIELD, NUMBER_OF_ASSOCIATIONS_FIELD, ENCRYPTION_CONFIGURATION_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String firewallPolicyName;
    private final String firewallPolicyArn;
    private final String firewallPolicyId;
    private final String description;
    private final String firewallPolicyStatus;
    private final List<Tag> tags;
    private final Integer consumedStatelessRuleCapacity;
    private final Integer consumedStatefulRuleCapacity;
    private final Integer numberOfAssociations;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Instant lastModifiedTime;

    private FirewallPolicyResponse(BuilderImpl builder) {
        this.firewallPolicyName = builder.firewallPolicyName;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.firewallPolicyId = builder.firewallPolicyId;
        this.description = builder.description;
        this.firewallPolicyStatus = builder.firewallPolicyStatus;
        this.tags = builder.tags;
        this.consumedStatelessRuleCapacity = builder.consumedStatelessRuleCapacity;
        this.consumedStatefulRuleCapacity = builder.consumedStatefulRuleCapacity;
        this.numberOfAssociations = builder.numberOfAssociations;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String firewallPolicyName() {
        return this.firewallPolicyName;
    }

    public final String firewallPolicyArn() {
        return this.firewallPolicyArn;
    }

    public final String firewallPolicyId() {
        return this.firewallPolicyId;
    }

    public final String description() {
        return this.description;
    }

    public final ResourceStatus firewallPolicyStatus() {
        return ResourceStatus.fromValue(this.firewallPolicyStatus);
    }

    public final String firewallPolicyStatusAsString() {
        return this.firewallPolicyStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Integer consumedStatelessRuleCapacity() {
        return this.consumedStatelessRuleCapacity;
    }

    public final Integer consumedStatefulRuleCapacity() {
        return this.consumedStatefulRuleCapacity;
    }

    public final Integer numberOfAssociations() {
        return this.numberOfAssociations;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedStatelessRuleCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedStatefulRuleCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallPolicyResponse)) {
            return false;
        }
        FirewallPolicyResponse other = (FirewallPolicyResponse)obj;
        return Objects.equals(this.firewallPolicyName(), other.firewallPolicyName()) && Objects.equals(this.firewallPolicyArn(), other.firewallPolicyArn()) && Objects.equals(this.firewallPolicyId(), other.firewallPolicyId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.firewallPolicyStatusAsString(), other.firewallPolicyStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.consumedStatelessRuleCapacity(), other.consumedStatelessRuleCapacity()) && Objects.equals(this.consumedStatefulRuleCapacity(), other.consumedStatefulRuleCapacity()) && Objects.equals(this.numberOfAssociations(), other.numberOfAssociations()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallPolicyResponse").add("FirewallPolicyName", (Object)this.firewallPolicyName()).add("FirewallPolicyArn", (Object)this.firewallPolicyArn()).add("FirewallPolicyId", (Object)this.firewallPolicyId()).add("Description", (Object)this.description()).add("FirewallPolicyStatus", (Object)this.firewallPolicyStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ConsumedStatelessRuleCapacity", (Object)this.consumedStatelessRuleCapacity()).add("ConsumedStatefulRuleCapacity", (Object)this.consumedStatefulRuleCapacity()).add("NumberOfAssociations", (Object)this.numberOfAssociations()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallPolicyName": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyName()));
            }
            case "FirewallPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyArn()));
            }
            case "FirewallPolicyId": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FirewallPolicyStatus": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyStatusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConsumedStatelessRuleCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedStatelessRuleCapacity()));
            }
            case "ConsumedStatefulRuleCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedStatefulRuleCapacity()));
            }
            case "NumberOfAssociations": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssociations()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallPolicyResponse, T> g) {
        return obj -> g.apply((FirewallPolicyResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firewallPolicyName;
        private String firewallPolicyArn;
        private String firewallPolicyId;
        private String description;
        private String firewallPolicyStatus;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Integer consumedStatelessRuleCapacity;
        private Integer consumedStatefulRuleCapacity;
        private Integer numberOfAssociations;
        private EncryptionConfiguration encryptionConfiguration;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallPolicyResponse model) {
            this.firewallPolicyName(model.firewallPolicyName);
            this.firewallPolicyArn(model.firewallPolicyArn);
            this.firewallPolicyId(model.firewallPolicyId);
            this.description(model.description);
            this.firewallPolicyStatus(model.firewallPolicyStatus);
            this.tags(model.tags);
            this.consumedStatelessRuleCapacity(model.consumedStatelessRuleCapacity);
            this.consumedStatefulRuleCapacity(model.consumedStatefulRuleCapacity);
            this.numberOfAssociations(model.numberOfAssociations);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getFirewallPolicyName() {
            return this.firewallPolicyName;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        @Override
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return this.firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final String getFirewallPolicyId() {
            return this.firewallPolicyId;
        }

        public final void setFirewallPolicyId(String firewallPolicyId) {
            this.firewallPolicyId = firewallPolicyId;
        }

        @Override
        public final Builder firewallPolicyId(String firewallPolicyId) {
            this.firewallPolicyId = firewallPolicyId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFirewallPolicyStatus() {
            return this.firewallPolicyStatus;
        }

        public final void setFirewallPolicyStatus(String firewallPolicyStatus) {
            this.firewallPolicyStatus = firewallPolicyStatus;
        }

        @Override
        public final Builder firewallPolicyStatus(String firewallPolicyStatus) {
            this.firewallPolicyStatus = firewallPolicyStatus;
            return this;
        }

        @Override
        public final Builder firewallPolicyStatus(ResourceStatus firewallPolicyStatus) {
            this.firewallPolicyStatus(firewallPolicyStatus == null ? null : firewallPolicyStatus.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getConsumedStatelessRuleCapacity() {
            return this.consumedStatelessRuleCapacity;
        }

        public final void setConsumedStatelessRuleCapacity(Integer consumedStatelessRuleCapacity) {
            this.consumedStatelessRuleCapacity = consumedStatelessRuleCapacity;
        }

        @Override
        public final Builder consumedStatelessRuleCapacity(Integer consumedStatelessRuleCapacity) {
            this.consumedStatelessRuleCapacity = consumedStatelessRuleCapacity;
            return this;
        }

        public final Integer getConsumedStatefulRuleCapacity() {
            return this.consumedStatefulRuleCapacity;
        }

        public final void setConsumedStatefulRuleCapacity(Integer consumedStatefulRuleCapacity) {
            this.consumedStatefulRuleCapacity = consumedStatefulRuleCapacity;
        }

        @Override
        public final Builder consumedStatefulRuleCapacity(Integer consumedStatefulRuleCapacity) {
            this.consumedStatefulRuleCapacity = consumedStatefulRuleCapacity;
            return this;
        }

        public final Integer getNumberOfAssociations() {
            return this.numberOfAssociations;
        }

        public final void setNumberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
        }

        @Override
        public final Builder numberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public FirewallPolicyResponse build() {
            return new FirewallPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallPolicyResponse> {
        public Builder firewallPolicyName(String var1);

        public Builder firewallPolicyArn(String var1);

        public Builder firewallPolicyId(String var1);

        public Builder description(String var1);

        public Builder firewallPolicyStatus(String var1);

        public Builder firewallPolicyStatus(ResourceStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder consumedStatelessRuleCapacity(Integer var1);

        public Builder consumedStatefulRuleCapacity(Integer var1);

        public Builder numberOfAssociations(Integer var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder lastModifiedTime(Instant var1);
    }
}

