/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.RuleGroupMetadata;

public class ListRuleGroupsIterable
implements SdkIterable<ListRuleGroupsResponse> {
    private final NetworkFirewallClient client;
    private final ListRuleGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRuleGroupsIterable(NetworkFirewallClient client, ListRuleGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRuleGroupsResponseFetcher();
    }

    public Iterator<ListRuleGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleGroupMetadata> ruleGroups() {
        Function<ListRuleGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleGroups() != null) {
                return response.ruleGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRuleGroupsResponseFetcher
    implements SyncPageFetcher<ListRuleGroupsResponse> {
        private ListRuleGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRuleGroupsResponse nextPage(ListRuleGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListRuleGroupsIterable.this.client.listRuleGroups(ListRuleGroupsIterable.this.firstRequest);
            }
            return ListRuleGroupsIterable.this.client.listRuleGroups((ListRuleGroupsRequest)((Object)ListRuleGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

