/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ServerCertificate;
import software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope;
import software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScopesCopier;
import software.amazon.awssdk.services.networkfirewall.model.ServerCertificatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerCertificateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerCertificateConfiguration> {
    private static final SdkField<List<ServerCertificate>> SERVER_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServerCertificates").getter(ServerCertificateConfiguration.getter(ServerCertificateConfiguration::serverCertificates)).setter(ServerCertificateConfiguration.setter(Builder::serverCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServerCertificateScope>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Scopes").getter(ServerCertificateConfiguration.getter(ServerCertificateConfiguration::scopes)).setter(ServerCertificateConfiguration.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerCertificateScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_CERTIFICATES_FIELD, SCOPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ServerCertificate> serverCertificates;
    private final List<ServerCertificateScope> scopes;

    private ServerCertificateConfiguration(BuilderImpl builder) {
        this.serverCertificates = builder.serverCertificates;
        this.scopes = builder.scopes;
    }

    public final boolean hasServerCertificates() {
        return this.serverCertificates != null && !(this.serverCertificates instanceof SdkAutoConstructList);
    }

    public final List<ServerCertificate> serverCertificates() {
        return this.serverCertificates;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public final List<ServerCertificateScope> scopes() {
        return this.scopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerCertificates() ? this.serverCertificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateConfiguration)) {
            return false;
        }
        ServerCertificateConfiguration other = (ServerCertificateConfiguration)obj;
        return this.hasServerCertificates() == other.hasServerCertificates() && Objects.equals(this.serverCertificates(), other.serverCertificates()) && this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes());
    }

    public final String toString() {
        return ToString.builder((String)"ServerCertificateConfiguration").add("ServerCertificates", this.hasServerCertificates() ? this.serverCertificates() : null).add("Scopes", this.hasScopes() ? this.scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerCertificates": {
                return Optional.ofNullable(clazz.cast(this.serverCertificates()));
            }
            case "Scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerCertificateConfiguration, T> g) {
        return obj -> g.apply((ServerCertificateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ServerCertificate> serverCertificates = DefaultSdkAutoConstructList.getInstance();
        private List<ServerCertificateScope> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificateConfiguration model) {
            this.serverCertificates(model.serverCertificates);
            this.scopes(model.scopes);
        }

        public final List<ServerCertificate.Builder> getServerCertificates() {
            List<ServerCertificate.Builder> result = ServerCertificatesCopier.copyToBuilder(this.serverCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerCertificates(Collection<ServerCertificate.BuilderImpl> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copyFromBuilder(serverCertificates);
        }

        @Override
        public final Builder serverCertificates(Collection<ServerCertificate> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copy(serverCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(ServerCertificate ... serverCertificates) {
            this.serverCertificates(Arrays.asList(serverCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(Consumer<ServerCertificate.Builder> ... serverCertificates) {
            this.serverCertificates(Stream.of(serverCertificates).map(c -> (ServerCertificate)((ServerCertificate.Builder)ServerCertificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServerCertificateScope.Builder> getScopes() {
            List<ServerCertificateScope.Builder> result = ServerCertificateScopesCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<ServerCertificateScope.BuilderImpl> scopes) {
            this.scopes = ServerCertificateScopesCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Collection<ServerCertificateScope> scopes) {
            this.scopes = ServerCertificateScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(ServerCertificateScope ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<ServerCertificateScope.Builder> ... scopes) {
            this.scopes(Stream.of(scopes).map(c -> (ServerCertificateScope)((ServerCertificateScope.Builder)ServerCertificateScope.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServerCertificateConfiguration build() {
            return new ServerCertificateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerCertificateConfiguration> {
        public Builder serverCertificates(Collection<ServerCertificate> var1);

        public Builder serverCertificates(ServerCertificate ... var1);

        public Builder serverCertificates(Consumer<ServerCertificate.Builder> ... var1);

        public Builder scopes(Collection<ServerCertificateScope> var1);

        public Builder scopes(ServerCertificateScope ... var1);

        public Builder scopes(Consumer<ServerCertificateScope.Builder> ... var1);
    }
}

