/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyMetadata;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;

public class ListFirewallPoliciesIterable
implements SdkIterable<ListFirewallPoliciesResponse> {
    private final NetworkFirewallClient client;
    private final ListFirewallPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFirewallPoliciesIterable(NetworkFirewallClient client, ListFirewallPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFirewallPoliciesResponseFetcher();
    }

    public Iterator<ListFirewallPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FirewallPolicyMetadata> firewallPolicies() {
        Function<ListFirewallPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallPolicies() != null) {
                return response.firewallPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFirewallPoliciesResponseFetcher
    implements SyncPageFetcher<ListFirewallPoliciesResponse> {
        private ListFirewallPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFirewallPoliciesResponse nextPage(ListFirewallPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallPoliciesIterable.this.client.listFirewallPolicies(ListFirewallPoliciesIterable.this.firstRequest);
            }
            return ListFirewallPoliciesIterable.this.client.listFirewallPolicies((ListFirewallPoliciesRequest)((Object)ListFirewallPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

