/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.ConfigurationSyncState;
import software.amazon.awssdk.services.networkfirewall.model.FirewallStatusValue;
import software.amazon.awssdk.services.networkfirewall.model.SyncState;
import software.amazon.awssdk.services.networkfirewall.model.SyncStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FirewallStatus.getter(FirewallStatus::statusAsString)).setter(FirewallStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CONFIGURATION_SYNC_STATE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSyncStateSummary").getter(FirewallStatus.getter(FirewallStatus::configurationSyncStateSummaryAsString)).setter(FirewallStatus.setter(Builder::configurationSyncStateSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSyncStateSummary").build()}).build();
    private static final SdkField<Map<String, SyncState>> SYNC_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SyncStates").getter(FirewallStatus.getter(FirewallStatus::syncStates)).setter(FirewallStatus.setter(Builder::syncStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncStates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SyncState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CONFIGURATION_SYNC_STATE_SUMMARY_FIELD, SYNC_STATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String configurationSyncStateSummary;
    private final Map<String, SyncState> syncStates;

    private FirewallStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.configurationSyncStateSummary = builder.configurationSyncStateSummary;
        this.syncStates = builder.syncStates;
    }

    public final FirewallStatusValue status() {
        return FirewallStatusValue.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ConfigurationSyncState configurationSyncStateSummary() {
        return ConfigurationSyncState.fromValue(this.configurationSyncStateSummary);
    }

    public final String configurationSyncStateSummaryAsString() {
        return this.configurationSyncStateSummary;
    }

    public final boolean hasSyncStates() {
        return this.syncStates != null && !(this.syncStates instanceof SdkAutoConstructMap);
    }

    public final Map<String, SyncState> syncStates() {
        return this.syncStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSyncStateSummaryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSyncStates() ? this.syncStates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallStatus)) {
            return false;
        }
        FirewallStatus other = (FirewallStatus)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.configurationSyncStateSummaryAsString(), other.configurationSyncStateSummaryAsString()) && this.hasSyncStates() == other.hasSyncStates() && Objects.equals(this.syncStates(), other.syncStates());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallStatus").add("Status", (Object)this.statusAsString()).add("ConfigurationSyncStateSummary", (Object)this.configurationSyncStateSummaryAsString()).add("SyncStates", this.hasSyncStates() ? this.syncStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ConfigurationSyncStateSummary": {
                return Optional.ofNullable(clazz.cast(this.configurationSyncStateSummaryAsString()));
            }
            case "SyncStates": {
                return Optional.ofNullable(clazz.cast(this.syncStates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallStatus, T> g) {
        return obj -> g.apply((FirewallStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String configurationSyncStateSummary;
        private Map<String, SyncState> syncStates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallStatus model) {
            this.status(model.status);
            this.configurationSyncStateSummary(model.configurationSyncStateSummary);
            this.syncStates(model.syncStates);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getConfigurationSyncStateSummary() {
            return this.configurationSyncStateSummary;
        }

        public final void setConfigurationSyncStateSummary(String configurationSyncStateSummary) {
            this.configurationSyncStateSummary = configurationSyncStateSummary;
        }

        @Override
        public final Builder configurationSyncStateSummary(String configurationSyncStateSummary) {
            this.configurationSyncStateSummary = configurationSyncStateSummary;
            return this;
        }

        @Override
        public final Builder configurationSyncStateSummary(ConfigurationSyncState configurationSyncStateSummary) {
            this.configurationSyncStateSummary(configurationSyncStateSummary == null ? null : configurationSyncStateSummary.toString());
            return this;
        }

        public final Map<String, SyncState.Builder> getSyncStates() {
            Map<String, SyncState.Builder> result = SyncStatesCopier.copyToBuilder(this.syncStates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSyncStates(Map<String, SyncState.BuilderImpl> syncStates) {
            this.syncStates = SyncStatesCopier.copyFromBuilder(syncStates);
        }

        @Override
        public final Builder syncStates(Map<String, SyncState> syncStates) {
            this.syncStates = SyncStatesCopier.copy(syncStates);
            return this;
        }

        public FirewallStatus build() {
            return new FirewallStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallStatus> {
        public Builder status(String var1);

        public Builder status(FirewallStatusValue var1);

        public Builder configurationSyncStateSummary(String var1);

        public Builder configurationSyncStateSummary(ConfigurationSyncState var1);

        public Builder syncStates(Map<String, SyncState> var1);
    }
}

