/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.ForkedDefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.ForkedHttp2MultiplexCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.util.internal.ObjectUtil;

public class ForkedHttp2MultiplexCodecBuilder
extends AbstractHttp2ConnectionHandlerBuilder<ForkedHttp2MultiplexCodec, ForkedHttp2MultiplexCodecBuilder> {
    final ChannelHandler childHandler;

    ForkedHttp2MultiplexCodecBuilder(boolean server, ChannelHandler childHandler) {
        this.server(server);
        this.childHandler = ForkedHttp2MultiplexCodecBuilder.checkSharable((ChannelHandler)ObjectUtil.checkNotNull((Object)childHandler, (String)"childHandler"));
    }

    private static ChannelHandler checkSharable(ChannelHandler handler) {
        if (handler instanceof ChannelHandlerAdapter && !((ChannelHandlerAdapter)handler).isSharable() && !handler.getClass().isAnnotationPresent(ChannelHandler.Sharable.class)) {
            throw new IllegalArgumentException("The handler must be Sharable");
        }
        return handler;
    }

    public static ForkedHttp2MultiplexCodecBuilder forClient(ChannelHandler childHandler) {
        return new ForkedHttp2MultiplexCodecBuilder(false, childHandler);
    }

    public static ForkedHttp2MultiplexCodecBuilder forServer(ChannelHandler childHandler) {
        return new ForkedHttp2MultiplexCodecBuilder(true, childHandler);
    }

    public Http2Settings initialSettings() {
        return super.initialSettings();
    }

    public ForkedHttp2MultiplexCodecBuilder initialSettings(Http2Settings settings) {
        return (ForkedHttp2MultiplexCodecBuilder)super.initialSettings(settings);
    }

    public long gracefulShutdownTimeoutMillis() {
        return super.gracefulShutdownTimeoutMillis();
    }

    public ForkedHttp2MultiplexCodecBuilder gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        return (ForkedHttp2MultiplexCodecBuilder)super.gracefulShutdownTimeoutMillis(gracefulShutdownTimeoutMillis);
    }

    public boolean isServer() {
        return super.isServer();
    }

    public int maxReservedStreams() {
        return super.maxReservedStreams();
    }

    public ForkedHttp2MultiplexCodecBuilder maxReservedStreams(int maxReservedStreams) {
        return (ForkedHttp2MultiplexCodecBuilder)super.maxReservedStreams(maxReservedStreams);
    }

    public boolean isValidateHeaders() {
        return super.isValidateHeaders();
    }

    public ForkedHttp2MultiplexCodecBuilder validateHeaders(boolean validateHeaders) {
        return (ForkedHttp2MultiplexCodecBuilder)super.validateHeaders(validateHeaders);
    }

    public Http2FrameLogger frameLogger() {
        return super.frameLogger();
    }

    public ForkedHttp2MultiplexCodecBuilder frameLogger(Http2FrameLogger frameLogger) {
        return (ForkedHttp2MultiplexCodecBuilder)super.frameLogger(frameLogger);
    }

    public boolean encoderEnforceMaxConcurrentStreams() {
        return super.encoderEnforceMaxConcurrentStreams();
    }

    public ForkedHttp2MultiplexCodecBuilder encoderEnforceMaxConcurrentStreams(boolean encoderEnforceMaxConcurrentStreams) {
        return (ForkedHttp2MultiplexCodecBuilder)super.encoderEnforceMaxConcurrentStreams(encoderEnforceMaxConcurrentStreams);
    }

    public Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector() {
        return super.headerSensitivityDetector();
    }

    public ForkedHttp2MultiplexCodecBuilder headerSensitivityDetector(Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector) {
        return (ForkedHttp2MultiplexCodecBuilder)super.headerSensitivityDetector(headerSensitivityDetector);
    }

    public ForkedHttp2MultiplexCodecBuilder encoderIgnoreMaxHeaderListSize(boolean ignoreMaxHeaderListSize) {
        return (ForkedHttp2MultiplexCodecBuilder)super.encoderIgnoreMaxHeaderListSize(ignoreMaxHeaderListSize);
    }

    public ForkedHttp2MultiplexCodecBuilder initialHuffmanDecodeCapacity(int initialHuffmanDecodeCapacity) {
        return (ForkedHttp2MultiplexCodecBuilder)super.initialHuffmanDecodeCapacity(initialHuffmanDecodeCapacity);
    }

    public ForkedHttp2MultiplexCodec build() {
        Http2Connection connection = this.connection();
        if (connection == null) {
            connection = new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams());
        }
        return this.buildFromConnection(connection);
    }

    private ForkedHttp2MultiplexCodec buildFromConnection(Http2Connection connection) {
        Long maxHeaderListSize = this.initialSettings().maxHeaderListSize();
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader((Http2HeadersDecoder)new DefaultHttp2HeadersDecoder(this.isValidateHeaders(), 8192L, 32));
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter(this.headerSensitivityDetector());
        if (this.frameLogger() != null) {
            reader = new Http2InboundFrameLogger((Http2FrameReader)reader, this.frameLogger());
            writer = new Http2OutboundFrameLogger((Http2FrameWriter)writer, this.frameLogger());
        }
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder(connection, (Http2FrameWriter)writer);
        boolean encoderEnforceMaxConcurrentStreams = this.encoderEnforceMaxConcurrentStreams();
        if (encoderEnforceMaxConcurrentStreams) {
            if (connection.isServer()) {
                encoder.close();
                reader.close();
                throw new IllegalArgumentException("encoderEnforceMaxConcurrentStreams: " + encoderEnforceMaxConcurrentStreams + " not supported for server");
            }
            encoder = new StreamBufferingEncoder((Http2ConnectionEncoder)encoder);
        }
        ForkedDefaultHttp2ConnectionDecoder decoder = new ForkedDefaultHttp2ConnectionDecoder(connection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader);
        return this.buildFromCodec(decoder, (Http2ConnectionEncoder)encoder);
    }

    private ForkedHttp2MultiplexCodec buildFromCodec(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder) {
        ForkedHttp2MultiplexCodec handler;
        try {
            handler = this.build(decoder, encoder, this.initialSettings());
        }
        catch (Throwable var5) {
            encoder.close();
            decoder.close();
            throw new IllegalStateException("failed to build a Http2ConnectionHandler", var5);
        }
        handler.gracefulShutdownTimeoutMillis(this.gracefulShutdownTimeoutMillis());
        if (handler.decoder().frameListener() == null) {
            handler.decoder().frameListener(this.frameListener());
        }
        return handler;
    }

    protected ForkedHttp2MultiplexCodec build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        return new ForkedHttp2MultiplexCodec(encoder, decoder, initialSettings, this.childHandler);
    }
}

