/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMlModelTrainingJobRequest extends NeptunedataRequest implements
        ToCopyableBuilder<StartMlModelTrainingJobRequest.Builder, StartMlModelTrainingJobRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(StartMlModelTrainingJobRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PREVIOUS_MODEL_TRAINING_JOB_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("previousModelTrainingJobId")
            .getter(getter(StartMlModelTrainingJobRequest::previousModelTrainingJobId))
            .setter(setter(Builder::previousModelTrainingJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousModelTrainingJobId").build())
            .build();

    private static final SdkField<String> DATA_PROCESSING_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataProcessingJobId").getter(getter(StartMlModelTrainingJobRequest::dataProcessingJobId))
            .setter(setter(Builder::dataProcessingJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProcessingJobId").build())
            .build();

    private static final SdkField<String> TRAIN_MODEL_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainModelS3Location").getter(getter(StartMlModelTrainingJobRequest::trainModelS3Location))
            .setter(setter(Builder::trainModelS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainModelS3Location").build())
            .build();

    private static final SdkField<String> SAGEMAKER_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sagemakerIamRoleArn").getter(getter(StartMlModelTrainingJobRequest::sagemakerIamRoleArn))
            .setter(setter(Builder::sagemakerIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sagemakerIamRoleArn").build())
            .build();

    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("neptuneIamRoleArn").getter(getter(StartMlModelTrainingJobRequest::neptuneIamRoleArn))
            .setter(setter(Builder::neptuneIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptuneIamRoleArn").build()).build();

    private static final SdkField<String> BASE_PROCESSING_INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("baseProcessingInstanceType")
            .getter(getter(StartMlModelTrainingJobRequest::baseProcessingInstanceType))
            .setter(setter(Builder::baseProcessingInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseProcessingInstanceType").build())
            .build();

    private static final SdkField<String> TRAINING_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingInstanceType").getter(getter(StartMlModelTrainingJobRequest::trainingInstanceType))
            .setter(setter(Builder::trainingInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingInstanceType").build())
            .build();

    private static final SdkField<Integer> TRAINING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("trainingInstanceVolumeSizeInGB")
            .getter(getter(StartMlModelTrainingJobRequest::trainingInstanceVolumeSizeInGB))
            .setter(setter(Builder::trainingInstanceVolumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingInstanceVolumeSizeInGB")
                    .build()).build();

    private static final SdkField<Integer> TRAINING_TIME_OUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("trainingTimeOutInSeconds")
            .getter(getter(StartMlModelTrainingJobRequest::trainingTimeOutInSeconds))
            .setter(setter(Builder::trainingTimeOutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingTimeOutInSeconds").build())
            .build();

    private static final SdkField<Integer> MAX_HPO_NUMBER_OF_TRAINING_JOBS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxHPONumberOfTrainingJobs")
            .getter(getter(StartMlModelTrainingJobRequest::maxHPONumberOfTrainingJobs))
            .setter(setter(Builder::maxHPONumberOfTrainingJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxHPONumberOfTrainingJobs").build())
            .build();

    private static final SdkField<Integer> MAX_HPO_PARALLEL_TRAINING_JOBS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxHPOParallelTrainingJobs")
            .getter(getter(StartMlModelTrainingJobRequest::maxHPOParallelTrainingJobs))
            .setter(setter(Builder::maxHPOParallelTrainingJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxHPOParallelTrainingJobs").build())
            .build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(StartMlModelTrainingJobRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(StartMlModelTrainingJobRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOLUME_ENCRYPTION_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeEncryptionKMSKey").getter(getter(StartMlModelTrainingJobRequest::volumeEncryptionKMSKey))
            .setter(setter(Builder::volumeEncryptionKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeEncryptionKMSKey").build())
            .build();

    private static final SdkField<String> S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3OutputEncryptionKMSKey").getter(getter(StartMlModelTrainingJobRequest::s3OutputEncryptionKMSKey))
            .setter(setter(Builder::s3OutputEncryptionKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputEncryptionKMSKey").build())
            .build();

    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableManagedSpotTraining")
            .getter(getter(StartMlModelTrainingJobRequest::enableManagedSpotTraining))
            .setter(setter(Builder::enableManagedSpotTraining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableManagedSpotTraining").build())
            .build();

    private static final SdkField<CustomModelTrainingParameters> CUSTOM_MODEL_TRAINING_PARAMETERS_FIELD = SdkField
            .<CustomModelTrainingParameters> builder(MarshallingType.SDK_POJO)
            .memberName("customModelTrainingParameters")
            .getter(getter(StartMlModelTrainingJobRequest::customModelTrainingParameters))
            .setter(setter(Builder::customModelTrainingParameters))
            .constructor(CustomModelTrainingParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelTrainingParameters")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PREVIOUS_MODEL_TRAINING_JOB_ID_FIELD, DATA_PROCESSING_JOB_ID_FIELD, TRAIN_MODEL_S3_LOCATION_FIELD,
            SAGEMAKER_IAM_ROLE_ARN_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD, BASE_PROCESSING_INSTANCE_TYPE_FIELD,
            TRAINING_INSTANCE_TYPE_FIELD, TRAINING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD, TRAINING_TIME_OUT_IN_SECONDS_FIELD,
            MAX_HPO_NUMBER_OF_TRAINING_JOBS_FIELD, MAX_HPO_PARALLEL_TRAINING_JOBS_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD,
            VOLUME_ENCRYPTION_KMS_KEY_FIELD, S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD, ENABLE_MANAGED_SPOT_TRAINING_FIELD,
            CUSTOM_MODEL_TRAINING_PARAMETERS_FIELD));

    private final String id;

    private final String previousModelTrainingJobId;

    private final String dataProcessingJobId;

    private final String trainModelS3Location;

    private final String sagemakerIamRoleArn;

    private final String neptuneIamRoleArn;

    private final String baseProcessingInstanceType;

    private final String trainingInstanceType;

    private final Integer trainingInstanceVolumeSizeInGB;

    private final Integer trainingTimeOutInSeconds;

    private final Integer maxHPONumberOfTrainingJobs;

    private final Integer maxHPOParallelTrainingJobs;

    private final List<String> subnets;

    private final List<String> securityGroupIds;

    private final String volumeEncryptionKMSKey;

    private final String s3OutputEncryptionKMSKey;

    private final Boolean enableManagedSpotTraining;

    private final CustomModelTrainingParameters customModelTrainingParameters;

    private StartMlModelTrainingJobRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.previousModelTrainingJobId = builder.previousModelTrainingJobId;
        this.dataProcessingJobId = builder.dataProcessingJobId;
        this.trainModelS3Location = builder.trainModelS3Location;
        this.sagemakerIamRoleArn = builder.sagemakerIamRoleArn;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.baseProcessingInstanceType = builder.baseProcessingInstanceType;
        this.trainingInstanceType = builder.trainingInstanceType;
        this.trainingInstanceVolumeSizeInGB = builder.trainingInstanceVolumeSizeInGB;
        this.trainingTimeOutInSeconds = builder.trainingTimeOutInSeconds;
        this.maxHPONumberOfTrainingJobs = builder.maxHPONumberOfTrainingJobs;
        this.maxHPOParallelTrainingJobs = builder.maxHPOParallelTrainingJobs;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.volumeEncryptionKMSKey = builder.volumeEncryptionKMSKey;
        this.s3OutputEncryptionKMSKey = builder.s3OutputEncryptionKMSKey;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.customModelTrainingParameters = builder.customModelTrainingParameters;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is An autogenerated UUID.
     * </p>
     * 
     * @return A unique identifier for the new job. The default is An autogenerated UUID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The job ID of a completed model-training job that you want to update incrementally based on updated data.
     * </p>
     * 
     * @return The job ID of a completed model-training job that you want to update incrementally based on updated data.
     */
    public final String previousModelTrainingJobId() {
        return previousModelTrainingJobId;
    }

    /**
     * <p>
     * The job ID of the completed data-processing job that has created the data that the training will work with.
     * </p>
     * 
     * @return The job ID of the completed data-processing job that has created the data that the training will work
     *         with.
     */
    public final String dataProcessingJobId() {
        return dataProcessingJobId;
    }

    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     * 
     * @return The location in Amazon S3 where the model artifacts are to be stored.
     */
    public final String trainModelS3Location() {
        return trainModelS3Location;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or an error
     * will occur.
     * </p>
     * 
     * @return The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or
     *         an error will occur.
     */
    public final String sagemakerIamRoleArn() {
        return sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *         listed in your DB cluster parameter group or an error will occur.
     */
    public final String neptuneIamRoleArn() {
        return neptuneIamRoleArn;
    }

    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is a CPU instance chosen based
     * on memory requirements for processing the training data and model.
     * </p>
     * 
     * @return The type of ML instance used in preparing and managing training of ML models. This is a CPU instance
     *         chosen based on memory requirements for processing the training data and model.
     */
    public final String baseProcessingInstanceType() {
        return baseProcessingInstanceType;
    }

    /**
     * <p>
     * The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU training.
     * The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends on the task
     * type, graph size, and your budget.
     * </p>
     * 
     * @return The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU
     *         training. The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training
     *         depends on the task type, graph size, and your budget.
     */
    public final String trainingInstanceType() {
        return trainingInstanceType;
    }

    /**
     * <p>
     * The disk volume size of the training instance. Both input data and the output model are stored on disk, so the
     * volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML
     * selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     * 
     * @return The disk volume size of the training instance. Both input data and the output model are stored on disk,
     *         so the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0,
     *         Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     */
    public final Integer trainingInstanceVolumeSizeInGB() {
        return trainingInstanceVolumeSizeInGB;
    }

    /**
     * <p>
     * Timeout in seconds for the training job. The default is 86,400 (1 day).
     * </p>
     * 
     * @return Timeout in seconds for the training job. The default is 86,400 (1 day).
     */
    public final Integer trainingTimeOutInSeconds() {
        return trainingTimeOutInSeconds;
    }

    /**
     * <p>
     * Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2. Neptune ML
     * automatically tunes the hyperparameters of the machine learning model. To obtain a model that performs well, use
     * at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10). In general, the more tuning
     * runs, the better the results.
     * </p>
     * 
     * @return Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2.
     *         Neptune ML automatically tunes the hyperparameters of the machine learning model. To obtain a model that
     *         performs well, use at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10).
     *         In general, the more tuning runs, the better the results.
     */
    public final Integer maxHPONumberOfTrainingJobs() {
        return maxHPONumberOfTrainingJobs;
    }

    /**
     * <p>
     * Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The number
     * of parallel jobs you can run is limited by the available resources on your training instance.
     * </p>
     * 
     * @return Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2.
     *         The number of parallel jobs you can run is limited by the available resources on your training instance.
     */
    public final Integer maxHPOParallelTrainingJobs() {
        return maxHPOParallelTrainingJobs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The IDs of the subnets in the Neptune VPC. The default is None.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The VPC security group IDs. The default is None.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @return The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
     *         attached to the ML compute instances that run the training job. The default is None.
     */
    public final String volumeEncryptionKMSKey() {
        return volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     * 
     * @return The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing
     *         job. The default is none.
     */
    public final String s3OutputEncryptionKMSKey() {
        return s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot instances. The
     * default is <code>False</code>.
     * </p>
     * 
     * @return Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot
     *         instances. The default is <code>False</code>.
     */
    public final Boolean enableManagedSpotTraining() {
        return enableManagedSpotTraining;
    }

    /**
     * <p>
     * The configuration for custom model training. This is a JSON object.
     * </p>
     * 
     * @return The configuration for custom model training. This is a JSON object.
     */
    public final CustomModelTrainingParameters customModelTrainingParameters() {
        return customModelTrainingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(previousModelTrainingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(dataProcessingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(trainModelS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(sagemakerIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(baseProcessingInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(trainingInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(trainingInstanceVolumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(trainingTimeOutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maxHPONumberOfTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(maxHPOParallelTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(volumeEncryptionKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputEncryptionKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(customModelTrainingParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlModelTrainingJobRequest)) {
            return false;
        }
        StartMlModelTrainingJobRequest other = (StartMlModelTrainingJobRequest) obj;
        return Objects.equals(id(), other.id())
                && Objects.equals(previousModelTrainingJobId(), other.previousModelTrainingJobId())
                && Objects.equals(dataProcessingJobId(), other.dataProcessingJobId())
                && Objects.equals(trainModelS3Location(), other.trainModelS3Location())
                && Objects.equals(sagemakerIamRoleArn(), other.sagemakerIamRoleArn())
                && Objects.equals(neptuneIamRoleArn(), other.neptuneIamRoleArn())
                && Objects.equals(baseProcessingInstanceType(), other.baseProcessingInstanceType())
                && Objects.equals(trainingInstanceType(), other.trainingInstanceType())
                && Objects.equals(trainingInstanceVolumeSizeInGB(), other.trainingInstanceVolumeSizeInGB())
                && Objects.equals(trainingTimeOutInSeconds(), other.trainingTimeOutInSeconds())
                && Objects.equals(maxHPONumberOfTrainingJobs(), other.maxHPONumberOfTrainingJobs())
                && Objects.equals(maxHPOParallelTrainingJobs(), other.maxHPOParallelTrainingJobs())
                && hasSubnets() == other.hasSubnets() && Objects.equals(subnets(), other.subnets())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(volumeEncryptionKMSKey(), other.volumeEncryptionKMSKey())
                && Objects.equals(s3OutputEncryptionKMSKey(), other.s3OutputEncryptionKMSKey())
                && Objects.equals(enableManagedSpotTraining(), other.enableManagedSpotTraining())
                && Objects.equals(customModelTrainingParameters(), other.customModelTrainingParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMlModelTrainingJobRequest").add("Id", id())
                .add("PreviousModelTrainingJobId", previousModelTrainingJobId())
                .add("DataProcessingJobId", dataProcessingJobId()).add("TrainModelS3Location", trainModelS3Location())
                .add("SagemakerIamRoleArn", sagemakerIamRoleArn()).add("NeptuneIamRoleArn", neptuneIamRoleArn())
                .add("BaseProcessingInstanceType", baseProcessingInstanceType())
                .add("TrainingInstanceType", trainingInstanceType())
                .add("TrainingInstanceVolumeSizeInGB", trainingInstanceVolumeSizeInGB())
                .add("TrainingTimeOutInSeconds", trainingTimeOutInSeconds())
                .add("MaxHPONumberOfTrainingJobs", maxHPONumberOfTrainingJobs())
                .add("MaxHPOParallelTrainingJobs", maxHPOParallelTrainingJobs()).add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("VolumeEncryptionKMSKey", volumeEncryptionKMSKey())
                .add("S3OutputEncryptionKMSKey", s3OutputEncryptionKMSKey())
                .add("EnableManagedSpotTraining", enableManagedSpotTraining())
                .add("CustomModelTrainingParameters", customModelTrainingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "previousModelTrainingJobId":
            return Optional.ofNullable(clazz.cast(previousModelTrainingJobId()));
        case "dataProcessingJobId":
            return Optional.ofNullable(clazz.cast(dataProcessingJobId()));
        case "trainModelS3Location":
            return Optional.ofNullable(clazz.cast(trainModelS3Location()));
        case "sagemakerIamRoleArn":
            return Optional.ofNullable(clazz.cast(sagemakerIamRoleArn()));
        case "neptuneIamRoleArn":
            return Optional.ofNullable(clazz.cast(neptuneIamRoleArn()));
        case "baseProcessingInstanceType":
            return Optional.ofNullable(clazz.cast(baseProcessingInstanceType()));
        case "trainingInstanceType":
            return Optional.ofNullable(clazz.cast(trainingInstanceType()));
        case "trainingInstanceVolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(trainingInstanceVolumeSizeInGB()));
        case "trainingTimeOutInSeconds":
            return Optional.ofNullable(clazz.cast(trainingTimeOutInSeconds()));
        case "maxHPONumberOfTrainingJobs":
            return Optional.ofNullable(clazz.cast(maxHPONumberOfTrainingJobs()));
        case "maxHPOParallelTrainingJobs":
            return Optional.ofNullable(clazz.cast(maxHPOParallelTrainingJobs()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "volumeEncryptionKMSKey":
            return Optional.ofNullable(clazz.cast(volumeEncryptionKMSKey()));
        case "s3OutputEncryptionKMSKey":
            return Optional.ofNullable(clazz.cast(s3OutputEncryptionKMSKey()));
        case "enableManagedSpotTraining":
            return Optional.ofNullable(clazz.cast(enableManagedSpotTraining()));
        case "customModelTrainingParameters":
            return Optional.ofNullable(clazz.cast(customModelTrainingParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMlModelTrainingJobRequest, T> g) {
        return obj -> g.apply((StartMlModelTrainingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMlModelTrainingJobRequest> {
        /**
         * <p>
         * A unique identifier for the new job. The default is An autogenerated UUID.
         * </p>
         * 
         * @param id
         *        A unique identifier for the new job. The default is An autogenerated UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The job ID of a completed model-training job that you want to update incrementally based on updated data.
         * </p>
         * 
         * @param previousModelTrainingJobId
         *        The job ID of a completed model-training job that you want to update incrementally based on updated
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousModelTrainingJobId(String previousModelTrainingJobId);

        /**
         * <p>
         * The job ID of the completed data-processing job that has created the data that the training will work with.
         * </p>
         * 
         * @param dataProcessingJobId
         *        The job ID of the completed data-processing job that has created the data that the training will work
         *        with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProcessingJobId(String dataProcessingJobId);

        /**
         * <p>
         * The location in Amazon S3 where the model artifacts are to be stored.
         * </p>
         * 
         * @param trainModelS3Location
         *        The location in Amazon S3 where the model artifacts are to be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainModelS3Location(String trainModelS3Location);

        /**
         * <p>
         * The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or an
         * error will occur.
         * </p>
         * 
         * @param sagemakerIamRoleArn
         *        The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group
         *        or an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sagemakerIamRoleArn(String sagemakerIamRoleArn);

        /**
         * <p>
         * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed
         * in your DB cluster parameter group or an error will occur.
         * </p>
         * 
         * @param neptuneIamRoleArn
         *        The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
         *        listed in your DB cluster parameter group or an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neptuneIamRoleArn(String neptuneIamRoleArn);

        /**
         * <p>
         * The type of ML instance used in preparing and managing training of ML models. This is a CPU instance chosen
         * based on memory requirements for processing the training data and model.
         * </p>
         * 
         * @param baseProcessingInstanceType
         *        The type of ML instance used in preparing and managing training of ML models. This is a CPU instance
         *        chosen based on memory requirements for processing the training data and model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseProcessingInstanceType(String baseProcessingInstanceType);

        /**
         * <p>
         * The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU
         * training. The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends on
         * the task type, graph size, and your budget.
         * </p>
         * 
         * @param trainingInstanceType
         *        The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU
         *        training. The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training
         *        depends on the task type, graph size, and your budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingInstanceType(String trainingInstanceType);

        /**
         * <p>
         * The disk volume size of the training instance. Both input data and the output model are stored on disk, so
         * the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune
         * ML selects a disk volume size based on the recommendation generated in the data processing step.
         * </p>
         * 
         * @param trainingInstanceVolumeSizeInGB
         *        The disk volume size of the training instance. Both input data and the output model are stored on
         *        disk, so the volume size must be large enough to hold both data sets. The default is 0. If not
         *        specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the
         *        data processing step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingInstanceVolumeSizeInGB(Integer trainingInstanceVolumeSizeInGB);

        /**
         * <p>
         * Timeout in seconds for the training job. The default is 86,400 (1 day).
         * </p>
         * 
         * @param trainingTimeOutInSeconds
         *        Timeout in seconds for the training job. The default is 86,400 (1 day).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingTimeOutInSeconds(Integer trainingTimeOutInSeconds);

        /**
         * <p>
         * Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2. Neptune
         * ML automatically tunes the hyperparameters of the machine learning model. To obtain a model that performs
         * well, use at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10). In general,
         * the more tuning runs, the better the results.
         * </p>
         * 
         * @param maxHPONumberOfTrainingJobs
         *        Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2.
         *        Neptune ML automatically tunes the hyperparameters of the machine learning model. To obtain a model
         *        that performs well, use at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code>
         *        to 10). In general, the more tuning runs, the better the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHPONumberOfTrainingJobs(Integer maxHPONumberOfTrainingJobs);

        /**
         * <p>
         * Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The
         * number of parallel jobs you can run is limited by the available resources on your training instance.
         * </p>
         * 
         * @param maxHPOParallelTrainingJobs
         *        Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2.
         *        The number of parallel jobs you can run is limited by the available resources on your training
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHPOParallelTrainingJobs(Integer maxHPOParallelTrainingJobs);

        /**
         * <p>
         * The IDs of the subnets in the Neptune VPC. The default is None.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets in the Neptune VPC. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the subnets in the Neptune VPC. The default is None.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets in the Neptune VPC. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The VPC security group IDs. The default is None.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The VPC security group IDs. The default is None.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
         * attached to the ML compute instances that run the training job. The default is None.
         * </p>
         * 
         * @param volumeEncryptionKMSKey
         *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
         *        attached to the ML compute instances that run the training job. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey);

        /**
         * <p>
         * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job.
         * The default is none.
         * </p>
         * 
         * @param s3OutputEncryptionKMSKey
         *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the
         *        processing job. The default is none.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey);

        /**
         * <p>
         * Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot instances.
         * The default is <code>False</code>.
         * </p>
         * 
         * @param enableManagedSpotTraining
         *        Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot
         *        instances. The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining);

        /**
         * <p>
         * The configuration for custom model training. This is a JSON object.
         * </p>
         * 
         * @param customModelTrainingParameters
         *        The configuration for custom model training. This is a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelTrainingParameters(CustomModelTrainingParameters customModelTrainingParameters);

        /**
         * <p>
         * The configuration for custom model training. This is a JSON object.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomModelTrainingParameters.Builder}
         * avoiding the need to create one manually via {@link CustomModelTrainingParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomModelTrainingParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #customModelTrainingParameters(CustomModelTrainingParameters)}.
         * 
         * @param customModelTrainingParameters
         *        a consumer that will call methods on {@link CustomModelTrainingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customModelTrainingParameters(CustomModelTrainingParameters)
         */
        default Builder customModelTrainingParameters(
                Consumer<CustomModelTrainingParameters.Builder> customModelTrainingParameters) {
            return customModelTrainingParameters(CustomModelTrainingParameters.builder()
                    .applyMutation(customModelTrainingParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String id;

        private String previousModelTrainingJobId;

        private String dataProcessingJobId;

        private String trainModelS3Location;

        private String sagemakerIamRoleArn;

        private String neptuneIamRoleArn;

        private String baseProcessingInstanceType;

        private String trainingInstanceType;

        private Integer trainingInstanceVolumeSizeInGB;

        private Integer trainingTimeOutInSeconds;

        private Integer maxHPONumberOfTrainingJobs;

        private Integer maxHPOParallelTrainingJobs;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String volumeEncryptionKMSKey;

        private String s3OutputEncryptionKMSKey;

        private Boolean enableManagedSpotTraining;

        private CustomModelTrainingParameters customModelTrainingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlModelTrainingJobRequest model) {
            super(model);
            id(model.id);
            previousModelTrainingJobId(model.previousModelTrainingJobId);
            dataProcessingJobId(model.dataProcessingJobId);
            trainModelS3Location(model.trainModelS3Location);
            sagemakerIamRoleArn(model.sagemakerIamRoleArn);
            neptuneIamRoleArn(model.neptuneIamRoleArn);
            baseProcessingInstanceType(model.baseProcessingInstanceType);
            trainingInstanceType(model.trainingInstanceType);
            trainingInstanceVolumeSizeInGB(model.trainingInstanceVolumeSizeInGB);
            trainingTimeOutInSeconds(model.trainingTimeOutInSeconds);
            maxHPONumberOfTrainingJobs(model.maxHPONumberOfTrainingJobs);
            maxHPOParallelTrainingJobs(model.maxHPOParallelTrainingJobs);
            subnets(model.subnets);
            securityGroupIds(model.securityGroupIds);
            volumeEncryptionKMSKey(model.volumeEncryptionKMSKey);
            s3OutputEncryptionKMSKey(model.s3OutputEncryptionKMSKey);
            enableManagedSpotTraining(model.enableManagedSpotTraining);
            customModelTrainingParameters(model.customModelTrainingParameters);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPreviousModelTrainingJobId() {
            return previousModelTrainingJobId;
        }

        public final void setPreviousModelTrainingJobId(String previousModelTrainingJobId) {
            this.previousModelTrainingJobId = previousModelTrainingJobId;
        }

        @Override
        public final Builder previousModelTrainingJobId(String previousModelTrainingJobId) {
            this.previousModelTrainingJobId = previousModelTrainingJobId;
            return this;
        }

        public final String getDataProcessingJobId() {
            return dataProcessingJobId;
        }

        public final void setDataProcessingJobId(String dataProcessingJobId) {
            this.dataProcessingJobId = dataProcessingJobId;
        }

        @Override
        public final Builder dataProcessingJobId(String dataProcessingJobId) {
            this.dataProcessingJobId = dataProcessingJobId;
            return this;
        }

        public final String getTrainModelS3Location() {
            return trainModelS3Location;
        }

        public final void setTrainModelS3Location(String trainModelS3Location) {
            this.trainModelS3Location = trainModelS3Location;
        }

        @Override
        public final Builder trainModelS3Location(String trainModelS3Location) {
            this.trainModelS3Location = trainModelS3Location;
            return this;
        }

        public final String getSagemakerIamRoleArn() {
            return sagemakerIamRoleArn;
        }

        public final void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
        }

        @Override
        public final Builder sagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final String getBaseProcessingInstanceType() {
            return baseProcessingInstanceType;
        }

        public final void setBaseProcessingInstanceType(String baseProcessingInstanceType) {
            this.baseProcessingInstanceType = baseProcessingInstanceType;
        }

        @Override
        public final Builder baseProcessingInstanceType(String baseProcessingInstanceType) {
            this.baseProcessingInstanceType = baseProcessingInstanceType;
            return this;
        }

        public final String getTrainingInstanceType() {
            return trainingInstanceType;
        }

        public final void setTrainingInstanceType(String trainingInstanceType) {
            this.trainingInstanceType = trainingInstanceType;
        }

        @Override
        public final Builder trainingInstanceType(String trainingInstanceType) {
            this.trainingInstanceType = trainingInstanceType;
            return this;
        }

        public final Integer getTrainingInstanceVolumeSizeInGB() {
            return trainingInstanceVolumeSizeInGB;
        }

        public final void setTrainingInstanceVolumeSizeInGB(Integer trainingInstanceVolumeSizeInGB) {
            this.trainingInstanceVolumeSizeInGB = trainingInstanceVolumeSizeInGB;
        }

        @Override
        public final Builder trainingInstanceVolumeSizeInGB(Integer trainingInstanceVolumeSizeInGB) {
            this.trainingInstanceVolumeSizeInGB = trainingInstanceVolumeSizeInGB;
            return this;
        }

        public final Integer getTrainingTimeOutInSeconds() {
            return trainingTimeOutInSeconds;
        }

        public final void setTrainingTimeOutInSeconds(Integer trainingTimeOutInSeconds) {
            this.trainingTimeOutInSeconds = trainingTimeOutInSeconds;
        }

        @Override
        public final Builder trainingTimeOutInSeconds(Integer trainingTimeOutInSeconds) {
            this.trainingTimeOutInSeconds = trainingTimeOutInSeconds;
            return this;
        }

        public final Integer getMaxHPONumberOfTrainingJobs() {
            return maxHPONumberOfTrainingJobs;
        }

        public final void setMaxHPONumberOfTrainingJobs(Integer maxHPONumberOfTrainingJobs) {
            this.maxHPONumberOfTrainingJobs = maxHPONumberOfTrainingJobs;
        }

        @Override
        public final Builder maxHPONumberOfTrainingJobs(Integer maxHPONumberOfTrainingJobs) {
            this.maxHPONumberOfTrainingJobs = maxHPONumberOfTrainingJobs;
            return this;
        }

        public final Integer getMaxHPOParallelTrainingJobs() {
            return maxHPOParallelTrainingJobs;
        }

        public final void setMaxHPOParallelTrainingJobs(Integer maxHPOParallelTrainingJobs) {
            this.maxHPOParallelTrainingJobs = maxHPOParallelTrainingJobs;
        }

        @Override
        public final Builder maxHPOParallelTrainingJobs(Integer maxHPOParallelTrainingJobs) {
            this.maxHPOParallelTrainingJobs = maxHPOParallelTrainingJobs;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVolumeEncryptionKMSKey() {
            return volumeEncryptionKMSKey;
        }

        public final void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
        }

        @Override
        public final Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
            return this;
        }

        public final String getS3OutputEncryptionKMSKey() {
            return s3OutputEncryptionKMSKey;
        }

        public final void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
        }

        @Override
        public final Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
            return this;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return enableManagedSpotTraining;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final CustomModelTrainingParameters.Builder getCustomModelTrainingParameters() {
            return customModelTrainingParameters != null ? customModelTrainingParameters.toBuilder() : null;
        }

        public final void setCustomModelTrainingParameters(CustomModelTrainingParameters.BuilderImpl customModelTrainingParameters) {
            this.customModelTrainingParameters = customModelTrainingParameters != null ? customModelTrainingParameters.build()
                    : null;
        }

        @Override
        public final Builder customModelTrainingParameters(CustomModelTrainingParameters customModelTrainingParameters) {
            this.customModelTrainingParameters = customModelTrainingParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlModelTrainingJobRequest build() {
            return new StartMlModelTrainingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
