/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ModelsCopier {
    static List<MlConfigDefinition> copy(Collection<? extends MlConfigDefinition> modelsParam) {
        List<MlConfigDefinition> list;
        if (modelsParam == null || modelsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MlConfigDefinition> modifiableList = new ArrayList<>();
            modelsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MlConfigDefinition> copyFromBuilder(Collection<? extends MlConfigDefinition.Builder> modelsParam) {
        List<MlConfigDefinition> list;
        if (modelsParam == null || modelsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MlConfigDefinition> modifiableList = new ArrayList<>();
            modelsParam.forEach(entry -> {
                MlConfigDefinition member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MlConfigDefinition.Builder> copyToBuilder(Collection<? extends MlConfigDefinition> modelsParam) {
        List<MlConfigDefinition.Builder> list;
        if (modelsParam == null || modelsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MlConfigDefinition.Builder> modifiableList = new ArrayList<>();
            modelsParam.forEach(entry -> {
                MlConfigDefinition.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
