/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManageSparqlStatisticsRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ManageSparqlStatisticsRequest.Builder, ManageSparqlStatisticsRequest> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(ManageSparqlStatisticsRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD));

    private final String mode;

    private ManageSparqlStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>, <code>ENABLE_AUTOCOMPUTE</code>, or
     * <code>REFRESH</code>, the last of which manually triggers DFE statistics generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link StatisticsAutoGenerationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modeAsString}.
     * </p>
     * 
     * @return The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>, <code>ENABLE_AUTOCOMPUTE</code>
     *         , or <code>REFRESH</code>, the last of which manually triggers DFE statistics generation.
     * @see StatisticsAutoGenerationMode
     */
    public final StatisticsAutoGenerationMode mode() {
        return StatisticsAutoGenerationMode.fromValue(mode);
    }

    /**
     * <p>
     * The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>, <code>ENABLE_AUTOCOMPUTE</code>, or
     * <code>REFRESH</code>, the last of which manually triggers DFE statistics generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link StatisticsAutoGenerationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modeAsString}.
     * </p>
     * 
     * @return The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>, <code>ENABLE_AUTOCOMPUTE</code>
     *         , or <code>REFRESH</code>, the last of which manually triggers DFE statistics generation.
     * @see StatisticsAutoGenerationMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManageSparqlStatisticsRequest)) {
            return false;
        }
        ManageSparqlStatisticsRequest other = (ManageSparqlStatisticsRequest) obj;
        return Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManageSparqlStatisticsRequest").add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManageSparqlStatisticsRequest, T> g) {
        return obj -> g.apply((ManageSparqlStatisticsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ManageSparqlStatisticsRequest> {
        /**
         * <p>
         * The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>, <code>ENABLE_AUTOCOMPUTE</code>, or
         * <code>REFRESH</code>, the last of which manually triggers DFE statistics generation.
         * </p>
         * 
         * @param mode
         *        The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>,
         *        <code>ENABLE_AUTOCOMPUTE</code>, or <code>REFRESH</code>, the last of which manually triggers DFE
         *        statistics generation.
         * @see StatisticsAutoGenerationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticsAutoGenerationMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>, <code>ENABLE_AUTOCOMPUTE</code>, or
         * <code>REFRESH</code>, the last of which manually triggers DFE statistics generation.
         * </p>
         * 
         * @param mode
         *        The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>,
         *        <code>ENABLE_AUTOCOMPUTE</code>, or <code>REFRESH</code>, the last of which manually triggers DFE
         *        statistics generation.
         * @see StatisticsAutoGenerationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticsAutoGenerationMode
         */
        Builder mode(StatisticsAutoGenerationMode mode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(ManageSparqlStatisticsRequest model) {
            super(model);
            mode(model.mode);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(StatisticsAutoGenerationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ManageSparqlStatisticsRequest build() {
            return new ManageSparqlStatisticsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
