/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSparqlStreamRequest extends NeptunedataRequest implements
        ToCopyableBuilder<GetSparqlStreamRequest.Builder, GetSparqlStreamRequest> {
    private static final SdkField<Long> LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("limit")
            .getter(getter(GetSparqlStreamRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> ITERATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iteratorType").getter(getter(GetSparqlStreamRequest::iteratorTypeAsString))
            .setter(setter(Builder::iteratorType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("iteratorType").build()).build();

    private static final SdkField<Long> COMMIT_NUM_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("commitNum")
            .getter(getter(GetSparqlStreamRequest::commitNum)).setter(setter(Builder::commitNum))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("commitNum").build()).build();

    private static final SdkField<Long> OP_NUM_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("opNum")
            .getter(getter(GetSparqlStreamRequest::opNum)).setter(setter(Builder::opNum))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("opNum").build()).build();

    private static final SdkField<String> ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encoding").getter(getter(GetSparqlStreamRequest::encodingAsString)).setter(setter(Builder::encoding))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept-Encoding").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD,
            ITERATOR_TYPE_FIELD, COMMIT_NUM_FIELD, OP_NUM_FIELD, ENCODING_FIELD));

    private final Long limit;

    private final String iteratorType;

    private final Long commitNum;

    private final Long opNum;

    private final String encoding;

    private GetSparqlStreamRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.iteratorType = builder.iteratorType;
        this.commitNum = builder.commitNum;
        this.opNum = builder.opNum;
        this.encoding = builder.encoding;
    }

    /**
     * <p>
     * Specifies the maximum number of records to return. There is also a size limit of 10 MB on the response that can't
     * be modified and that takes precedence over the number of records specified in the <code>limit</code> parameter.
     * The response does include a threshold-breaching record if the 10 MB limit was reached.
     * </p>
     * <p>
     * The range for <code>limit</code> is 1 to 100,000, with a default of 10.
     * </p>
     * 
     * @return Specifies the maximum number of records to return. There is also a size limit of 10 MB on the response
     *         that can't be modified and that takes precedence over the number of records specified in the
     *         <code>limit</code> parameter. The response does include a threshold-breaching record if the 10 MB limit
     *         was reached.</p>
     *         <p>
     *         The range for <code>limit</code> is 1 to 100,000, with a default of 10.
     */
    public final Long limit() {
        return limit;
    }

    /**
     * <p>
     * Can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence number
     * specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event sequence
     * number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in the system,
     * which is the oldest unexpired (not yet deleted) record in the change-log stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system, which is
     * the latest unexpired (not yet deleted) record in the change-log stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iteratorType} will
     * return {@link IteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iteratorTypeAsString}.
     * </p>
     * 
     * @return Can be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence number
     *         specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event
     *         sequence number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in the
     *         system, which is the oldest unexpired (not yet deleted) record in the change-log stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system,
     *         which is the latest unexpired (not yet deleted) record in the change-log stream.
     *         </p>
     *         </li>
     * @see IteratorType
     */
    public final IteratorType iteratorType() {
        return IteratorType.fromValue(iteratorType);
    }

    /**
     * <p>
     * Can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence number
     * specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event sequence
     * number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in the system,
     * which is the oldest unexpired (not yet deleted) record in the change-log stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system, which is
     * the latest unexpired (not yet deleted) record in the change-log stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iteratorType} will
     * return {@link IteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iteratorTypeAsString}.
     * </p>
     * 
     * @return Can be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence number
     *         specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event
     *         sequence number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in the
     *         system, which is the oldest unexpired (not yet deleted) record in the change-log stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system,
     *         which is the latest unexpired (not yet deleted) record in the change-log stream.
     *         </p>
     *         </li>
     * @see IteratorType
     */
    public final String iteratorTypeAsString() {
        return iteratorType;
    }

    /**
     * <p>
     * The commit number of the starting record to read from the change-log stream. This parameter is required when
     * <code>iteratorType</code> is<code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>, and ignored
     * when <code>iteratorType</code> is <code>TRIM_HORIZON</code> or <code>LATEST</code>.
     * </p>
     * 
     * @return The commit number of the starting record to read from the change-log stream. This parameter is required
     *         when <code>iteratorType</code> is<code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>,
     *         and ignored when <code>iteratorType</code> is <code>TRIM_HORIZON</code> or <code>LATEST</code>.
     */
    public final Long commitNum() {
        return commitNum;
    }

    /**
     * <p>
     * The operation sequence number within the specified commit to start reading from in the change-log stream data.
     * The default is <code>1</code>.
     * </p>
     * 
     * @return The operation sequence number within the specified commit to start reading from in the change-log stream
     *         data. The default is <code>1</code>.
     */
    public final Long opNum() {
        return opNum;
    }

    /**
     * <p>
     * If set to TRUE, Neptune compresses the response using gzip encoding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoding} will
     * return {@link Encoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingAsString}.
     * </p>
     * 
     * @return If set to TRUE, Neptune compresses the response using gzip encoding.
     * @see Encoding
     */
    public final Encoding encoding() {
        return Encoding.fromValue(encoding);
    }

    /**
     * <p>
     * If set to TRUE, Neptune compresses the response using gzip encoding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoding} will
     * return {@link Encoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingAsString}.
     * </p>
     * 
     * @return If set to TRUE, Neptune compresses the response using gzip encoding.
     * @see Encoding
     */
    public final String encodingAsString() {
        return encoding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(iteratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(commitNum());
        hashCode = 31 * hashCode + Objects.hashCode(opNum());
        hashCode = 31 * hashCode + Objects.hashCode(encodingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSparqlStreamRequest)) {
            return false;
        }
        GetSparqlStreamRequest other = (GetSparqlStreamRequest) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(iteratorTypeAsString(), other.iteratorTypeAsString())
                && Objects.equals(commitNum(), other.commitNum()) && Objects.equals(opNum(), other.opNum())
                && Objects.equals(encodingAsString(), other.encodingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSparqlStreamRequest").add("Limit", limit()).add("IteratorType", iteratorTypeAsString())
                .add("CommitNum", commitNum()).add("OpNum", opNum()).add("Encoding", encodingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "iteratorType":
            return Optional.ofNullable(clazz.cast(iteratorTypeAsString()));
        case "commitNum":
            return Optional.ofNullable(clazz.cast(commitNum()));
        case "opNum":
            return Optional.ofNullable(clazz.cast(opNum()));
        case "encoding":
            return Optional.ofNullable(clazz.cast(encodingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSparqlStreamRequest, T> g) {
        return obj -> g.apply((GetSparqlStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSparqlStreamRequest> {
        /**
         * <p>
         * Specifies the maximum number of records to return. There is also a size limit of 10 MB on the response that
         * can't be modified and that takes precedence over the number of records specified in the <code>limit</code>
         * parameter. The response does include a threshold-breaching record if the 10 MB limit was reached.
         * </p>
         * <p>
         * The range for <code>limit</code> is 1 to 100,000, with a default of 10.
         * </p>
         * 
         * @param limit
         *        Specifies the maximum number of records to return. There is also a size limit of 10 MB on the response
         *        that can't be modified and that takes precedence over the number of records specified in the
         *        <code>limit</code> parameter. The response does include a threshold-breaching record if the 10 MB
         *        limit was reached.</p>
         *        <p>
         *        The range for <code>limit</code> is 1 to 100,000, with a default of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Long limit);

        /**
         * <p>
         * Can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence number
         * specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event sequence
         * number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in the
         * system, which is the oldest unexpired (not yet deleted) record in the change-log stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system, which
         * is the latest unexpired (not yet deleted) record in the change-log stream.
         * </p>
         * </li>
         * </ul>
         * 
         * @param iteratorType
         *        Can be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence
         *        number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event
         *        sequence number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in
         *        the system, which is the oldest unexpired (not yet deleted) record in the change-log stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system,
         *        which is the latest unexpired (not yet deleted) record in the change-log stream.
         *        </p>
         *        </li>
         * @see IteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IteratorType
         */
        Builder iteratorType(String iteratorType);

        /**
         * <p>
         * Can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence number
         * specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event sequence
         * number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in the
         * system, which is the oldest unexpired (not yet deleted) record in the change-log stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system, which
         * is the latest unexpired (not yet deleted) record in the change-log stream.
         * </p>
         * </li>
         * </ul>
         * 
         * @param iteratorType
         *        Can be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence
         *        number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event
         *        sequence number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in
         *        the system, which is the oldest unexpired (not yet deleted) record in the change-log stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system,
         *        which is the latest unexpired (not yet deleted) record in the change-log stream.
         *        </p>
         *        </li>
         * @see IteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IteratorType
         */
        Builder iteratorType(IteratorType iteratorType);

        /**
         * <p>
         * The commit number of the starting record to read from the change-log stream. This parameter is required when
         * <code>iteratorType</code> is<code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>, and
         * ignored when <code>iteratorType</code> is <code>TRIM_HORIZON</code> or <code>LATEST</code>.
         * </p>
         * 
         * @param commitNum
         *        The commit number of the starting record to read from the change-log stream. This parameter is
         *        required when <code>iteratorType</code> is<code>AT_SEQUENCE_NUMBER</code> or
         *        <code>AFTER_SEQUENCE_NUMBER</code>, and ignored when <code>iteratorType</code> is
         *        <code>TRIM_HORIZON</code> or <code>LATEST</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitNum(Long commitNum);

        /**
         * <p>
         * The operation sequence number within the specified commit to start reading from in the change-log stream
         * data. The default is <code>1</code>.
         * </p>
         * 
         * @param opNum
         *        The operation sequence number within the specified commit to start reading from in the change-log
         *        stream data. The default is <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opNum(Long opNum);

        /**
         * <p>
         * If set to TRUE, Neptune compresses the response using gzip encoding.
         * </p>
         * 
         * @param encoding
         *        If set to TRUE, Neptune compresses the response using gzip encoding.
         * @see Encoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Encoding
         */
        Builder encoding(String encoding);

        /**
         * <p>
         * If set to TRUE, Neptune compresses the response using gzip encoding.
         * </p>
         * 
         * @param encoding
         *        If set to TRUE, Neptune compresses the response using gzip encoding.
         * @see Encoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Encoding
         */
        Builder encoding(Encoding encoding);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private Long limit;

        private String iteratorType;

        private Long commitNum;

        private Long opNum;

        private String encoding;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSparqlStreamRequest model) {
            super(model);
            limit(model.limit);
            iteratorType(model.iteratorType);
            commitNum(model.commitNum);
            opNum(model.opNum);
            encoding(model.encoding);
        }

        public final Long getLimit() {
            return limit;
        }

        public final void setLimit(Long limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public final String getIteratorType() {
            return iteratorType;
        }

        public final void setIteratorType(String iteratorType) {
            this.iteratorType = iteratorType;
        }

        @Override
        public final Builder iteratorType(String iteratorType) {
            this.iteratorType = iteratorType;
            return this;
        }

        @Override
        public final Builder iteratorType(IteratorType iteratorType) {
            this.iteratorType(iteratorType == null ? null : iteratorType.toString());
            return this;
        }

        public final Long getCommitNum() {
            return commitNum;
        }

        public final void setCommitNum(Long commitNum) {
            this.commitNum = commitNum;
        }

        @Override
        public final Builder commitNum(Long commitNum) {
            this.commitNum = commitNum;
            return this;
        }

        public final Long getOpNum() {
            return opNum;
        }

        public final void setOpNum(Long opNum) {
            this.opNum = opNum;
        }

        @Override
        public final Builder opNum(Long opNum) {
            this.opNum = opNum;
            return this;
        }

        public final String getEncoding() {
            return encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(Encoding encoding) {
            this.encoding(encoding == null ? null : encoding.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSparqlStreamRequest build() {
            return new GetSparqlStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
