/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSparqlStatisticsResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetSparqlStatisticsResponse.Builder, GetSparqlStatisticsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetSparqlStatisticsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Statistics> PAYLOAD_FIELD = SdkField.<Statistics> builder(MarshallingType.SDK_POJO)
            .memberName("payload").getter(getter(GetSparqlStatisticsResponse::payload)).setter(setter(Builder::payload))
            .constructor(Statistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, PAYLOAD_FIELD));

    private final String status;

    private final Statistics payload;

    private GetSparqlStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The HTTP return code of the request. If the request succeeded, the code is 200. See <a
     * href="docs.aws.amazon.comneptune/latest/userguide/neptune-dfe-statistics.html#neptune-dfe-statistics-errors"
     * >Common error codes for DFE statistics request</a> for a list of common errors.
     * </p>
     * 
     * @return The HTTP return code of the request. If the request succeeded, the code is 200. See <a
     *         href="docs.aws.amazon.comneptune/latest/userguide/neptune-dfe-statistics.html#neptune-dfe-statistics-errors"
     *         >Common error codes for DFE statistics request</a> for a list of common errors.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Statistics for RDF data.
     * </p>
     * 
     * @return Statistics for RDF data.
     */
    public final Statistics payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSparqlStatisticsResponse)) {
            return false;
        }
        GetSparqlStatisticsResponse other = (GetSparqlStatisticsResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSparqlStatisticsResponse").add("Status", status()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSparqlStatisticsResponse, T> g) {
        return obj -> g.apply((GetSparqlStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSparqlStatisticsResponse> {
        /**
         * <p>
         * The HTTP return code of the request. If the request succeeded, the code is 200. See <a href=
         * "docs.aws.amazon.comneptune/latest/userguide/neptune-dfe-statistics.html#neptune-dfe-statistics-errors"
         * >Common error codes for DFE statistics request</a> for a list of common errors.
         * </p>
         * 
         * @param status
         *        The HTTP return code of the request. If the request succeeded, the code is 200. See <a href=
         *        "docs.aws.amazon.comneptune/latest/userguide/neptune-dfe-statistics.html#neptune-dfe-statistics-errors"
         *        >Common error codes for DFE statistics request</a> for a list of common errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Statistics for RDF data.
         * </p>
         * 
         * @param payload
         *        Statistics for RDF data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Statistics payload);

        /**
         * <p>
         * Statistics for RDF data.
         * </p>
         * This is a convenience method that creates an instance of the {@link Statistics.Builder} avoiding the need to
         * create one manually via {@link Statistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Statistics.Builder#build()} is called immediately and its result
         * is passed to {@link #payload(Statistics)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link Statistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(Statistics)
         */
        default Builder payload(Consumer<Statistics.Builder> payload) {
            return payload(Statistics.builder().applyMutation(payload).build());
        }
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private Statistics payload;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSparqlStatisticsResponse model) {
            super(model);
            status(model.status);
            payload(model.payload);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Statistics.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(Statistics.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(Statistics payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public GetSparqlStatisticsResponse build() {
            return new GetSparqlStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
