/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelMlDataProcessingJobRequest extends NeptunedataRequest implements
        ToCopyableBuilder<CancelMlDataProcessingJobRequest.Builder, CancelMlDataProcessingJobRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CancelMlDataProcessingJobRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("neptuneIamRoleArn").getter(getter(CancelMlDataProcessingJobRequest::neptuneIamRoleArn))
            .setter(setter(Builder::neptuneIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("neptuneIamRoleArn").build())
            .build();

    private static final SdkField<Boolean> CLEAN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("clean")
            .getter(getter(CancelMlDataProcessingJobRequest::clean)).setter(setter(Builder::clean))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clean").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            NEPTUNE_IAM_ROLE_ARN_FIELD, CLEAN_FIELD));

    private final String id;

    private final String neptuneIamRoleArn;

    private final Boolean clean;

    private CancelMlDataProcessingJobRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.clean = builder.clean;
    }

    /**
     * <p>
     * The unique identifier of the data-processing job.
     * </p>
     * 
     * @return The unique identifier of the data-processing job.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *         listed in your DB cluster parameter group or an error will occur.
     */
    public final String neptuneIamRoleArn() {
        return neptuneIamRoleArn;
    }

    /**
     * <p>
     * If set to <code>TRUE</code>, this flag specifies that all Neptune ML S3 artifacts should be deleted when the job
     * is stopped. The default is <code>FALSE</code>.
     * </p>
     * 
     * @return If set to <code>TRUE</code>, this flag specifies that all Neptune ML S3 artifacts should be deleted when
     *         the job is stopped. The default is <code>FALSE</code>.
     */
    public final Boolean clean() {
        return clean;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clean());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelMlDataProcessingJobRequest)) {
            return false;
        }
        CancelMlDataProcessingJobRequest other = (CancelMlDataProcessingJobRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(neptuneIamRoleArn(), other.neptuneIamRoleArn())
                && Objects.equals(clean(), other.clean());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelMlDataProcessingJobRequest").add("Id", id()).add("NeptuneIamRoleArn", neptuneIamRoleArn())
                .add("Clean", clean()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "neptuneIamRoleArn":
            return Optional.ofNullable(clazz.cast(neptuneIamRoleArn()));
        case "clean":
            return Optional.ofNullable(clazz.cast(clean()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelMlDataProcessingJobRequest, T> g) {
        return obj -> g.apply((CancelMlDataProcessingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelMlDataProcessingJobRequest> {
        /**
         * <p>
         * The unique identifier of the data-processing job.
         * </p>
         * 
         * @param id
         *        The unique identifier of the data-processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed
         * in your DB cluster parameter group or an error will occur.
         * </p>
         * 
         * @param neptuneIamRoleArn
         *        The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
         *        listed in your DB cluster parameter group or an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neptuneIamRoleArn(String neptuneIamRoleArn);

        /**
         * <p>
         * If set to <code>TRUE</code>, this flag specifies that all Neptune ML S3 artifacts should be deleted when the
         * job is stopped. The default is <code>FALSE</code>.
         * </p>
         * 
         * @param clean
         *        If set to <code>TRUE</code>, this flag specifies that all Neptune ML S3 artifacts should be deleted
         *        when the job is stopped. The default is <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clean(Boolean clean);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String id;

        private String neptuneIamRoleArn;

        private Boolean clean;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelMlDataProcessingJobRequest model) {
            super(model);
            id(model.id);
            neptuneIamRoleArn(model.neptuneIamRoleArn);
            clean(model.clean);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final Boolean getClean() {
            return clean;
        }

        public final void setClean(Boolean clean) {
            this.clean = clean;
        }

        @Override
        public final Builder clean(Boolean clean) {
            this.clean = clean;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelMlDataProcessingJobRequest build() {
            return new CancelMlDataProcessingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
