/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.neptunedata.model.AccessDeniedException;
import software.amazon.awssdk.services.neptunedata.model.BadRequestException;
import software.amazon.awssdk.services.neptunedata.model.BulkLoadIdNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelledByUserException;
import software.amazon.awssdk.services.neptunedata.model.ClientTimeoutException;
import software.amazon.awssdk.services.neptunedata.model.ConcurrentModificationException;
import software.amazon.awssdk.services.neptunedata.model.ConstraintViolationException;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExpiredStreamException;
import software.amazon.awssdk.services.neptunedata.model.FailureByQueryException;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.IllegalArgumentException;
import software.amazon.awssdk.services.neptunedata.model.InternalFailureException;
import software.amazon.awssdk.services.neptunedata.model.InvalidArgumentException;
import software.amazon.awssdk.services.neptunedata.model.InvalidNumericDataException;
import software.amazon.awssdk.services.neptunedata.model.InvalidParameterException;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.LoadUrlAccessDeniedException;
import software.amazon.awssdk.services.neptunedata.model.MalformedQueryException;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.MemoryLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.MethodNotAllowedException;
import software.amazon.awssdk.services.neptunedata.model.MissingParameterException;
import software.amazon.awssdk.services.neptunedata.model.MlResourceNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataException;
import software.amazon.awssdk.services.neptunedata.model.ParsingException;
import software.amazon.awssdk.services.neptunedata.model.PreconditionsFailedException;
import software.amazon.awssdk.services.neptunedata.model.QueryLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.QueryLimitException;
import software.amazon.awssdk.services.neptunedata.model.QueryTooLargeException;
import software.amazon.awssdk.services.neptunedata.model.ReadOnlyViolationException;
import software.amazon.awssdk.services.neptunedata.model.S3Exception;
import software.amazon.awssdk.services.neptunedata.model.ServerShutdownException;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StatisticsNotAvailableException;
import software.amazon.awssdk.services.neptunedata.model.StreamRecordsNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.ThrottlingException;
import software.amazon.awssdk.services.neptunedata.model.TimeLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.TooManyRequestsException;
import software.amazon.awssdk.services.neptunedata.model.UnsupportedOperationException;
import software.amazon.awssdk.services.neptunedata.transform.CancelGremlinQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelLoaderJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CancelOpenCypherQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.CreateMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeleteMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeletePropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.DeleteSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteFastResetRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinExplainQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinProfileQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteGremlinQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteOpenCypherExplainQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ExecuteOpenCypherQueryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetEngineStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetGremlinQueryStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetLoaderJobStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlEndpointRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetOpenCypherQueryStatusRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphStreamRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetPropertygraphSummaryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetRdfGraphSummaryRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.GetSparqlStreamRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListGremlinQueriesRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListLoaderJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlDataProcessingJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlEndpointsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlModelTrainingJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListMlModelTransformJobsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ListOpenCypherQueriesRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ManagePropertygraphStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.ManageSparqlStatisticsRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartLoaderJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlDataProcessingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlModelTrainingJobRequestMarshaller;
import software.amazon.awssdk.services.neptunedata.transform.StartMlModelTransformJobRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link NeptunedataClient}.
 *
 * @see NeptunedataClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultNeptunedataClient implements NeptunedataClient {
    private static final Logger log = Logger.loggerFor(DefaultNeptunedataClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final NeptunedataServiceClientConfiguration serviceClientConfiguration;

    protected DefaultNeptunedataClient(NeptunedataServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Cancels a Gremlin query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html">Gremlin query
     * cancellation</a> for more information.
     * </p>
     *
     * @param cancelGremlinQueryRequest
     * @return Result of the CancelGremlinQuery operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelGremlinQueryResponse cancelGremlinQuery(CancelGremlinQueryRequest cancelGremlinQueryRequest)
            throws BadRequestException, InvalidParameterException, ClientTimeoutException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException,
            ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException,
            ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException,
            NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelGremlinQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelGremlinQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelGremlinQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelGremlinQuery");

            return clientHandler.execute(new ClientExecutionParams<CancelGremlinQueryRequest, CancelGremlinQueryResponse>()
                    .withOperationName("CancelGremlinQuery").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(cancelGremlinQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelGremlinQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a specified load job. This is an HTTP <code>DELETE</code> request.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     *
     * @param cancelLoaderJobRequest
     * @return Result of the CancelLoaderJob operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelLoaderJobResponse cancelLoaderJob(CancelLoaderJobRequest cancelLoaderJobRequest) throws BadRequestException,
            InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException, LoadUrlAccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, InternalFailureException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelLoaderJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelLoaderJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelLoaderJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelLoaderJob");

            return clientHandler.execute(new ClientExecutionParams<CancelLoaderJobRequest, CancelLoaderJobResponse>()
                    .withOperationName("CancelLoaderJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(cancelLoaderJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelLoaderJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a Neptune ML data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     *
     * @param cancelMlDataProcessingJobRequest
     * @return Result of the CancelMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelMlDataProcessingJobResponse cancelMLDataProcessingJob(
            CancelMlDataProcessingJobRequest cancelMlDataProcessingJobRequest) throws UnsupportedOperationException,
            BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelMlDataProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelMlDataProcessingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMlDataProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMLDataProcessingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelMlDataProcessingJobRequest, CancelMlDataProcessingJobResponse>()
                            .withOperationName("CancelMLDataProcessingJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(cancelMlDataProcessingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelMlDataProcessingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     *
     * @param cancelMlModelTrainingJobRequest
     * @return Result of the CancelMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelMlModelTrainingJobResponse cancelMLModelTrainingJob(
            CancelMlModelTrainingJobRequest cancelMlModelTrainingJobRequest) throws UnsupportedOperationException,
            BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelMlModelTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelMlModelTrainingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMlModelTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMLModelTrainingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelMlModelTrainingJobRequest, CancelMlModelTrainingJobResponse>()
                            .withOperationName("CancelMLModelTrainingJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(cancelMlModelTrainingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelMlModelTrainingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     *
     * @param cancelMlModelTransformJobRequest
     * @return Result of the CancelMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelMlModelTransformJobResponse cancelMLModelTransformJob(
            CancelMlModelTransformJobRequest cancelMlModelTransformJobRequest) throws UnsupportedOperationException,
            BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelMlModelTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelMlModelTransformJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMlModelTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMLModelTransformJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelMlModelTransformJobRequest, CancelMlModelTransformJobResponse>()
                            .withOperationName("CancelMLModelTransformJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(cancelMlModelTransformJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelMlModelTransformJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a specified openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     *
     * @param cancelOpenCypherQueryRequest
     * @return Result of the CancelOpenCypherQuery operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelOpenCypherQueryResponse cancelOpenCypherQuery(CancelOpenCypherQueryRequest cancelOpenCypherQueryRequest)
            throws InvalidNumericDataException, BadRequestException, InvalidParameterException, ClientTimeoutException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelOpenCypherQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelOpenCypherQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelOpenCypherQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelOpenCypherQuery");

            return clientHandler.execute(new ClientExecutionParams<CancelOpenCypherQueryRequest, CancelOpenCypherQueryResponse>()
                    .withOperationName("CancelOpenCypherQuery").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(cancelOpenCypherQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelOpenCypherQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training
     * process constructed. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     *
     * @param createMlEndpointRequest
     * @return Result of the CreateMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CreateMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CreateMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateMlEndpointResponse createMLEndpoint(CreateMlEndpointRequest createMlEndpointRequest)
            throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMlEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMlEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMlEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMLEndpoint");

            return clientHandler.execute(new ClientExecutionParams<CreateMlEndpointRequest, CreateMlEndpointResponse>()
                    .withOperationName("CreateMLEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createMlEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMlEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the creation of a Neptune ML inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     *
     * @param deleteMlEndpointRequest
     * @return Result of the DeleteMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeleteMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteMlEndpointResponse deleteMLEndpoint(DeleteMlEndpointRequest deleteMlEndpointRequest)
            throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMlEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteMlEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMlEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMLEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DeleteMlEndpointRequest, DeleteMlEndpointResponse>()
                    .withOperationName("DeleteMLEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteMlEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMlEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes statistics for Gremlin and openCypher (property graph) data.
     * </p>
     *
     * @param deletePropertygraphStatisticsRequest
     * @return Result of the DeletePropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeletePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeletePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePropertygraphStatisticsResponse deletePropertygraphStatistics(
            DeletePropertygraphStatisticsRequest deletePropertygraphStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePropertygraphStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePropertygraphStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deletePropertygraphStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePropertygraphStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<DeletePropertygraphStatisticsRequest, DeletePropertygraphStatisticsResponse>()
                            .withOperationName("DeletePropertygraphStatistics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deletePropertygraphStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeletePropertygraphStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes SPARQL statistics
     * </p>
     *
     * @param deleteSparqlStatisticsRequest
     * @return Result of the DeleteSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeleteSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSparqlStatisticsResponse deleteSparqlStatistics(DeleteSparqlStatisticsRequest deleteSparqlStatisticsRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSparqlStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSparqlStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSparqlStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSparqlStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSparqlStatisticsRequest, DeleteSparqlStatisticsResponse>()
                            .withOperationName("DeleteSparqlStatistics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteSparqlStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSparqlStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
     * </p>
     * <p>
     * Neptune fast reset is a two-step process. First you call <code>ExecuteFastReset</code> with <code>action</code>
     * set to <code>initiateDatabaseReset</code>. This returns a UUID token which you then include when calling
     * <code>ExecuteFastReset</code> again with <code>action</code> set to <code>performDatabaseReset</code>. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html">Empty an Amazon
     * Neptune DB cluster using the fast reset API</a>.
     * </p>
     *
     * @param executeFastResetRequest
     * @return Result of the ExecuteFastReset operation returned by the service.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws ServerShutdownException
     *         Raised when the server shuts down while processing a request.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MethodNotAllowedException
     *         Raised when the HTTP method used by a request is not supported by the endpoint being used.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteFastReset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ExecuteFastResetResponse executeFastReset(ExecuteFastResetRequest executeFastResetRequest)
            throws InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, ServerShutdownException, PreconditionsFailedException,
            MethodNotAllowedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExecuteFastResetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ExecuteFastResetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeFastResetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteFastReset");

            return clientHandler.execute(new ClientExecutionParams<ExecuteFastResetRequest, ExecuteFastResetResponse>()
                    .withOperationName("ExecuteFastReset").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(executeFastResetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExecuteFastResetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Executes a Gremlin Explain query.
     * </p>
     * <p>
     * Amazon Neptune has added a Gremlin feature named <code>explain</code> that provides is a self-service tool for
     * understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an
     * <code>explain</code> parameter to an HTTP call that submits a Gremlin query.
     * </p>
     * <p>
     * The explain feature provides information about the logical structure of query execution plans. You can use this
     * information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html">Tuning Gremlin
     * queries</a>. You can also use query hints to improve query execution plans.
     * </p>
     *
     * @param executeGremlinExplainQueryRequest
     * @return Result of the ExecuteGremlinExplainQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteGremlinExplainQueryResponse executeGremlinExplainQuery(
            ExecuteGremlinExplainQueryRequest executeGremlinExplainQueryRequest) throws QueryTooLargeException,
            BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException,
            ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException,
            UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException,
            MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<ExecuteGremlinExplainQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExecuteGremlinExplainQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeGremlinExplainQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteGremlinExplainQuery");

            return clientHandler
                    .execute(new ClientExecutionParams<ExecuteGremlinExplainQueryRequest, ExecuteGremlinExplainQueryResponse>()
                            .withOperationName("ExecuteGremlinExplainQuery").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(executeGremlinExplainQueryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExecuteGremlinExplainQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and
     * produces a profile report as output. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in
     * Neptune</a> for details.
     * </p>
     *
     * @param executeGremlinProfileQueryRequest
     * @return Result of the ExecuteGremlinProfileQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinProfileQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinProfileQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteGremlinProfileQueryResponse executeGremlinProfileQuery(
            ExecuteGremlinProfileQueryRequest executeGremlinProfileQueryRequest) throws QueryTooLargeException,
            BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException,
            ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException,
            UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException,
            MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<ExecuteGremlinProfileQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExecuteGremlinProfileQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeGremlinProfileQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteGremlinProfileQuery");

            return clientHandler
                    .execute(new ClientExecutionParams<ExecuteGremlinProfileQueryRequest, ExecuteGremlinProfileQueryResponse>()
                            .withOperationName("ExecuteGremlinProfileQuery").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(executeGremlinProfileQueryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExecuteGremlinProfileQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you
     * can use the Gremlin traversal language to query the graph, as described under <a
     * href="https://tinkerpop.apache.org/docs/current/reference/#graph">The Graph</a> in the Apache TinkerPop3
     * documentation. More details can also be found in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html">Accessing a Neptune graph
     * with Gremlin</a>.
     * </p>
     *
     * @param executeGremlinQueryRequest
     * @return Result of the ExecuteGremlinQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteGremlinQueryResponse executeGremlinQuery(ExecuteGremlinQueryRequest executeGremlinQueryRequest)
            throws QueryTooLargeException, BadRequestException, QueryLimitExceededException, InvalidParameterException,
            QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException,
            PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExecuteGremlinQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExecuteGremlinQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeGremlinQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteGremlinQuery");

            return clientHandler.execute(new ClientExecutionParams<ExecuteGremlinQueryRequest, ExecuteGremlinQueryResponse>()
                    .withOperationName("ExecuteGremlinQuery").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(executeGremlinQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExecuteGremlinQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Executes an openCypher <code>explain</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html">The openCypher
     * explain feature</a> for more information.
     * </p>
     *
     * @param executeOpenCypherExplainQueryRequest
     * @return Result of the ExecuteOpenCypherExplainQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteOpenCypherExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteOpenCypherExplainQueryResponse executeOpenCypherExplainQuery(
            ExecuteOpenCypherExplainQueryRequest executeOpenCypherExplainQueryRequest) throws QueryTooLargeException,
            InvalidNumericDataException, BadRequestException, QueryLimitExceededException, InvalidParameterException,
            QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException,
            PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<ExecuteOpenCypherExplainQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExecuteOpenCypherExplainQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                executeOpenCypherExplainQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteOpenCypherExplainQuery");

            return clientHandler
                    .execute(new ClientExecutionParams<ExecuteOpenCypherExplainQueryRequest, ExecuteOpenCypherExplainQueryResponse>()
                            .withOperationName("ExecuteOpenCypherExplainQuery").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(executeOpenCypherExplainQueryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExecuteOpenCypherExplainQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Executes an openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html">Accessing the Neptune
     * Graph with openCypher</a> for more information.
     * </p>
     * <p>
     * Neptune supports building graph applications using openCypher, which is currently one of the most popular query
     * languages among developers working with graph databases. Developers, business analysts, and data scientists like
     * openCypher's declarative, SQL-inspired syntax because it provides a familiar structure in which to querying
     * property graphs.
     * </p>
     * <p>
     * The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the <a
     * href="https://opencypher.org/">openCypher project</a> under an Apache 2 open-source license.
     * </p>
     *
     * @param executeOpenCypherQueryRequest
     * @return Result of the ExecuteOpenCypherQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteOpenCypherQueryResponse executeOpenCypherQuery(ExecuteOpenCypherQueryRequest executeOpenCypherQueryRequest)
            throws QueryTooLargeException, InvalidNumericDataException, BadRequestException, QueryLimitExceededException,
            InvalidParameterException, QueryLimitException, ClientTimeoutException, CancelledByUserException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            MemoryLimitExceededException, PreconditionsFailedException, MalformedQueryException, ParsingException,
            ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExecuteOpenCypherQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExecuteOpenCypherQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeOpenCypherQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteOpenCypherQuery");

            return clientHandler
                    .execute(new ClientExecutionParams<ExecuteOpenCypherQueryRequest, ExecuteOpenCypherQueryResponse>()
                            .withOperationName("ExecuteOpenCypherQuery").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(executeOpenCypherQueryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExecuteOpenCypherQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Check the status of the graph database on the host.
     * </p>
     *
     * @param getEngineStatusRequest
     * @return Result of the GetEngineStatus operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetEngineStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetEngineStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetEngineStatusResponse getEngineStatus(GetEngineStatusRequest getEngineStatusRequest)
            throws UnsupportedOperationException, InternalFailureException, ClientTimeoutException, PreconditionsFailedException,
            ConstraintViolationException, InvalidArgumentException, IllegalArgumentException, TooManyRequestsException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEngineStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEngineStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEngineStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEngineStatus");

            return clientHandler.execute(new ClientExecutionParams<GetEngineStatusRequest, GetEngineStatusResponse>()
                    .withOperationName("GetEngineStatus").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getEngineStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEngineStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status of a specified Gremlin query.
     * </p>
     *
     * @param getGremlinQueryStatusRequest
     * @return Result of the GetGremlinQueryStatus operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetGremlinQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetGremlinQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGremlinQueryStatusResponse getGremlinQueryStatus(GetGremlinQueryStatusRequest getGremlinQueryStatusRequest)
            throws BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGremlinQueryStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetGremlinQueryStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGremlinQueryStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGremlinQueryStatus");

            return clientHandler.execute(new ClientExecutionParams<GetGremlinQueryStatusRequest, GetGremlinQueryStatusResponse>()
                    .withOperationName("GetGremlinQueryStatus").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGremlinQueryStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGremlinQueryStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs,
     * and stores the last 10,000 error details per job.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     *
     * @param getLoaderJobStatusRequest
     * @return Result of the GetLoaderJobStatus operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetLoaderJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetLoaderJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLoaderJobStatusResponse getLoaderJobStatus(GetLoaderJobStatusRequest getLoaderJobStatusRequest)
            throws BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException,
            LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            InternalFailureException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLoaderJobStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLoaderJobStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoaderJobStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoaderJobStatus");

            return clientHandler.execute(new ClientExecutionParams<GetLoaderJobStatusRequest, GetLoaderJobStatusResponse>()
                    .withOperationName("GetLoaderJobStatus").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLoaderJobStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLoaderJobStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specified data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     *
     * @param getMlDataProcessingJobRequest
     * @return Result of the GetMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMlDataProcessingJobResponse getMLDataProcessingJob(GetMlDataProcessingJobRequest getMlDataProcessingJobRequest)
            throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlDataProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMlDataProcessingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlDataProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLDataProcessingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMlDataProcessingJobRequest, GetMlDataProcessingJobResponse>()
                            .withOperationName("GetMLDataProcessingJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getMlDataProcessingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMlDataProcessingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details about an inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     *
     * @param getMlEndpointRequest
     * @return Result of the GetMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMlEndpointResponse getMLEndpoint(GetMlEndpointRequest getMlEndpointRequest) throws UnsupportedOperationException,
            BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMlEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLEndpoint");

            return clientHandler.execute(new ClientExecutionParams<GetMlEndpointRequest, GetMlEndpointResponse>()
                    .withOperationName("GetMLEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getMlEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMlEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     *
     * @param getMlModelTrainingJobRequest
     * @return Result of the GetMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMlModelTrainingJobResponse getMLModelTrainingJob(GetMlModelTrainingJobRequest getMlModelTrainingJobRequest)
            throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlModelTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMlModelTrainingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlModelTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLModelTrainingJob");

            return clientHandler.execute(new ClientExecutionParams<GetMlModelTrainingJobRequest, GetMlModelTrainingJobResponse>()
                    .withOperationName("GetMLModelTrainingJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getMlModelTrainingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMlModelTrainingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     *
     * @param getMlModelTransformJobRequest
     * @return Result of the GetMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMlModelTransformJobResponse getMLModelTransformJob(GetMlModelTransformJobRequest getMlModelTransformJobRequest)
            throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlModelTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMlModelTransformJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMlModelTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMLModelTransformJob");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMlModelTransformJobRequest, GetMlModelTransformJobResponse>()
                            .withOperationName("GetMLModelTransformJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getMlModelTransformJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMlModelTransformJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the status of a specified openCypher query.
     * </p>
     *
     * @param getOpenCypherQueryStatusRequest
     * @return Result of the GetOpenCypherQueryStatus operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetOpenCypherQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetOpenCypherQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOpenCypherQueryStatusResponse getOpenCypherQueryStatus(
            GetOpenCypherQueryStatusRequest getOpenCypherQueryStatusRequest) throws InvalidNumericDataException,
            BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOpenCypherQueryStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetOpenCypherQueryStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpenCypherQueryStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpenCypherQueryStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOpenCypherQueryStatusRequest, GetOpenCypherQueryStatusResponse>()
                            .withOperationName("GetOpenCypherQueryStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getOpenCypherQueryStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOpenCypherQueryStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets property graph statistics (Gremlin and openCypher).
     * </p>
     *
     * @param getPropertygraphStatisticsRequest
     * @return Result of the GetPropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPropertygraphStatisticsResponse getPropertygraphStatistics(
            GetPropertygraphStatisticsRequest getPropertygraphStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPropertygraphStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPropertygraphStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertygraphStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertygraphStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPropertygraphStatisticsRequest, GetPropertygraphStatisticsResponse>()
                            .withOperationName("GetPropertygraphStatistics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getPropertygraphStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPropertygraphStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a stream for a property graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetPropertygraphStream</code> lets you collect these
     * change-log entries for a property graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     *
     * @param getPropertygraphStreamRequest
     * @return Result of the GetPropertygraphStream operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws ExpiredStreamException
     *         Raised when a request attempts to access an stream that has expired.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws StreamRecordsNotFoundException
     *         Raised when stream records requested by a query cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ThrottlingException
     *         Raised when the rate of requests exceeds the maximum throughput. Requests can be retried after
     *         encountering this exception.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPropertygraphStreamResponse getPropertygraphStream(GetPropertygraphStreamRequest getPropertygraphStreamRequest)
            throws UnsupportedOperationException, ExpiredStreamException, InvalidParameterException,
            MemoryLimitExceededException, StreamRecordsNotFoundException, ClientTimeoutException, PreconditionsFailedException,
            ThrottlingException, ConstraintViolationException, InvalidArgumentException, IllegalArgumentException,
            TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPropertygraphStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPropertygraphStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertygraphStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertygraphStream");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPropertygraphStreamRequest, GetPropertygraphStreamResponse>()
                            .withOperationName("GetPropertygraphStream").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getPropertygraphStreamRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPropertygraphStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a graph summary for a property graph.
     * </p>
     *
     * @param getPropertygraphSummaryRequest
     * @return Result of the GetPropertygraphSummary operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPropertygraphSummaryResponse getPropertygraphSummary(GetPropertygraphSummaryRequest getPropertygraphSummaryRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPropertygraphSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPropertygraphSummaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertygraphSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertygraphSummary");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPropertygraphSummaryRequest, GetPropertygraphSummaryResponse>()
                            .withOperationName("GetPropertygraphSummary").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getPropertygraphSummaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPropertygraphSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a graph summary for an RDF graph.
     * </p>
     *
     * @param getRdfGraphSummaryRequest
     * @return Result of the GetRDFGraphSummary operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetRDFGraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetRDFGraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRdfGraphSummaryResponse getRDFGraphSummary(GetRdfGraphSummaryRequest getRdfGraphSummaryRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRdfGraphSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRdfGraphSummaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRdfGraphSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRDFGraphSummary");

            return clientHandler.execute(new ClientExecutionParams<GetRdfGraphSummaryRequest, GetRdfGraphSummaryResponse>()
                    .withOperationName("GetRDFGraphSummary").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRdfGraphSummaryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRdfGraphSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets RDF statistics (SPARQL).
     * </p>
     *
     * @param getSparqlStatisticsRequest
     * @return Result of the GetSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSparqlStatisticsResponse getSparqlStatistics(GetSparqlStatisticsRequest getSparqlStatisticsRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSparqlStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSparqlStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSparqlStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSparqlStatistics");

            return clientHandler.execute(new ClientExecutionParams<GetSparqlStatisticsRequest, GetSparqlStatisticsResponse>()
                    .withOperationName("GetSparqlStatistics").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSparqlStatisticsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSparqlStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a stream for an RDF graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetSparqlStream</code> lets you collect these change-log
     * entries for an RDF graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     *
     * @param getSparqlStreamRequest
     * @return Result of the GetSparqlStream operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws ExpiredStreamException
     *         Raised when a request attempts to access an stream that has expired.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws StreamRecordsNotFoundException
     *         Raised when stream records requested by a query cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ThrottlingException
     *         Raised when the rate of requests exceeds the maximum throughput. Requests can be retried after
     *         encountering this exception.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetSparqlStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStream" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSparqlStreamResponse getSparqlStream(GetSparqlStreamRequest getSparqlStreamRequest)
            throws UnsupportedOperationException, ExpiredStreamException, InvalidParameterException,
            MemoryLimitExceededException, StreamRecordsNotFoundException, ClientTimeoutException, PreconditionsFailedException,
            ThrottlingException, ConstraintViolationException, InvalidArgumentException, IllegalArgumentException,
            TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSparqlStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSparqlStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSparqlStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSparqlStream");

            return clientHandler.execute(new ClientExecutionParams<GetSparqlStreamRequest, GetSparqlStreamResponse>()
                    .withOperationName("GetSparqlStream").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSparqlStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSparqlStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists active Gremlin queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a>
     * for details about the output.
     * </p>
     *
     * @param listGremlinQueriesRequest
     * @return Result of the ListGremlinQueries operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListGremlinQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListGremlinQueries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGremlinQueriesResponse listGremlinQueries(ListGremlinQueriesRequest listGremlinQueriesRequest)
            throws BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGremlinQueriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListGremlinQueriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGremlinQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGremlinQueries");

            return clientHandler.execute(new ClientExecutionParams<ListGremlinQueriesRequest, ListGremlinQueriesResponse>()
                    .withOperationName("ListGremlinQueries").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listGremlinQueriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGremlinQueriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the <code>loadIds</code> for all active loader jobs.
     * </p>
     *
     * @param listLoaderJobsRequest
     * @return Result of the ListLoaderJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListLoaderJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListLoaderJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListLoaderJobsResponse listLoaderJobs(ListLoaderJobsRequest listLoaderJobsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException,
            InternalFailureException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException,
            InvalidArgumentException, LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLoaderJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLoaderJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLoaderJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLoaderJobs");

            return clientHandler.execute(new ClientExecutionParams<ListLoaderJobsRequest, ListLoaderJobsResponse>()
                    .withOperationName("ListLoaderJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listLoaderJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLoaderJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of Neptune ML data processing jobs. See <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs"
     * >Listing active data-processing jobs using the Neptune ML dataprocessing command</a>.
     * </p>
     *
     * @param listMlDataProcessingJobsRequest
     * @return Result of the ListMLDataProcessingJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLDataProcessingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLDataProcessingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMlDataProcessingJobsResponse listMLDataProcessingJobs(
            ListMlDataProcessingJobsRequest listMlDataProcessingJobsRequest) throws UnsupportedOperationException,
            BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMlDataProcessingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMlDataProcessingJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlDataProcessingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLDataProcessingJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMlDataProcessingJobsRequest, ListMlDataProcessingJobsResponse>()
                            .withOperationName("ListMLDataProcessingJobs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listMlDataProcessingJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMlDataProcessingJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists existing inference endpoints. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     *
     * @param listMlEndpointsRequest
     * @return Result of the ListMLEndpoints operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListMlEndpointsResponse listMLEndpoints(ListMlEndpointsRequest listMlEndpointsRequest)
            throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMlEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMlEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLEndpoints");

            return clientHandler.execute(new ClientExecutionParams<ListMlEndpointsRequest, ListMlEndpointsResponse>()
                    .withOperationName("ListMLEndpoints").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listMlEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMlEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists Neptune ML model-training jobs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     *
     * @param listMlModelTrainingJobsRequest
     * @return Result of the ListMLModelTrainingJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLModelTrainingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTrainingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMlModelTrainingJobsResponse listMLModelTrainingJobs(ListMlModelTrainingJobsRequest listMlModelTrainingJobsRequest)
            throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMlModelTrainingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMlModelTrainingJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlModelTrainingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLModelTrainingJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMlModelTrainingJobsRequest, ListMlModelTrainingJobsResponse>()
                            .withOperationName("ListMLModelTrainingJobs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listMlModelTrainingJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMlModelTrainingJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of model transform job IDs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     *
     * @param listMlModelTransformJobsRequest
     * @return Result of the ListMLModelTransformJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLModelTransformJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTransformJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMlModelTransformJobsResponse listMLModelTransformJobs(
            ListMlModelTransformJobsRequest listMlModelTransformJobsRequest) throws UnsupportedOperationException,
            BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMlModelTransformJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMlModelTransformJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMlModelTransformJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMLModelTransformJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMlModelTransformJobsRequest, ListMlModelTransformJobsResponse>()
                            .withOperationName("ListMLModelTransformJobs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listMlModelTransformJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMlModelTransformJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists active openCypher queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     *
     * @param listOpenCypherQueriesRequest
     * @return Result of the ListOpenCypherQueries operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListOpenCypherQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListOpenCypherQueries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOpenCypherQueriesResponse listOpenCypherQueries(ListOpenCypherQueriesRequest listOpenCypherQueriesRequest)
            throws InvalidNumericDataException, BadRequestException, InvalidParameterException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            FailureByQueryException, PreconditionsFailedException, ParsingException, ReadOnlyViolationException,
            ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOpenCypherQueriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOpenCypherQueriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpenCypherQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpenCypherQueries");

            return clientHandler.execute(new ClientExecutionParams<ListOpenCypherQueriesRequest, ListOpenCypherQueriesResponse>()
                    .withOperationName("ListOpenCypherQueries").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listOpenCypherQueriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOpenCypherQueriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Manages the generation and use of property graph statistics.
     * </p>
     *
     * @param managePropertygraphStatisticsRequest
     * @return Result of the ManagePropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ManagePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManagePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ManagePropertygraphStatisticsResponse managePropertygraphStatistics(
            ManagePropertygraphStatisticsRequest managePropertygraphStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ManagePropertygraphStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ManagePropertygraphStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                managePropertygraphStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ManagePropertygraphStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<ManagePropertygraphStatisticsRequest, ManagePropertygraphStatisticsResponse>()
                            .withOperationName("ManagePropertygraphStatistics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(managePropertygraphStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ManagePropertygraphStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Manages the generation and use of RDF graph statistics.
     * </p>
     *
     * @param manageSparqlStatisticsRequest
     * @return Result of the ManageSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ManageSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManageSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ManageSparqlStatisticsResponse manageSparqlStatistics(ManageSparqlStatisticsRequest manageSparqlStatisticsRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ManageSparqlStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ManageSparqlStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, manageSparqlStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ManageSparqlStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<ManageSparqlStatisticsRequest, ManageSparqlStatisticsResponse>()
                            .withOperationName("ManageSparqlStatistics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(manageSparqlStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ManageSparqlStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html">Using the Amazon Neptune Bulk Loader
     * to Ingest Data</a>.
     * </p>
     *
     * @param startLoaderJobRequest
     * @return Result of the StartLoaderJob operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws S3Exception
     *         Raised when there is a problem accessing Amazon S3.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartLoaderJobResponse startLoaderJob(StartLoaderJobRequest startLoaderJobRequest) throws BadRequestException,
            InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException, LoadUrlAccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, InternalFailureException,
            S3Exception, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartLoaderJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartLoaderJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startLoaderJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartLoaderJob");

            return clientHandler.execute(new ClientExecutionParams<StartLoaderJobRequest, StartLoaderJobResponse>()
                    .withOperationName("StartLoaderJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startLoaderJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartLoaderJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training.
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     *
     * @param startMlDataProcessingJobRequest
     * @return Result of the StartMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartMlDataProcessingJobResponse startMLDataProcessingJob(
            StartMlDataProcessingJobRequest startMlDataProcessingJobRequest) throws UnsupportedOperationException,
            BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMlDataProcessingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartMlDataProcessingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMlDataProcessingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMLDataProcessingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartMlDataProcessingJobRequest, StartMlDataProcessingJobResponse>()
                            .withOperationName("StartMLDataProcessingJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startMlDataProcessingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartMlDataProcessingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     *
     * @param startMlModelTrainingJobRequest
     * @return Result of the StartMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartMlModelTrainingJobResponse startMLModelTrainingJob(StartMlModelTrainingJobRequest startMlModelTrainingJobRequest)
            throws UnsupportedOperationException, BadRequestException, MlResourceNotFoundException, InvalidParameterException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMlModelTrainingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartMlModelTrainingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMlModelTrainingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMLModelTrainingJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartMlModelTrainingJobRequest, StartMlModelTrainingJobResponse>()
                            .withOperationName("StartMLModelTrainingJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startMlModelTrainingJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartMlModelTrainingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     *
     * @param startMlModelTransformJobRequest
     * @return Result of the StartMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartMlModelTransformJobResponse startMLModelTransformJob(
            StartMlModelTransformJobRequest startMlModelTransformJobRequest) throws UnsupportedOperationException,
            BadRequestException, MlResourceNotFoundException, InvalidParameterException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMlModelTransformJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartMlModelTransformJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMlModelTransformJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "neptunedata");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMLModelTransformJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartMlModelTransformJobRequest, StartMlModelTransformJobResponse>()
                            .withOperationName("StartMLModelTransformJob").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startMlModelTransformJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartMlModelTransformJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(NeptunedataException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .customErrorCodeFieldName("code")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StreamRecordsNotFoundException")
                                .exceptionBuilderSupplier(StreamRecordsNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BulkLoadIdNotFoundException")
                                .exceptionBuilderSupplier(BulkLoadIdNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNumericDataException")
                                .exceptionBuilderSupplier(InvalidNumericDataException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalArgumentException")
                                .exceptionBuilderSupplier(IllegalArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LoadUrlAccessDeniedException")
                                .exceptionBuilderSupplier(LoadUrlAccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MissingParameterException")
                                .exceptionBuilderSupplier(MissingParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CancelledByUserException")
                                .exceptionBuilderSupplier(CancelledByUserException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryLimitExceededException")
                                .exceptionBuilderSupplier(QueryLimitExceededException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MemoryLimitExceededException")
                                .exceptionBuilderSupplier(MemoryLimitExceededException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParsingException")
                                .exceptionBuilderSupplier(ParsingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryTooLargeException")
                                .exceptionBuilderSupplier(QueryTooLargeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MethodNotAllowedException")
                                .exceptionBuilderSupplier(MethodNotAllowedException::builder).httpStatusCode(405).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("S3Exception").exceptionBuilderSupplier(S3Exception::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReadOnlyViolationException")
                                .exceptionBuilderSupplier(ReadOnlyViolationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StatisticsNotAvailableException")
                                .exceptionBuilderSupplier(StatisticsNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgumentException")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MLResourceNotFoundException")
                                .exceptionBuilderSupplier(MlResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConstraintViolationException")
                                .exceptionBuilderSupplier(ConstraintViolationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MalformedQueryException")
                                .exceptionBuilderSupplier(MalformedQueryException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClientTimeoutException")
                                .exceptionBuilderSupplier(ClientTimeoutException::builder).httpStatusCode(408).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionsFailedException")
                                .exceptionBuilderSupplier(PreconditionsFailedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExpiredStreamException")
                                .exceptionBuilderSupplier(ExpiredStreamException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryLimitException")
                                .exceptionBuilderSupplier(QueryLimitException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServerShutdownException")
                                .exceptionBuilderSupplier(ServerShutdownException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FailureByQueryException")
                                .exceptionBuilderSupplier(FailureByQueryException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TimeLimitExceededException")
                                .exceptionBuilderSupplier(TimeLimitExceededException::builder).httpStatusCode(500).build());
    }

    @Override
    public final NeptunedataServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
