/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptune.model.DBClusterSnapshot;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse;

public class DescribeDBClusterSnapshotsPublisher
implements SdkPublisher<DescribeDbClusterSnapshotsResponse> {
    private final NeptuneAsyncClient client;
    private final DescribeDbClusterSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBClusterSnapshotsPublisher(NeptuneAsyncClient client, DescribeDbClusterSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBClusterSnapshotsPublisher(NeptuneAsyncClient client, DescribeDbClusterSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbClusterSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbClusterSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBClusterSnapshot> dbClusterSnapshots() {
        Function<DescribeDbClusterSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterSnapshots() != null) {
                return response.dbClusterSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbClusterSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbClusterSnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeDbClusterSnapshotsResponse> {
        private DescribeDbClusterSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbClusterSnapshotsResponse> nextPage(DescribeDbClusterSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterSnapshotsPublisher.this.client.describeDBClusterSnapshots(DescribeDBClusterSnapshotsPublisher.this.firstRequest);
            }
            return DescribeDBClusterSnapshotsPublisher.this.client.describeDBClusterSnapshots((DescribeDbClusterSnapshotsRequest)((Object)DescribeDBClusterSnapshotsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

