/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Your request is invalid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestErrorException extends MTurkException implements
        ToCopyableBuilder<RequestErrorException.Builder, RequestErrorException> {
    private static final SdkField<String> TURK_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TurkErrorCode").getter(getter(RequestErrorException::turkErrorCode))
            .setter(setter(Builder::turkErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurkErrorCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TURK_ERROR_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String turkErrorCode;

    private RequestErrorException(BuilderImpl builder) {
        super(builder);
        this.turkErrorCode = builder.turkErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the TurkErrorCode property for this object.
     * 
     * @return The value of the TurkErrorCode property for this object.
     */
    public String turkErrorCode() {
        return turkErrorCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestErrorException, T> g) {
        return obj -> g.apply((RequestErrorException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestErrorException>, MTurkException.Builder {
        /**
         * Sets the value of the TurkErrorCode property for this object.
         *
         * @param turkErrorCode
         *        The new value for the TurkErrorCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turkErrorCode(String turkErrorCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends MTurkException.BuilderImpl implements Builder {
        private String turkErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestErrorException model) {
            super(model);
            turkErrorCode(model.turkErrorCode);
        }

        public final String getTurkErrorCode() {
            return turkErrorCode;
        }

        public final void setTurkErrorCode(String turkErrorCode) {
            this.turkErrorCode = turkErrorCode;
        }

        @Override
        public final Builder turkErrorCode(String turkErrorCode) {
            this.turkErrorCode = turkErrorCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public RequestErrorException build() {
            return new RequestErrorException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
