/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse;

public class ListWorkersWithQualificationTypeIterable
implements SdkIterable<ListWorkersWithQualificationTypeResponse> {
    private final MTurkClient client;
    private final ListWorkersWithQualificationTypeRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkersWithQualificationTypeIterable(MTurkClient client, ListWorkersWithQualificationTypeRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkersWithQualificationTypeResponseFetcher();
    }

    public Iterator<ListWorkersWithQualificationTypeResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWorkersWithQualificationTypeResponseFetcher
    implements SyncPageFetcher<ListWorkersWithQualificationTypeResponse> {
        private ListWorkersWithQualificationTypeResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkersWithQualificationTypeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkersWithQualificationTypeResponse nextPage(ListWorkersWithQualificationTypeResponse previousPage) {
            if (previousPage == null) {
                return ListWorkersWithQualificationTypeIterable.this.client.listWorkersWithQualificationType(ListWorkersWithQualificationTypeIterable.this.firstRequest);
            }
            return ListWorkersWithQualificationTypeIterable.this.client.listWorkersWithQualificationType((ListWorkersWithQualificationTypeRequest)((Object)ListWorkersWithQualificationTypeIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

