/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.internal.UserAgentUtils;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse;

public class ListBonusPaymentsIterable
implements SdkIterable<ListBonusPaymentsResponse> {
    private final MTurkClient client;
    private final ListBonusPaymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBonusPaymentsIterable(MTurkClient client, ListBonusPaymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBonusPaymentsResponseFetcher();
    }

    public Iterator<ListBonusPaymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBonusPaymentsResponseFetcher
    implements SyncPageFetcher<ListBonusPaymentsResponse> {
        private ListBonusPaymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListBonusPaymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBonusPaymentsResponse nextPage(ListBonusPaymentsResponse previousPage) {
            if (previousPage == null) {
                return ListBonusPaymentsIterable.this.client.listBonusPayments(ListBonusPaymentsIterable.this.firstRequest);
            }
            return ListBonusPaymentsIterable.this.client.listBonusPayments((ListBonusPaymentsRequest)((Object)ListBonusPaymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

